/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.profile;

import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.Configuration;
import java.util.Objects;

public class AzureProfile {
    private final String tenantId;
    private final String subscriptionId;
    private final AzureEnvironment environment;

    public AzureProfile(AzureEnvironment environment) {
        Objects.requireNonNull(environment);
        this.environment = environment;
        Configuration configuration = Configuration.getGlobalConfiguration();
        this.tenantId = configuration.get("AZURE_TENANT_ID");
        this.subscriptionId = configuration.get("AZURE_SUBSCRIPTION_ID");
    }

    public AzureProfile(String tenantId, String subscriptionId, AzureEnvironment environment) {
        Objects.requireNonNull(environment);
        this.tenantId = tenantId;
        this.subscriptionId = subscriptionId;
        this.environment = environment;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public AzureEnvironment getEnvironment() {
        return this.environment;
    }
}

