/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaders;
import com.azure.core.management.implementation.polling.Error;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;

final class ProvisioningStateData {
    @JsonProperty(value="pollUrl", required=true)
    private URL pollUrl;
    @JsonProperty(value="provisioningState", required=true)
    private String provisioningState;
    @JsonProperty(value="pollError")
    private Error pollError;
    @JsonProperty(value="finalResult")
    private FinalResult finalResult;

    ProvisioningStateData() {
    }

    ProvisioningStateData(URL pollUrl, String provisioningState) {
        this.pollUrl = Objects.requireNonNull(pollUrl, "'pollUrl' cannot be null.");
        this.provisioningState = Objects.requireNonNull(provisioningState, "'provisioningState' cannot be null.");
    }

    String getProvisioningState() {
        return this.provisioningState;
    }

    URL getPollUrl() {
        return this.pollUrl;
    }

    Error getPollError() {
        return this.pollError;
    }

    FinalResult getFinalResult() {
        return this.finalResult;
    }

    void update(int pollResponseStatusCode, HttpHeaders pollResponseHeaders, String pollResponseBody, SerializerAdapter adapter) {
        if (pollResponseStatusCode != 200) {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling failed with status code:" + pollResponseStatusCode, pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
        } else {
            String value = ProvisioningStateData.tryParseProvisioningState(pollResponseBody, adapter);
            if (value == null) {
                this.provisioningState = "Failed";
                this.pollError = new Error("Polling response does not contain a valid body.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            } else {
                this.provisioningState = value;
                if ("Failed".equalsIgnoreCase(this.provisioningState) || "Canceled".equalsIgnoreCase(this.provisioningState)) {
                    this.pollError = new Error("Long running operation failed or cancelled.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
                } else if ("Succeeded".equalsIgnoreCase(this.provisioningState)) {
                    this.finalResult = new FinalResult(null, pollResponseBody);
                }
            }
        }
    }

    static String tryParseProvisioningState(String value, SerializerAdapter adapter) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            ResourceWithProvisioningState resource = (ResourceWithProvisioningState)adapter.deserialize(value, ResourceWithProvisioningState.class, SerializerEncoding.JSON);
            return resource != null ? resource.getProvisioningState() : null;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private static class ResourceWithProvisioningState {
        @JsonProperty(value="properties")
        private Properties properties;

        private ResourceWithProvisioningState() {
        }

        private String getProvisioningState() {
            if (this.properties != null) {
                return this.properties.provisioningState;
            }
            return null;
        }

        private static class Properties {
            @JsonProperty(value="provisioningState")
            private String provisioningState;

            private Properties() {
            }
        }
    }
}

