/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpHeaders;
import com.azure.core.management.implementation.polling.Error;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.management.implementation.polling.Util;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URL;
import java.util.Objects;

final class LocationData {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LocationData.class);
    @JsonProperty(value="pollUrl", required=true)
    private URL pollUrl;
    @JsonProperty(value="provisioningState", required=true)
    private String provisioningState;
    @JsonProperty(value="pollError")
    private Error pollError;
    @JsonProperty(value="finalResult")
    private FinalResult finalResult;

    LocationData() {
    }

    LocationData(URL pollUrl) {
        this.pollUrl = Objects.requireNonNull(pollUrl, "'pollUrl' cannot be null.");
        this.provisioningState = "InProgress";
    }

    String getProvisioningState() {
        return this.provisioningState;
    }

    URL getPollUrl() {
        return this.pollUrl;
    }

    Error getPollError() {
        return this.pollError;
    }

    FinalResult getFinalResult() {
        return this.finalResult;
    }

    void update(int pollResponseStatusCode, HttpHeaders pollResponseHeaders, String pollResponseBody) {
        if (pollResponseStatusCode == 202) {
            try {
                this.provisioningState = "InProgress";
                URL locationUrl = Util.getLocationUrl(pollResponseHeaders, this.logger);
                if (locationUrl != null) {
                    this.pollUrl = locationUrl;
                }
            }
            catch (Util.MalformedUrlException mue) {
                this.provisioningState = "Failed";
                this.pollError = new Error("Long running operation contains a malformed Location header.", pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
            }
        } else if (pollResponseStatusCode == 200 || pollResponseStatusCode == 201 || pollResponseStatusCode == 204) {
            this.provisioningState = "Succeeded";
            if (pollResponseBody != null) {
                this.finalResult = new FinalResult(null, pollResponseBody);
            }
        } else {
            this.provisioningState = "Failed";
            this.pollError = new Error("Polling failed with status code:" + pollResponseStatusCode, pollResponseStatusCode, pollResponseHeaders.toMap(), pollResponseBody);
        }
    }
}

