/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.http.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.management.implementation.http.AuthenticationChallenge;
import com.azure.core.util.CoreUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

public class ArmChallengeAuthenticationPolicy
extends BearerTokenAuthenticationPolicy {
    private static final Pattern AUTHENTICATION_CHALLENGE_PATTERN = Pattern.compile("(\\w+) ((?:\\w+=\".*?\"(?:, )?)+)(?:, )?");
    private static final Pattern AUTHENTICATION_CHALLENGE_PARAMS_PATTERN = Pattern.compile("(?:(\\w+)=\"([^\"\"]*)\")+");
    private static final String CLAIMS_PARAMETER = "claims";
    private static final String ARM_SCOPES_KEY = "ARMScopes";
    private final String[] scopes;

    public ArmChallengeAuthenticationPolicy(TokenCredential credential, String ... scopes) {
        super(credential, scopes);
        this.scopes = scopes;
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        return Mono.defer(() -> {
            String[] scopes = this.scopes;
            if ((scopes = this.getScopes(context, scopes)) == null) {
                return Mono.empty();
            }
            context.setData(ARM_SCOPES_KEY, (Object)scopes);
            return this.setAuthorizationHeader(context, new TokenRequestContext().addScopes(scopes));
        });
    }

    public void authorizeRequestSync(HttpPipelineCallContext context) {
        String[] scopes = this.scopes;
        if ((scopes = this.getScopes(context, scopes)) != null) {
            context.setData(ARM_SCOPES_KEY, (Object)scopes);
            this.setAuthorizationHeaderSync(context, new TokenRequestContext().addScopes(scopes));
        }
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.defer(() -> {
            String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
            if (response.getStatusCode() == 401 && authHeader != null) {
                List<AuthenticationChallenge> challenges = this.parseChallenges(authHeader);
                for (AuthenticationChallenge authenticationChallenge : challenges) {
                    Map<String, String> extractedChallengeParams = this.parseChallengeParams(authenticationChallenge.getChallengeParameters());
                    if (!extractedChallengeParams.containsKey(CLAIMS_PARAMETER)) continue;
                    String claims = new String(Base64.getUrlDecoder().decode(extractedChallengeParams.get(CLAIMS_PARAMETER)), StandardCharsets.UTF_8);
                    String[] scopes = context.getData(ARM_SCOPES_KEY).orElse(this.scopes);
                    scopes = this.getScopes(context, scopes);
                    return this.setAuthorizationHeader(context, new TokenRequestContext().addScopes(scopes).setClaims(claims)).thenReturn((Object)true);
                }
            }
            return Mono.just((Object)false);
        });
    }

    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (response.getStatusCode() == 401 && authHeader != null) {
            List<AuthenticationChallenge> challenges = this.parseChallenges(authHeader);
            for (AuthenticationChallenge authenticationChallenge : challenges) {
                Map<String, String> extractedChallengeParams = this.parseChallengeParams(authenticationChallenge.getChallengeParameters());
                if (!extractedChallengeParams.containsKey(CLAIMS_PARAMETER)) continue;
                String claims = new String(Base64.getUrlDecoder().decode(extractedChallengeParams.get(CLAIMS_PARAMETER)), StandardCharsets.UTF_8);
                String[] scopes = context.getData(ARM_SCOPES_KEY).orElse(this.scopes);
                scopes = this.getScopes(context, scopes);
                this.setAuthorizationHeaderSync(context, new TokenRequestContext().addScopes(scopes).setClaims(claims));
                return true;
            }
        }
        return false;
    }

    public String[] getScopes(HttpPipelineCallContext context, String[] scopes) {
        return (String[])CoreUtils.clone((Object[])scopes);
    }

    List<AuthenticationChallenge> parseChallenges(String header) {
        Matcher matcher = AUTHENTICATION_CHALLENGE_PATTERN.matcher(header);
        ArrayList<AuthenticationChallenge> challenges = new ArrayList<AuthenticationChallenge>();
        while (matcher.find()) {
            challenges.add(new AuthenticationChallenge(matcher.group(1), matcher.group(2)));
        }
        return challenges;
    }

    Map<String, String> parseChallengeParams(String challengeParams) {
        Matcher matcher = AUTHENTICATION_CHALLENGE_PARAMS_PATTERN.matcher(challengeParams);
        HashMap<String, String> challengeParameters = new HashMap<String, String>();
        while (matcher.find()) {
            challengeParameters.put(matcher.group(1), matcher.group(2));
        }
        return challengeParameters;
    }
}

