/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.exception;

import com.azure.core.management.exception.AdditionalInfo;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.List;

public class ManagementError
implements JsonSerializable<ManagementError> {
    @JsonProperty(value="code", access=JsonProperty.Access.WRITE_ONLY)
    private String code;
    @JsonProperty(value="message", access=JsonProperty.Access.WRITE_ONLY)
    private String message;
    @JsonProperty(value="target", access=JsonProperty.Access.WRITE_ONLY)
    private String target;
    @JsonProperty(value="details", access=JsonProperty.Access.WRITE_ONLY)
    private List<ManagementError> details;
    @JsonProperty(value="additionalInfo", access=JsonProperty.Access.WRITE_ONLY)
    private List<AdditionalInfo> additionalInfo;

    public ManagementError() {
    }

    public ManagementError(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String message) {
        this.message = message;
    }

    public String getTarget() {
        return this.target;
    }

    void setTarget(String target) {
        this.target = target;
    }

    public List<? extends ManagementError> getDetails() {
        return this.details;
    }

    void setDetails(List<ManagementError> details) {
        this.details = details;
    }

    public List<AdditionalInfo> getAdditionalInfo() {
        return this.additionalInfo;
    }

    void setAdditionalInfo(List<AdditionalInfo> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String toString() {
        return this.message == null ? super.toString() : this.message;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("code", this.code).writeStringField("message", this.message).writeStringField("target", this.target).writeArrayField("details", this.details, JsonWriter::writeJson).writeArrayField("additionalInfo", this.additionalInfo, JsonWriter::writeJson).writeEndObject();
    }

    public static ManagementError fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementError)jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return ManagementError.readManagementError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return ManagementError.readManagementError(bufferedReader.reset());
        });
    }

    private static ManagementError readManagementError(JsonReader jsonReader) throws IOException {
        return (ManagementError)jsonReader.readObject(reader -> {
            ManagementError managementError = new ManagementError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equalsIgnoreCase(fieldName)) {
                    managementError.code = reader.getString();
                    continue;
                }
                if ("message".equalsIgnoreCase(fieldName)) {
                    managementError.message = reader.getString();
                    continue;
                }
                if ("target".equalsIgnoreCase(fieldName)) {
                    managementError.target = reader.getString();
                    continue;
                }
                if ("details".equalsIgnoreCase(fieldName)) {
                    managementError.details = reader.readArray(ManagementError::fromJson);
                    continue;
                }
                if ("additionalInfo".equalsIgnoreCase(fieldName)) {
                    managementError.additionalInfo = reader.readArray(AdditionalInfo::fromJson);
                    continue;
                }
                reader.skipChildren();
            }
            return managementError;
        });
    }
}

