/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.polling;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.management.implementation.polling.SyncPollOperation;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.function.Supplier;

public final class SyncPollerFactory {
    private SyncPollerFactory() {
    }

    public static <T, U> SyncPoller<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Duration defaultPollDuration, Supplier<Response<BinaryData>> lroInitialResponseSupplier) {
        return SyncPollerFactory.create(serializerAdapter, httpPipeline, pollResultType, finalResultType, defaultPollDuration, lroInitialResponseSupplier, Context.NONE);
    }

    public static <T, U> SyncPoller<PollResult<T>, U> create(SerializerAdapter serializerAdapter, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Duration defaultPollDuration, Supplier<Response<BinaryData>> lroInitialResponseSupplier, Context context) {
        return SyncPoller.createPoller((Duration)defaultPollDuration, SyncPollOperation.activationFunction(serializerAdapter, pollResultType, lroInitialResponseSupplier), SyncPollOperation.pollFunction(serializerAdapter, httpPipeline, pollResultType, context), SyncPollOperation.cancelFunction(context), SyncPollOperation.fetchResultFunction(serializerAdapter, httpPipeline, finalResultType, context));
    }
}

