/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management.implementation.polling;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.implementation.polling.FinalResult;
import com.azure.core.management.implementation.polling.PollOperation;
import com.azure.core.management.implementation.polling.PollingState;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.serializer.SerializerAdapter;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SyncPollOperation {
    public static <T> Function<PollingContext<PollResult<T>>, PollResponse<PollResult<T>>> activationFunction(SerializerAdapter serializerAdapter, Type pollResultType, Supplier<Response<BinaryData>> lroInitialResponseSupplier) {
        return pollingContext -> {
            Response response = (Response)lroInitialResponseSupplier.get();
            PollingState state = PollingState.create(serializerAdapter, response.getRequest(), response.getStatusCode(), response.getHeaders(), ((BinaryData)response.getValue()).toString());
            state.store(pollingContext);
            Object result = PollOperation.deserialize(serializerAdapter, ((BinaryData)response.getValue()).toString(), pollResultType);
            return new PollResponse(state.getOperationStatus(), new PollResult(result), state.getPollDelay());
        };
    }

    public static <T> Function<PollingContext<PollResult<T>>, PollResponse<PollResult<T>>> pollFunction(SerializerAdapter serializerAdapter, HttpPipeline httpPipeline, Type pollResultType, Context context) {
        return pollingContext -> {
            PollingState state = PollingState.from(serializerAdapter, pollingContext);
            if (state.getOperationStatus().isComplete()) {
                return PollOperation.pollResponseFromPollingState(serializerAdapter, pollResultType, state);
            }
            try (HttpResponse response = httpPipeline.sendSync(new HttpRequest(HttpMethod.GET, state.getPollUrl()), context);){
                String body = response.getBodyAsBinaryData().toString();
                state.update(response.getStatusCode(), response.getHeaders(), body);
                state.store(pollingContext);
                PollResponse pollResponse = PollOperation.pollResponseFromPollingState(serializerAdapter, pollResultType, state);
                return pollResponse;
            }
        };
    }

    public static <T> BiFunction<PollingContext<PollResult<T>>, PollResponse<PollResult<T>>, PollResult<T>> cancelFunction(Context context) {
        return (pollingContext, pollResultPollResponse) -> null;
    }

    public static <T, U> Function<PollingContext<T>, U> fetchResultFunction(SerializerAdapter serializerAdapter, HttpPipeline httpPipeline, Type finalResultType, Context context) {
        return pollingContext -> {
            Object result;
            PollingState state = PollingState.from(serializerAdapter, pollingContext);
            FinalResult finalResult = state.getFinalResult();
            if (finalResult == null) {
                return null;
            }
            String value = finalResult.getResult();
            if (value != null) {
                result = PollOperation.deserialize(serializerAdapter, value, finalResultType);
            } else {
                try (HttpResponse response = httpPipeline.sendSync(new HttpRequest(HttpMethod.GET, finalResult.getResultUri()), context);){
                    result = PollOperation.deserialize(serializerAdapter, response.getBodyAsBinaryData().toString(), finalResultType);
                }
            }
            return result;
        };
    }
}

