/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.management;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Region {
    private static final ConcurrentMap<String, Region> VALUES_BY_NAME = new ConcurrentHashMap<String, Region>();
    public static final Region US_EAST = new Region("eastus", "East US");
    public static final Region US_EAST2 = new Region("eastus2", "East US 2");
    public static final Region US_SOUTH_CENTRAL = new Region("southcentralus", "South Central US");
    public static final Region US_WEST2 = new Region("westus2", "West US 2");
    public static final Region US_CENTRAL = new Region("centralus", "Central US");
    public static final Region US_NORTH_CENTRAL = new Region("northcentralus", "North Central US");
    public static final Region US_WEST = new Region("westus", "West US");
    public static final Region US_WEST_CENTRAL = new Region("westcentralus", "West Central US");
    public static final Region US_WEST3 = new Region("westus3", "West US 3");
    public static final Region CANADA_CENTRAL = new Region("canadacentral", "Canada Central");
    public static final Region CANADA_EAST = new Region("canadaeast", "Canada East");
    public static final Region BRAZIL_SOUTH = new Region("brazilsouth", "Brazil South");
    public static final Region BRAZIL_SOUTHEAST = new Region("brazilsoutheast", "Brazil Southeast");
    public static final Region EUROPE_NORTH = new Region("northeurope", "North Europe");
    public static final Region UK_SOUTH = new Region("uksouth", "UK South");
    public static final Region EUROPE_WEST = new Region("westeurope", "West Europe");
    public static final Region FRANCE_CENTRAL = new Region("francecentral", "France Central");
    public static final Region GERMANY_WEST_CENTRAL = new Region("germanywestcentral", "Germany West Central");
    public static final Region NORWAY_EAST = new Region("norwayeast", "Norway East");
    public static final Region SWITZERLAND_NORTH = new Region("switzerlandnorth", "Switzerland North");
    public static final Region SWEDEN_CENTRAL = new Region("swedencentral", "Sweden Central");
    public static final Region FRANCE_SOUTH = new Region("francesouth", "France South");
    public static final Region GERMANY_NORTH = new Region("germanynorth", "Germany North");
    public static final Region NORWAY_WEST = new Region("norwaywest", "Norway West");
    public static final Region SWITZERLAND_WEST = new Region("switzerlandwest", "Switzerland West");
    public static final Region UK_WEST = new Region("ukwest", "UK West");
    public static final Region AUSTRALIA_EAST = new Region("australiaeast", "Australia East");
    public static final Region ASIA_SOUTHEAST = new Region("southeastasia", "Southeast Asia");
    public static final Region INDIA_CENTRAL = new Region("centralindia", "Central India");
    public static final Region ASIA_EAST = new Region("eastasia", "East Asia");
    public static final Region JAPAN_EAST = new Region("japaneast", "Japan East");
    public static final Region KOREA_CENTRAL = new Region("koreacentral", "Korea Central");
    public static final Region AUSTRALIA_CENTRAL = new Region("australiacentral", "Australia Central");
    public static final Region AUSTRALIA_CENTRAL2 = new Region("australiacentral2", "Australia Central 2");
    public static final Region AUSTRALIA_SOUTHEAST = new Region("australiasoutheast", "Australia Southeast");
    public static final Region JAPAN_WEST = new Region("japanwest", "Japan West");
    public static final Region KOREA_SOUTH = new Region("koreasouth", "Korea South");
    public static final Region INDIA_SOUTH = new Region("southindia", "South India");
    public static final Region INDIA_WEST = new Region("westindia", "West India");
    public static final Region UAE_NORTH = new Region("uaenorth", "UAE North");
    public static final Region UAE_CENTRAL = new Region("uaecentral", "UAE Central");
    public static final Region SOUTHAFRICA_NORTH = new Region("southafricanorth", "South Africa North");
    public static final Region SOUTHAFRICA_WEST = new Region("southafricawest", "South Africa West");
    public static final Region CHINA_NORTH = new Region("chinanorth", "China North");
    public static final Region CHINA_EAST = new Region("chinaeast", "China East");
    public static final Region CHINA_NORTH2 = new Region("chinanorth2", "China North 2");
    public static final Region CHINA_EAST2 = new Region("chinaeast2", "China East 2");
    public static final Region CHINA_NORTH3 = new Region("chinanorth3", "China North 3");
    public static final Region CHINA_EAST3 = new Region("chinaeast3", "China East 3");
    public static final Region GERMANY_CENTRAL = new Region("germanycentral", "Germany Central");
    public static final Region GERMANY_NORTHEAST = new Region("germanynortheast", "Germany Northeast");
    public static final Region GOV_US_VIRGINIA = new Region("usgovvirginia", "US Gov Virginia");
    public static final Region GOV_US_IOWA = new Region("usgoviowa", "US Gov Iowa");
    public static final Region GOV_US_ARIZONA = new Region("usgovarizona", "US Gov Arizona");
    public static final Region GOV_US_TEXAS = new Region("usgovtexas", "US Gov Texas");
    public static final Region GOV_US_DOD_EAST = new Region("usdodeast", "US DoD East");
    public static final Region GOV_US_DOD_CENTRAL = new Region("usdodcentral", "US DoD Central");
    private final String name;
    private final String label;

    public static Collection<Region> values() {
        return VALUES_BY_NAME.values();
    }

    private Region(String name, String label) {
        this.name = name;
        this.label = label;
        VALUES_BY_NAME.put(name.toLowerCase(Locale.ROOT), this);
    }

    public static Region create(String name, String label) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Region region = (Region)VALUES_BY_NAME.get(name.toLowerCase(Locale.ROOT));
        if (region != null) {
            return region;
        }
        return new Region(name, label);
    }

    @JsonValue
    public String toString() {
        return this.name();
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public static Region fromName(String name) {
        if (name == null) {
            return null;
        }
        Region region = (Region)VALUES_BY_NAME.get(name.toLowerCase(Locale.ROOT).replace(" ", ""));
        if (region != null) {
            return region;
        }
        return Region.create(name.toLowerCase(Locale.ROOT).replace(" ", ""), name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Region)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Region rhs = (Region)obj;
        return this.name.equalsIgnoreCase(rhs.name);
    }
}

