/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.metrics.opentelemetry;

import com.azure.core.metrics.opentelemetry.OpenTelemetryAttributes;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.logging.ClientLogger;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import java.util.Optional;

class OpenTelemetryUtils {
    private static boolean warnedOnContextType = false;
    private static boolean warnedOnBuilderType = false;
    private static final ClientLogger LOGGER = new ClientLogger(OpenTelemetryUtils.class);

    OpenTelemetryUtils() {
    }

    static void addAttribute(AttributesBuilder attributesBuilder, String key, Object value) {
        if (value instanceof Boolean) {
            attributesBuilder.put(AttributeKey.booleanKey((String)key), (Object)((Boolean)value));
        } else if (value instanceof String) {
            attributesBuilder.put(AttributeKey.stringKey((String)key), (Object)((String)value));
        } else if (value instanceof Double) {
            attributesBuilder.put(AttributeKey.doubleKey((String)key), (Object)((Double)value));
        } else if (value instanceof Float) {
            attributesBuilder.put(AttributeKey.doubleKey((String)key), (Object)((Float)value).doubleValue());
        } else if (value instanceof Long) {
            attributesBuilder.put(AttributeKey.longKey((String)key), (Object)((Long)value));
        } else if (value instanceof Integer) {
            attributesBuilder.put(AttributeKey.longKey((String)key), ((Integer)value).intValue());
        } else if (value instanceof Short) {
            attributesBuilder.put(AttributeKey.longKey((String)key), (int)((Short)value).shortValue());
        } else if (value instanceof Byte) {
            attributesBuilder.put(AttributeKey.longKey((String)key), (int)((Byte)value).byteValue());
        } else {
            LOGGER.warning("Could not populate attribute with key '{}', type '{}' is not supported.", new Object[]{key, value.getClass().getName()});
        }
    }

    static Context getTraceContextOrCurrent(com.azure.core.util.Context azContext) {
        Optional traceContextOpt = azContext.getData((Object)"trace-context");
        if (traceContextOpt.isPresent()) {
            Object traceContextObj = traceContextOpt.get();
            if (traceContextObj instanceof Context) {
                return (Context)traceContextObj;
            }
            if (traceContextObj != null && !warnedOnContextType) {
                LOGGER.warning("Expected instance of `io.opentelemetry.context.Context` under `PARENT_TRACE_CONTEXT_KEY`, but got {}, ignoring it.", new Object[]{traceContextObj.getClass().getName()});
                warnedOnContextType = true;
            }
        }
        return Context.current();
    }

    static Attributes getAttributes(TelemetryAttributes attributesBuilder) {
        if (attributesBuilder instanceof OpenTelemetryAttributes) {
            return ((OpenTelemetryAttributes)attributesBuilder).get();
        }
        if (attributesBuilder != null && !warnedOnBuilderType) {
            LOGGER.warning("Expected instance of `OpenTelemetryAttributeBuilder` in `attributeCollection`, but got {}, ignoring it.", new Object[]{attributesBuilder.getClass().getName()});
            warnedOnBuilderType = true;
        }
        return Attributes.empty();
    }
}

