/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.avro.apache;

import com.azure.core.experimental.serializer.AvroSerializer;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import reactor.core.publisher.Mono;

public class ApacheAvroSerializer
implements AvroSerializer {
    private final ClientLogger logger = new ClientLogger(ApacheAvroSerializer.class);
    private final Schema schema;
    private final DecoderFactory decoderFactory;
    private final EncoderFactory encoderFactory;
    private final SpecificData specificData;

    ApacheAvroSerializer(Schema schema, DecoderFactory decoderFactory, EncoderFactory encoderFactory, SpecificData specificData) {
        this.schema = schema;
        this.decoderFactory = decoderFactory;
        this.encoderFactory = encoderFactory;
        this.specificData = specificData;
    }

    public <T> T deserializeFromBytes(byte[] data, TypeReference<T> typeReference) {
        return this.deserialize(data, () -> this.decoderFactory.binaryDecoder(data, null));
    }

    public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
        return this.deserialize((Object)stream, () -> this.decoderFactory.binaryDecoder(stream, null));
    }

    private <T> T deserialize(Object data, Supplier<Decoder> decoderSupplier) {
        if (data == null) {
            return null;
        }
        SpecificDatumReader reader = new SpecificDatumReader(this.schema, this.schema, this.specificData);
        try {
            return (T)reader.read(null, decoderSupplier.get());
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public <T> Mono<T> deserializeFromBytesAsync(byte[] data, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserializeFromBytes(data, typeReference));
    }

    public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserialize(stream, typeReference));
    }

    public void serialize(OutputStream stream, Object value) {
        SpecificDatumWriter writer = new SpecificDatumWriter(this.schema, this.specificData);
        BinaryEncoder encoder = this.encoderFactory.binaryEncoder(stream, null);
        try {
            writer.write(value, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    public Mono<Void> serializeAsync(OutputStream stream, Object value) {
        return Mono.fromRunnable(() -> this.serialize(stream, value));
    }
}

