/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.gson.implementation;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.serializer.json.gson.implementation.GsonJsonReader;
import com.azure.core.serializer.json.gson.implementation.GsonJsonWriter;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonSerializable;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

public class JsonSerializableTypeAdapter
extends TypeAdapter<JsonSerializable<?>> {
    private static final ClientLogger LOGGER = new ClientLogger(JsonSerializableTypeAdapter.class);
    private final Class<? extends JsonSerializable<?>> jsonSerializableType;
    private final MethodHandle readJson;

    public JsonSerializableTypeAdapter(Class<? extends JsonSerializable<?>> jsonSerializableType) {
        this.jsonSerializableType = jsonSerializableType;
        try {
            MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(jsonSerializableType);
            this.readJson = lookup.unreflect(jsonSerializableType.getDeclaredMethod("fromJson", com.azure.json.JsonReader.class));
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public void write(JsonWriter out, JsonSerializable<?> value) throws IOException {
        new GsonJsonWriter(out).writeJson(value);
    }

    public JsonSerializable<?> read(JsonReader in) throws IOException {
        try {
            return this.jsonSerializableType.cast(this.readJson.invokeWithArguments(new Object[]{new GsonJsonReader(in, null, true)}));
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof Exception) {
                throw new IOException(e);
            }
            throw (Error)e;
        }
    }
}

