/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson;

import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.AccessibleByteArrayOutputStream;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.implementation.ReflectionSerializable;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.serializer.json.jackson.implementation.ObjectMapperShim;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.core.util.Header;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.json.JsonSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

public final class JacksonAdapter
implements SerializerAdapter {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonAdapter.class);
    private final ObjectMapperShim mapper;
    private final ObjectMapperShim headerMapper = ObjectMapperShim.createHeaderMapper();

    private JacksonAdapter() {
        this.mapper = ObjectMapperShim.createJsonMapper(ObjectMapperShim.createSimpleMapper());
    }

    public static SerializerAdapter defaultSerializerAdapter() {
        return GlobalSerializerAdapter.SERIALIZER_ADAPTER.getSerializerAdapter();
    }

    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return ReflectionSerializable.supportsXmlSerializable(object.getClass()) ? ReflectionSerializable.serializeXmlSerializableToString((Object)object) : this.getXmlMapper().writeValueAsString(object);
        }
        if (encoding == SerializerEncoding.TEXT) {
            return object.toString();
        }
        return ReflectionSerializable.supportsJsonSerializable(object.getClass()) ? ReflectionSerializable.serializeJsonSerializableToString((JsonSerializable)((JsonSerializable)object)) : this.mapper.writeValueAsString(object);
    }

    public byte[] serializeToBytes(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            return ReflectionSerializable.supportsXmlSerializable(object.getClass()) ? ReflectionSerializable.serializeXmlSerializableToBytes((Object)object) : this.getXmlMapper().writeValueAsBytes(object);
        }
        if (encoding == SerializerEncoding.TEXT) {
            return object.toString().getBytes(StandardCharsets.UTF_8);
        }
        return ReflectionSerializable.supportsJsonSerializable(object.getClass()) ? ReflectionSerializable.serializeJsonSerializableToBytes((JsonSerializable)((JsonSerializable)object)) : this.mapper.writeValueAsBytes(object);
    }

    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        if (object == null) {
            return;
        }
        if (encoding == SerializerEncoding.XML) {
            if (ReflectionSerializable.supportsXmlSerializable(object.getClass())) {
                ReflectionSerializable.serializeXmlSerializableIntoOutputStream((Object)object, (OutputStream)outputStream);
            } else {
                this.getXmlMapper().writeValue(outputStream, object);
            }
        } else if (encoding == SerializerEncoding.TEXT) {
            outputStream.write(object.toString().getBytes(StandardCharsets.UTF_8));
        } else if (ReflectionSerializable.supportsJsonSerializable(object.getClass())) {
            ReflectionSerializable.serializeJsonSerializableIntoOutputStream((JsonSerializable)((JsonSerializable)object), (OutputStream)outputStream);
        } else {
            this.mapper.writeValue(outputStream, object);
        }
    }

    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return JacksonAdapter.removeLeadingAndTrailingQuotes(this.serialize(object, SerializerEncoding.JSON));
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    static String removeLeadingAndTrailingQuotes(String str) {
        int endOffset;
        int startOffset;
        int strLength = str.length();
        for (startOffset = 0; startOffset < strLength && str.charAt(startOffset) == '\"'; ++startOffset) {
        }
        if (startOffset == strLength) {
            return "";
        }
        for (endOffset = strLength - 1; endOffset >= 0 && str.charAt(endOffset) == '\"'; --endOffset) {
        }
        return str.substring(startOffset, endOffset + 1);
    }

    public String serializeList(List<?> list, CollectionFormat format) {
        return this.serializeIterable(list, format);
    }

    public <T> T deserialize(String value, Type type, SerializerEncoding encoding) throws IOException {
        if (CoreUtils.isNullOrEmpty((CharSequence)value)) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            Class rawClass = TypeUtil.getRawClass((Type)type);
            return (T)(ReflectionSerializable.supportsXmlSerializable((Class)rawClass) ? ReflectionSerializable.deserializeAsXmlSerializable((Class)rawClass, (byte[])value.getBytes(StandardCharsets.UTF_8)) : this.getXmlMapper().readValue(value, type));
        }
        if (encoding == SerializerEncoding.TEXT) {
            return (T)JacksonAdapter.deserializeText(value, type);
        }
        Class rawClass = TypeUtil.getRawClass((Type)type);
        return (T)(ReflectionSerializable.supportsJsonSerializable((Class)rawClass) ? ReflectionSerializable.deserializeAsJsonSerializable((Class)rawClass, (byte[])value.getBytes(StandardCharsets.UTF_8)) : this.mapper.readValue(value, type));
    }

    public <T> T deserialize(byte[] bytes, Type type, SerializerEncoding encoding) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            Class rawClass = TypeUtil.getRawClass((Type)type);
            return (T)(ReflectionSerializable.supportsXmlSerializable((Class)rawClass) ? ReflectionSerializable.deserializeAsXmlSerializable((Class)rawClass, (byte[])bytes) : this.getXmlMapper().readValue(bytes, type));
        }
        if (encoding == SerializerEncoding.TEXT) {
            return (T)JacksonAdapter.deserializeText(CoreUtils.bomAwareToString((byte[])bytes, null), type);
        }
        Class rawClass = TypeUtil.getRawClass((Type)type);
        return (T)(ReflectionSerializable.supportsJsonSerializable((Class)rawClass) ? ReflectionSerializable.deserializeAsJsonSerializable((Class)rawClass, (byte[])bytes) : this.mapper.readValue(bytes, type));
    }

    public <T> T deserialize(InputStream inputStream, Type type, SerializerEncoding encoding) throws IOException {
        if (inputStream == null) {
            return null;
        }
        if (encoding == SerializerEncoding.XML) {
            Class rawClass = TypeUtil.getRawClass((Type)type);
            return (T)(ReflectionSerializable.supportsXmlSerializable((Class)rawClass) ? ReflectionSerializable.deserializeAsXmlSerializable((Class)rawClass, (byte[])JacksonAdapter.inputStreamToBytes(inputStream)) : this.getXmlMapper().readValue(inputStream, type));
        }
        if (encoding == SerializerEncoding.TEXT) {
            int readCount;
            AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((readCount = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, readCount);
            }
            return (T)JacksonAdapter.deserializeText(outputStream.bomAwareToString(null), type);
        }
        Class rawClass = TypeUtil.getRawClass((Type)type);
        return (T)(ReflectionSerializable.supportsJsonSerializable((Class)rawClass) ? ReflectionSerializable.deserializeAsJsonSerializable((Class)rawClass, (byte[])JacksonAdapter.inputStreamToBytes(inputStream)) : this.mapper.readValue(inputStream, type));
    }

    private static byte[] inputStreamToBytes(InputStream inputStream) throws IOException {
        int readCount;
        AccessibleByteArrayOutputStream outputStream = new AccessibleByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((readCount = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, readCount);
        }
        return outputStream.toByteArray();
    }

    private static Object deserializeText(String value, Type type) throws IOException {
        if (type == String.class || type == CharSequence.class) {
            return value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Character.TYPE || type == Character.class) {
            return CoreUtils.isNullOrEmpty((CharSequence)value) ? null : Character.valueOf(value.charAt(0));
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return CoreUtils.isNullOrEmpty((CharSequence)value) ? null : Byte.valueOf((byte)value.charAt(0));
        }
        if (type == byte[].class) {
            return CoreUtils.isNullOrEmpty((CharSequence)value) ? null : value.getBytes(StandardCharsets.UTF_8);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == OffsetDateTime.class) {
            return OffsetDateTime.parse(value);
        }
        if (type == DateTimeRfc1123.class) {
            return new DateTimeRfc1123(value);
        }
        if (type == URL.class) {
            try {
                return ImplUtils.createUrl((String)value);
            }
            catch (MalformedURLException ex) {
                throw new IOException(ex);
            }
        }
        if (type == URI.class) {
            return URI.create(value);
        }
        if (type == UUID.class) {
            return UUID.fromString(value);
        }
        if (type == LocalDate.class) {
            return LocalDate.parse(value);
        }
        if (Enum.class.isAssignableFrom((Class)type)) {
            return Enum.valueOf((Class)type, value);
        }
        if (ExpandableStringEnum.class.isAssignableFrom((Class)type)) {
            try {
                return ((Class)type).getDeclaredMethod("fromString", String.class).invoke(null, value);
            }
            catch (ReflectiveOperationException ex) {
                throw new IOException(ex);
            }
        }
        throw new IllegalStateException("Unsupported text Content-Type Type: " + type);
    }

    public <T> T deserialize(HttpHeaders headers, Type deserializedHeadersType) throws IOException {
        return this.headerMapper.deserialize(headers, deserializedHeadersType);
    }

    public <T> T deserializeHeader(Header header, Type type) throws IOException {
        return this.headerMapper.readValue(header.getValue(), type);
    }

    private ObjectMapperShim getXmlMapper() {
        return GlobalXmlMapper.XML_MAPPER.getXmlMapper();
    }

    private static enum GlobalSerializerAdapter {
        SERIALIZER_ADAPTER(new JacksonAdapter());

        private final SerializerAdapter serializerAdapter;

        private GlobalSerializerAdapter(SerializerAdapter serializerAdapter) {
            this.serializerAdapter = serializerAdapter;
        }

        private SerializerAdapter getSerializerAdapter() {
            return this.serializerAdapter;
        }
    }

    private static enum GlobalXmlMapper {
        XML_MAPPER(ObjectMapperShim.createXmlMapper());

        private final ObjectMapperShim xmlMapper;

        private GlobalXmlMapper(ObjectMapperShim xmlMapper) {
            this.xmlMapper = xmlMapper;
        }

        private ObjectMapperShim getXmlMapper() {
            return this.xmlMapper;
        }
    }
}

