/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.serializer.json.jackson.JacksonJsonProvider;
import com.azure.core.serializer.json.jackson.implementation.AdditionalPropertiesDeserializer;
import com.azure.core.serializer.json.jackson.implementation.AdditionalPropertiesSerializer;
import com.azure.core.serializer.json.jackson.implementation.Base64UrlSerializer;
import com.azure.core.serializer.json.jackson.implementation.BinaryDataDeserializer;
import com.azure.core.serializer.json.jackson.implementation.BinaryDataSerializer;
import com.azure.core.serializer.json.jackson.implementation.ByteArraySerializer;
import com.azure.core.serializer.json.jackson.implementation.DateTimeDeserializer;
import com.azure.core.serializer.json.jackson.implementation.DateTimeRfc1123Serializer;
import com.azure.core.serializer.json.jackson.implementation.DateTimeSerializer;
import com.azure.core.serializer.json.jackson.implementation.DurationSerializer;
import com.azure.core.serializer.json.jackson.implementation.FlatteningDeserializer;
import com.azure.core.serializer.json.jackson.implementation.FlatteningSerializer;
import com.azure.core.serializer.json.jackson.implementation.GeoJsonDeserializer;
import com.azure.core.serializer.json.jackson.implementation.GeoJsonSerializer;
import com.azure.core.serializer.json.jackson.implementation.HttpHeadersSerializer;
import com.azure.core.serializer.json.jackson.implementation.XmlMapperFactory;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

final class ObjectMapperFactory {
    public static final ObjectMapperFactory INSTANCE = new ObjectMapperFactory();

    ObjectMapperFactory() {
    }

    public ObjectMapper createJsonMapper(ObjectMapper innerMapper) {
        ObjectMapper flatteningMapper = ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule((Module)FlatteningSerializer.getModule(innerMapper)).addModule((Module)FlatteningDeserializer.getModule(innerMapper)).build();
        return ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).addModule((Module)AdditionalPropertiesSerializer.getModule(flatteningMapper)).addModule((Module)AdditionalPropertiesDeserializer.getModule(flatteningMapper)).addModule((Module)FlatteningSerializer.getModule(innerMapper)).addModule((Module)FlatteningDeserializer.getModule(innerMapper)).addModule(JacksonJsonProvider.getJsonSerializableDatabindModule()).build();
    }

    public ObjectMapper createXmlMapper() {
        return XmlMapperFactory.INSTANCE.createXmlMapper();
    }

    public ObjectMapper createSimpleMapper() {
        return ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).build();
    }

    public ObjectMapper createHeaderMapper() {
        return ObjectMapperFactory.initializeMapperBuilder(JsonMapper.builder()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).addModule(JacksonJsonProvider.getJsonSerializableDatabindModule()).build();
    }

    static MapperBuilder<?, ?> initializeMapperBuilder(MapperBuilder<?, ?> mapper) {
        mapper.enable(new SerializationFeature[]{SerializationFeature.WRITE_EMPTY_JSON_ARRAYS}).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT}).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS}).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).serializationInclusion(JsonInclude.Include.NON_NULL).addModule((Module)new JavaTimeModule()).addModule((Module)BinaryDataSerializer.getModule()).addModule((Module)BinaryDataDeserializer.getModule()).addModule((Module)ByteArraySerializer.getModule()).addModule((Module)Base64UrlSerializer.getModule()).addModule((Module)DateTimeSerializer.getModule()).addModule((Module)DateTimeDeserializer.getModule()).addModule((Module)DateTimeRfc1123Serializer.getModule()).addModule((Module)DurationSerializer.getModule()).addModule((Module)HttpHeadersSerializer.getModule()).addModule((Module)GeoJsonSerializer.getModule()).addModule((Module)GeoJsonDeserializer.getModule()).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).visibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE);
        return mapper;
    }
}

