/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.serializer.json.jackson.implementation.JacksonDatabind212;
import com.azure.core.serializer.json.jackson.implementation.JacksonVersion;
import com.azure.core.serializer.json.jackson.implementation.ObjectMapperFactory;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;

public final class XmlMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(XmlMapperFactory.class);
    private static final String XML_MAPPER = "com.fasterxml.jackson.dataformat.xml.XmlMapper";
    private static final String XML_MAPPER_BUILDER = "com.fasterxml.jackson.dataformat.xml.XmlMapper$Builder";
    private static final String FROM_XML_PARSER = "com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser$Feature";
    private static final String TO_XML_GENERATOR = "com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator$Feature";
    private final MethodHandle createXmlMapperBuilder;
    private final MethodHandle defaultUseWrapper;
    private final MethodHandle enableWriteXmlDeclaration;
    private final Object writeXmlDeclaration;
    private final MethodHandle enableEmptyElementAsNull;
    private final Object emptyElementAsNull;
    private final boolean useJackson212;
    private boolean jackson212IsSafe = true;
    public static final XmlMapperFactory INSTANCE = new XmlMapperFactory();

    private XmlMapperFactory() {
        Object emptyElementAsNull;
        MethodHandle enableEmptyElementAsNull;
        Object writeXmlDeclaration;
        MethodHandle enableWriteXmlDeclaration;
        MethodHandle defaultUseWrapper;
        MethodHandle createXmlMapperBuilder;
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        try {
            Class<?> xmlMapper = Class.forName(XML_MAPPER);
            Class<?> xmlMapperBuilder = Class.forName(XML_MAPPER_BUILDER);
            Class<?> fromXmlParser = Class.forName(FROM_XML_PARSER);
            Class<?> toXmlGenerator = Class.forName(TO_XML_GENERATOR);
            createXmlMapperBuilder = publicLookup.unreflect(xmlMapper.getDeclaredMethod("builder", new Class[0]));
            defaultUseWrapper = publicLookup.unreflect(xmlMapperBuilder.getDeclaredMethod("defaultUseWrapper", Boolean.TYPE));
            enableWriteXmlDeclaration = publicLookup.unreflect(xmlMapperBuilder.getDeclaredMethod("enable", Array.newInstance(toXmlGenerator, 0).getClass()));
            writeXmlDeclaration = toXmlGenerator.getDeclaredField("WRITE_XML_DECLARATION").get(null);
            enableEmptyElementAsNull = publicLookup.unreflect(xmlMapperBuilder.getDeclaredMethod("enable", Array.newInstance(fromXmlParser, 0).getClass()));
            emptyElementAsNull = fromXmlParser.getDeclaredField("EMPTY_ELEMENT_AS_NULL").get(null);
        }
        catch (Throwable ex) {
            if (ex instanceof Error && !(ex instanceof LinkageError)) {
                throw (Error)ex;
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Failed to retrieve MethodHandles used to create XmlMapper. XML serialization won't be supported until 'com.fasterxml.jackson.dataformat:jackson-dataformat-xml' is added to the classpath or updated to a supported version. " + JacksonVersion.getHelpInfo(), ex));
        }
        this.createXmlMapperBuilder = createXmlMapperBuilder;
        this.defaultUseWrapper = defaultUseWrapper;
        this.enableWriteXmlDeclaration = enableWriteXmlDeclaration;
        this.writeXmlDeclaration = writeXmlDeclaration;
        this.enableEmptyElementAsNull = enableEmptyElementAsNull;
        this.emptyElementAsNull = emptyElementAsNull;
        this.useJackson212 = PackageVersion.VERSION.getMinorVersion() >= 12;
    }

    public ObjectMapper createXmlMapper() {
        ObjectMapper xmlMapper;
        try {
            MapperBuilder<?, ?> xmlMapperBuilder = ObjectMapperFactory.initializeMapperBuilder(this.createXmlMapperBuilder.invoke());
            this.defaultUseWrapper.invokeWithArguments(xmlMapperBuilder, false);
            this.enableWriteXmlDeclaration.invokeWithArguments(xmlMapperBuilder, this.writeXmlDeclaration);
            this.enableEmptyElementAsNull.invokeWithArguments(xmlMapperBuilder, this.emptyElementAsNull);
            xmlMapper = xmlMapperBuilder.build();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Unable to create XmlMapper instance.", e));
        }
        if (this.useJackson212 && this.jackson212IsSafe) {
            try {
                return JacksonDatabind212.mutateXmlCoercions(xmlMapper);
            }
            catch (Throwable ex) {
                if (ex instanceof LinkageError) {
                    this.jackson212IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, ex);
                }
                throw ex;
            }
        }
        return xmlMapper;
    }
}

