/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.serializer.json.jackson.implementation.JacksonJsonReader;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

public class JsonSerializableDeserializer
extends JsonDeserializer<JsonSerializable<?>> {
    private static final ClientLogger LOGGER = new ClientLogger(JsonSerializableDeserializer.class);
    private final Class<? extends JsonSerializable<?>> jsonSerializableType;
    private final MethodHandle readJson;

    public JsonSerializableDeserializer(Class<? extends JsonSerializable<?>> jsonSerializableType) {
        this.jsonSerializableType = jsonSerializableType;
        try {
            MethodHandles.Lookup lookup = ReflectionUtils.getLookupToUse(jsonSerializableType);
            this.readJson = lookup.unreflect(jsonSerializableType.getDeclaredMethod("fromJson", JsonReader.class));
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public JsonSerializable<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        try {
            return this.jsonSerializableType.cast(this.readJson.invokeWithArguments(new Object[]{new JacksonJsonReader(p, null, null, false, null)}));
        }
        catch (Throwable e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof Exception) {
                throw new IOException(e);
            }
            throw (Error)e;
        }
    }
}

