/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson;

import com.azure.core.serializer.json.jackson.implementation.AzureJsonUtils;
import com.azure.core.serializer.json.jackson.implementation.JsonSerializableDeserializer;
import com.azure.core.serializer.json.jackson.implementation.JsonSerializableSerializer;
import com.azure.json.JsonOptions;
import com.azure.json.JsonProvider;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class JacksonJsonProvider
implements JsonProvider {
    public JsonReader createReader(byte[] json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public JsonReader createReader(String json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public JsonReader createReader(InputStream json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public JsonReader createReader(Reader json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createReader(json, options);
    }

    public JsonReader createReader(JsonParser parser) {
        return AzureJsonUtils.createReader(parser);
    }

    public JsonWriter createWriter(OutputStream json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createWriter(json, options);
    }

    public JsonWriter createWriter(Writer json, JsonOptions options) throws IOException {
        return AzureJsonUtils.createWriter(json, options);
    }

    public JsonWriter createWriter(JsonGenerator generator) {
        return AzureJsonUtils.createWriter(generator);
    }

    public static Module getJsonSerializableDatabindModule() {
        return new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return JsonSerializable.class.isAssignableFrom(beanDesc.getBeanClass()) ? new JsonSerializableDeserializer(beanDesc.getBeanClass()) : deserializer;
            }
        }).addSerializer(JsonSerializable.class, (JsonSerializer)new JsonSerializableSerializer());
    }
}

