/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.AccessPattern;

final class JacksonDatabind212 {
    static ObjectMapper mutateXmlCoercions(ObjectMapper mapper) {
        mapper.registerModule((Module)new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (String.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return new DelegatingDeserializer(deserializer){

                        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
                            return this;
                        }

                        public AccessPattern getNullAccessPattern() {
                            return AccessPattern.DYNAMIC;
                        }

                        public Object getNullValue(DeserializationContext ctxt) throws JsonMappingException {
                            return ctxt.getParser().getParsingContext().inArray() ? "" : super.getNullValue(ctxt);
                        }
                    };
                }
                return deserializer;
            }
        }));
        mapper.coercionConfigDefaults().setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
        return mapper;
    }

    static String removePrefix(MapperConfig<?> config, AnnotatedClass annotatedClass, AnnotatedMethod method, String methodName) {
        AccessorNamingStrategy namingStrategy = config.getAccessorNaming().forPOJO(config, annotatedClass);
        String name = namingStrategy.findNameForIsGetter(method, methodName);
        if (name == null) {
            name = namingStrategy.findNameForRegularGetter(method, methodName);
        }
        return name;
    }

    private JacksonDatabind212() {
    }
}

