/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.implementation.RestProxy;
import com.azure.core.implementation.entities.HttpBinFormDataJSON;
import com.azure.core.implementation.entities.HttpBinHeaders;
import com.azure.core.implementation.entities.HttpBinJSON;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.serializer.jackson.JacksonAdapter;
import com.azure.core.implementation.util.FluxUtil;
import com.azure.core.test.MyRestException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class RestProxyTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();

    protected abstract HttpClient createHttpClient();

    @Test
    public void syncRequestWithByteArrayReturnType() {
        byte[] result = this.createService(Service1.class).getByteArray();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)100L, (long)result.length);
    }

    @Test
    public void asyncRequestWithByteArrayReturnType() {
        byte[] result = (byte[])this.createService(Service1.class).getByteArrayAsync().block();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)100L, (long)result.length);
    }

    @Test
    public void getByteArrayAsyncWithNoExpectedResponses() {
        byte[] result = (byte[])this.createService(Service1.class).getByteArrayAsyncWithNoExpectedResponses().block();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)result.length, (long)100L);
    }

    @Test
    public void syncRequestWithByteArrayReturnTypeAndParameterizedHostAndPath() {
        byte[] result = this.createService(Service2.class).getByteArray("httpbin", 50);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)result.length, (long)50L);
    }

    @Test
    public void asyncRequestWithByteArrayReturnTypeAndParameterizedHostAndPath() {
        byte[] result = (byte[])this.createService(Service2.class).getByteArrayAsync("httpbin", 50).block();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)result.length, (long)50L);
    }

    @Test
    public void syncRequestWithEmptyByteArrayReturnTypeAndParameterizedHostAndPath() {
        byte[] result = this.createService(Service2.class).getByteArray("httpbin", 0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void syncGetRequestWithNoReturn() {
        this.createService(Service3.class).getNothing();
    }

    @Test
    public void asyncGetRequestWithNoReturn() {
        this.createService(Service3.class).getNothingAsync().block();
    }

    @Test
    public void syncGetRequestWithAnything() {
        HttpBinJSON json = this.createService(Service5.class).getAnything();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPlus();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything/with+plus", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParam() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam("withpathparam");
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything/withpathparam", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParamWithSpace() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam("with path param");
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything/with path param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParamWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam("with+path+param");
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything/with+path+param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParam() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam("withpathparam");
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything/withpathparam", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParamWithPercent20() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam("with%20path%20param");
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything/with path param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParamWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam("with+path+param");
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything/with+path+param", json.url());
    }

    @Test
    public void asyncGetRequestWithAnything() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service5.class).getAnythingAsync().block();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything", json.url());
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnything() {
        HttpBinJSON json = this.createService(Service6.class).getAnything("A", 15);
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything?a=A&b=15", json.url());
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnythingWithPercent20() {
        HttpBinJSON json = this.createService(Service6.class).getAnything("A%20Z", 15);
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything?a=A%2520Z&b=15", json.url());
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnythingWithEncodedWithPercent20() {
        HttpBinJSON json = this.createService(Service6.class).getAnythingWithEncoded("x%20y", 15);
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything?a=x y&b=15", json.url());
    }

    @Test
    public void asyncGetRequestWithQueryParametersAndAnything() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service6.class).getAnythingAsync("A", 15).block();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything?a=A&b=15", json.url());
    }

    @Test
    public void syncGetRequestWithNullQueryParameter() {
        HttpBinJSON json = this.createService(Service6.class).getAnything(null, 15);
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything?b=15", json.url());
    }

    @Test
    public void syncGetRequestWithHeaderParametersAndAnythingReturn() {
        HttpBinJSON json = this.createService(Service7.class).getAnything("A", 15);
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything", json.url());
        Assert.assertNotNull((Object)json.headers());
        HttpHeaders headers = new HttpHeaders(json.headers());
        Assert.assertEquals((Object)"A", (Object)headers.getValue("A"));
        Assert.assertArrayEquals((Object[])new String[]{"A"}, (Object[])headers.getValues("A"));
        Assert.assertEquals((Object)"15", (Object)headers.getValue("B"));
        Assert.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues("B"));
    }

    @Test
    public void asyncGetRequestWithHeaderParametersAndAnything() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service7.class).getAnythingAsync("A", 15).block();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything", json.url());
        Assert.assertNotNull((Object)json.headers());
        HttpHeaders headers = new HttpHeaders(json.headers());
        Assert.assertEquals((Object)"A", (Object)headers.getValue("A"));
        Assert.assertArrayEquals((Object[])new String[]{"A"}, (Object[])headers.getValues("A"));
        Assert.assertEquals((Object)"15", (Object)headers.getValue("B"));
        Assert.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues("B"));
    }

    @Test
    public void syncGetRequestWithNullHeader() {
        HttpBinJSON json = this.createService(Service7.class).getAnything(null, 15);
        HttpHeaders headers = new HttpHeaders(json.headers());
        Assert.assertEquals(null, (Object)headers.getValue("A"));
        Assert.assertArrayEquals(null, (Object[])headers.getValues("A"));
        Assert.assertEquals((Object)"15", (Object)headers.getValue("B"));
        Assert.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues("B"));
    }

    @Test
    public void syncPostRequestWithStringBody() {
        HttpBinJSON json = this.createService(Service8.class).post("I'm a post body!");
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"I'm a post body!", (Object)json.data());
    }

    @Test
    public void asyncPostRequestWithStringBody() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service8.class).postAsync("I'm a post body!").block();
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"I'm a post body!", (Object)json.data());
    }

    @Test
    public void syncPostRequestWithNullBody() {
        HttpBinJSON result = this.createService(Service8.class).post(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void syncPutRequestWithIntBody() {
        HttpBinJSON json = this.createService(Service9.class).put(42);
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"42", (Object)json.data());
    }

    @Test
    public void asyncPutRequestWithIntBody() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service9.class).putAsync(42).block();
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"42", (Object)json.data());
    }

    @Test
    public void syncPutRequestWithBodyAndEqualContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        HttpBinJSON json = this.createService(Service9.class).putBodyAndContentLength(body, 4L);
        Assert.assertEquals((Object)"test", (Object)json.data());
        Assert.assertEquals((Object)"application/octet-stream", json.headers().get("Content-Type"));
        Assert.assertEquals((Object)"4", json.headers().get("Content-Length"));
        body.clear();
    }

    @Test
    public void syncPutRequestWithBodyLessThanContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        this.thrown.expect(UnexpectedLengthException.class);
        this.thrown.expectMessage("less than");
        this.createService(Service9.class).putBodyAndContentLength(body, 5L);
        body.clear();
    }

    @Test
    public void syncPutRequestWithBodyMoreThanContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        this.thrown.expect(UnexpectedLengthException.class);
        this.thrown.expectMessage("more than");
        this.createService(Service9.class).putBodyAndContentLength(body, 3L);
        body.clear();
    }

    @Test
    public void asyncPutRequestWithBodyAndEqualContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength((Flux<ByteBuffer>)body, 4L)).assertNext(json -> {
            Assert.assertEquals((Object)"test", (Object)json.data());
            Assert.assertEquals((Object)"application/octet-stream", json.headers().get("Content-Type"));
            Assert.assertEquals((Object)"4", json.headers().get("Content-Length"));
        }).verifyComplete();
    }

    @Test
    public void asyncPutRequestWithBodyAndLessThanContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength((Flux<ByteBuffer>)body, 5L)).verifyErrorSatisfies(exception -> {
            Assert.assertTrue((boolean)(exception instanceof UnexpectedLengthException));
            Assert.assertTrue((boolean)exception.getMessage().contains("less than"));
        });
    }

    @Test
    public void asyncPutRequestWithBodyAndMoreThanContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength((Flux<ByteBuffer>)body, 3L)).verifyErrorSatisfies(exception -> {
            Assert.assertTrue((boolean)(exception instanceof UnexpectedLengthException));
            Assert.assertTrue((boolean)exception.getMessage().contains("more than"));
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponse() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponse("I'm the body!");
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (HttpResponseException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
            Assert.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        }
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponse() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAsync("I'm the body!").block();
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (HttpResponseException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
            Assert.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        }
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndExceptionType("I'm the body!");
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (MyRestException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndExceptionTypeAsync("I'm the body!").block();
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (MyRestException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndDeterminedExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndDeterminedExceptionType("I'm the body!");
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (MyRestException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndDeterminedExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndDeterminedExceptionTypeAsync("I'm the body!").block();
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (MyRestException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndFallthroughExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndFallthroughExceptionType("I'm the body!");
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (MyRestException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndFallthroughExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndFallthroughExceptionTypeAsync("I'm the body!").block();
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (MyRestException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndNoFallthroughExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndNoFallthroughExceptionType("I'm the body!");
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (HttpResponseException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
            Assert.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndNoFallthroughExceptionType() {
        try {
            this.createService(Service9.class).putWithUnexpectedResponseAndNoFallthroughExceptionTypeAsync("I'm the body!").block();
            Assert.fail((String)"Expected HttpResponseException would be thrown.");
        }
        catch (HttpResponseException e) {
            Assert.assertNotNull((Object)e.getValue());
            Assert.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
            Assert.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        }
        catch (Throwable e) {
            Assert.fail((String)("Expected MyRestException would be thrown. Instead got " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void syncHeadRequest() {
        Void body = (Void)this.createService(Service10.class).head().getValue();
        Assert.assertNull((Object)body);
    }

    @Test
    public void syncHeadBooleanRequest() {
        boolean result = this.createService(Service10.class).headBoolean();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void syncVoidHeadRequest() {
        this.createService(Service10.class).voidHead();
    }

    @Test
    public void asyncHeadRequest() {
        Void body = (Void)((Response)this.createService(Service10.class).headAsync().block()).getValue();
        Assert.assertNull((Object)body);
    }

    @Test
    public void asyncHeadBooleanRequest() {
        boolean result = (Boolean)this.createService(Service10.class).headBooleanAsync().block();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void asyncCompletableHeadRequest() {
        this.createService(Service10.class).completableHeadAsync().block();
    }

    @Test
    public void syncDeleteRequest() {
        HttpBinJSON json = this.createService(Service11.class).delete(false);
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"false", (Object)json.data());
    }

    @Test
    public void asyncDeleteRequest() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service11.class).deleteAsync(false).block();
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"false", (Object)json.data());
    }

    @Test
    public void syncPatchRequest() {
        HttpBinJSON json = this.createService(Service12.class).patch("body-contents");
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"body-contents", (Object)json.data());
    }

    @Test
    public void asyncPatchRequest() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service12.class).patchAsync("body-contents").block();
        Assert.assertEquals(String.class, json.data().getClass());
        Assert.assertEquals((Object)"body-contents", (Object)json.data());
    }

    @Test
    public void syncHeadersRequest() {
        HttpBinJSON json = this.createService(Service13.class).get();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything", json.url());
        Assert.assertNotNull((Object)json.headers());
        HttpHeaders headers = new HttpHeaders(json.headers());
        Assert.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue("MyHeader"));
        Assert.assertArrayEquals((Object[])new String[]{"MyHeaderValue"}, (Object[])headers.getValues("MyHeader"));
        Assert.assertEquals((Object)"My,Header,Value", (Object)headers.getValue("MyOtherHeader"));
        Assert.assertArrayEquals((Object[])new String[]{"My", "Header", "Value"}, (Object[])headers.getValues("MyOtherHeader"));
    }

    @Test
    public void asyncHeadersRequest() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service13.class).getAsync().block();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything", json.url());
        Assert.assertNotNull((Object)json.headers());
        HttpHeaders headers = new HttpHeaders(json.headers());
        Assert.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue("MyHeader"));
        Assert.assertArrayEquals((Object[])new String[]{"MyHeaderValue"}, (Object[])headers.getValues("MyHeader"));
    }

    @Test
    public void asyncHttpsHeadersRequest() {
        HttpBinJSON json = (HttpBinJSON)this.createService(Service14.class).getAsync().block();
        Assert.assertNotNull((Object)json);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/anything", json.url());
        Assert.assertNotNull((Object)json.headers());
        HttpHeaders headers = new HttpHeaders(json.headers());
        Assert.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue("MyHeader"));
    }

    @Test
    public void service16Put() throws Exception {
        Service16 service16 = this.createService(Service16.class);
        byte[] expectedBytes = new byte[]{1, 2, 3, 4};
        HttpBinJSON httpBinJSON = service16.putByteArray(expectedBytes);
        Assert.assertTrue((boolean)(httpBinJSON.data() instanceof String));
        String base64String = (String)httpBinJSON.data();
        byte[] actualBytes = base64String.getBytes();
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
    }

    @Test
    public void service16PutAsync() throws Exception {
        Service16 service16 = this.createService(Service16.class);
        byte[] expectedBytes = new byte[]{1, 2, 3, 4};
        HttpBinJSON httpBinJSON = (HttpBinJSON)service16.putByteArrayAsync(expectedBytes).block();
        Assert.assertTrue((boolean)(httpBinJSON.data() instanceof String));
        String base64String = (String)httpBinJSON.data();
        byte[] actualBytes = base64String.getBytes();
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
    }

    @Test
    public void syncRequestWithMultipleHostParams() {
        Service17 service17 = this.createService(Service17.class);
        HttpBinJSON result = service17.get("http", "bin");
        Assert.assertNotNull((Object)result);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/get", result.url());
    }

    @Test
    public void asyncRequestWithMultipleHostParams() {
        Service17 service17 = this.createService(Service17.class);
        HttpBinJSON result = (HttpBinJSON)service17.getAsync("http", "bin").block();
        Assert.assertNotNull((Object)result);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/get", result.url());
    }

    @Test
    public void service18GetStatus200() {
        this.createService(Service18.class).getStatus200();
    }

    @Test
    public void service18GetStatus200WithExpectedResponse200() {
        this.createService(Service18.class).getStatus200WithExpectedResponse200();
    }

    @Test
    public void service18GetStatus300() {
        this.createService(Service18.class).getStatus300();
    }

    @Test
    public void service18GetStatus300WithExpectedResponse300() {
        this.createService(Service18.class).getStatus300WithExpectedResponse300();
    }

    @Test(expected=HttpResponseException.class)
    public void service18GetStatus400() {
        this.createService(Service18.class).getStatus400();
    }

    @Test
    public void service18GetStatus400WithExpectedResponse400() {
        this.createService(Service18.class).getStatus400WithExpectedResponse400();
    }

    @Test(expected=HttpResponseException.class)
    public void service18GetStatus500() {
        this.createService(Service18.class).getStatus500();
    }

    @Test
    public void service18GetStatus500WithExpectedResponse500() {
        this.createService(Service18.class).getStatus500WithExpectedResponse500();
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody("");
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody("hello");
        Assert.assertEquals((Object)"hello", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(new byte[0]);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody("");
        Assert.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody("soups and stuff");
        Assert.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(new byte[0]);
        Assert.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object)"\"AAECAwQ=\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody("");
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody("soups and stuff");
        Assert.assertEquals((Object)"soups and stuff", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody("");
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody("penguins");
        Assert.assertEquals((Object)"penguins", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(new byte[0]);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody("");
        Assert.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody("soups and stuff");
        Assert.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody("");
        Assert.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody("soups and stuff");
        Assert.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(new byte[0]);
        Assert.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object)"\"AAECAwQ=\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody("");
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody("penguins");
        Assert.assertEquals((Object)"penguins", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(null);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(new byte[0]);
        Assert.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service20GetBytes100OnlyHeaders() {
        ResponseBase<HttpBinHeaders, Void> response = this.createService(Service20.class).getBytes100OnlyHeaders();
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((Object)true, (Object)headers.accessControlAllowCredentials());
        Assert.assertEquals((Object)"keep-alive", (Object)headers.connection().toLowerCase());
        Assert.assertNotNull((Object)headers.date());
        Assert.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetBytes100BodyAndHeaders() {
        ResponseBase<HttpBinHeaders, byte[]> response = this.createService(Service20.class).getBytes100BodyAndHeaders();
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        byte[] body = (byte[])response.getValue();
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((long)100L, (long)body.length);
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((Object)true, (Object)headers.accessControlAllowCredentials());
        Assert.assertNotNull((Object)headers.date());
        Assert.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetBytesOnlyStatus() {
        ResponseBase<Void, Void> response = this.createService(Service20.class).getBytesOnlyStatus();
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void service20GetBytesOnlyHeaders() {
        ResponseBase<HttpHeaders, Void> response = this.createService(Service20.class).getBytes100OnlyRawHeaders();
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertNotNull((Object)response.getHeaders());
        Assert.assertNotEquals((long)0L, (long)response.getHeaders().getSize());
    }

    @Test
    public void service20PutOnlyHeaders() {
        ResponseBase<HttpBinHeaders, Void> response = this.createService(Service20.class).putOnlyHeaders("body string");
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((Object)true, (Object)headers.accessControlAllowCredentials());
        Assert.assertEquals((Object)"keep-alive", (Object)headers.connection().toLowerCase());
        Assert.assertNotNull((Object)headers.date());
        Assert.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20PutBodyAndHeaders() {
        ResponseBase<HttpBinHeaders, HttpBinJSON> response = this.createService(Service20.class).putBodyAndHeaders("body string");
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        HttpBinJSON body = (HttpBinJSON)response.getValue();
        Assert.assertNotNull((Object)body);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/put", body.url());
        Assert.assertEquals((Object)"body string", (Object)body.data());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((Object)true, (Object)headers.accessControlAllowCredentials());
        Assert.assertEquals((Object)"keep-alive", (Object)headers.connection().toLowerCase());
        Assert.assertNotNull((Object)headers.date());
        Assert.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetVoidResponse() {
        Response<Void> response = this.createService(Service20.class).getVoidResponse();
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
    }

    @Test
    public void service20GetResponseBody() {
        Response<HttpBinJSON> response = this.createService(Service20.class).putBody("body string");
        Assert.assertNotNull(response);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        HttpBinJSON body = (HttpBinJSON)response.getValue();
        Assert.assertNotNull((Object)body);
        RestProxyTests.assertMatchWithHttpOrHttps("httpbin.org/put", body.url());
        Assert.assertEquals((Object)"body string", (Object)body.data());
        HttpHeaders headers = response.getHeaders();
        Assert.assertNotNull((Object)headers);
    }

    @Test
    public void unexpectedHTTPOK() {
        try {
            this.createService(UnexpectedOKService.class).getBytes();
            Assert.fail();
        }
        catch (HttpResponseException e) {
            Assert.assertEquals((Object)"Status code 200, (1024-byte body)", (Object)e.getMessage());
        }
    }

    @Test
    public void service21GetBytes100() {
        byte[] bytes = this.createService(Service21.class).getBytes100();
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)100L, (long)bytes.length);
    }

    @Test
    public void simpleDownloadTest() {
        try (StreamResponse response = this.createService(DownloadService.class).getBytes();){
            int count = 0;
            for (ByteBuffer byteBuf : response.getValue().toIterable()) {
                count += byteBuf.remaining();
            }
            Assert.assertEquals((long)30720L, (long)count);
        }
    }

    @Test
    public void rawFlowableDownloadTest() {
        Flux<ByteBuffer> response = this.createService(DownloadService.class).getBytesFlowable();
        int count = 0;
        for (ByteBuffer byteBuf : response.toIterable()) {
            count += byteBuf.remaining();
        }
        Assert.assertEquals((long)30720L, (long)count);
    }

    @Test
    public void fluxUploadTest() throws Exception {
        Path filePath = Paths.get(this.getClass().getClassLoader().getResource("upload.txt").toURI());
        Flux stream = FluxUtil.readFile((AsynchronousFileChannel)AsynchronousFileChannel.open(filePath, new OpenOption[0]));
        HttpClient httpClient = this.createHttpClient();
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(httpClient).policies(new HttpPipelinePolicy[]{new HttpLoggingPolicy(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS))}).build();
        Response<HttpBinJSON> response = ((FlowableUploadService)RestProxy.create(FlowableUploadService.class, (HttpPipeline)httpPipeline, (SerializerAdapter)SERIALIZER)).put((Flux<ByteBuffer>)stream, Files.size(filePath));
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)((HttpBinJSON)response.getValue()).data());
    }

    @Test
    public void segmentUploadTest() throws Exception {
        Path filePath = Paths.get(this.getClass().getClassLoader().getResource("upload.txt").toURI());
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(filePath, StandardOpenOption.READ);
        Response<HttpBinJSON> response = this.createService(FlowableUploadService.class).put((Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel, (long)4L, (long)15L), 15L);
        Assert.assertEquals((Object)"quick brown fox", (Object)((HttpBinJSON)response.getValue()).data());
    }

    @Test
    public void service22GetBytes() {
        byte[] bytes = this.createService(Service22.class).getBytes("http://httpbin.org/bytes/27");
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)27L, (long)bytes.length);
    }

    @Test
    public void service23GetBytes() {
        byte[] bytes = this.createService(Service23.class).getBytes();
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)28L, (long)bytes.length);
    }

    @Test
    public void service24Put() {
        HashMap<String, String> headerCollection = new HashMap<String, String>();
        headerCollection.put("DEF", "GHIJ");
        headerCollection.put("123", "45");
        HttpBinJSON result = this.createService(Service24.class).put(headerCollection);
        Assert.assertNotNull((Object)result.headers());
        HttpHeaders resultHeaders = new HttpHeaders(result.headers());
        Assert.assertEquals((Object)"GHIJ", (Object)resultHeaders.getValue("ABCDEF"));
        Assert.assertEquals((Object)"45", (Object)resultHeaders.getValue("ABC123"));
    }

    @Test(expected=HttpResponseException.class)
    @Ignore(value="Decoding is not a policy anymore")
    public void testMissingDecodingPolicyCausesException() {
        Service25 service = (Service25)RestProxy.create(Service25.class, (HttpPipeline)new HttpPipelineBuilder().build());
        service.get();
    }

    @Test(expected=HttpResponseException.class)
    @Ignore(value="Decoding is not a policy anymore")
    public void testSingleMissingDecodingPolicyCausesException() {
        Service25 service = (Service25)RestProxy.create(Service25.class, (HttpPipeline)new HttpPipelineBuilder().build());
        service.getAsync().block();
        service.getBodyResponseAsync().block();
    }

    @Test(expected=HttpResponseException.class)
    @Ignore(value="Decoding is not a policy anymore")
    public void testSingleBodyResponseMissingDecodingPolicyCausesException() {
        Service25 service = (Service25)RestProxy.create(Service25.class, (HttpPipeline)new HttpPipelineBuilder().build());
        service.getBodyResponseAsync().block();
    }

    @Test
    public void postUrlFormEncoded() {
        Service26 service = this.createService(Service26.class);
        HttpBinFormDataJSON response = service.postForm("Foo", "123", "foo@bar.com", HttpBinFormDataJSON.PizzaSize.LARGE, Arrays.asList("Bacon", "Onion"));
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.form());
        Assert.assertEquals((Object)"Foo", (Object)response.form().customerName());
        Assert.assertEquals((Object)"123", (Object)response.form().customerTelephone());
        Assert.assertEquals((Object)"foo@bar.com", (Object)response.form().customerEmail());
        Assert.assertEquals((Object)HttpBinFormDataJSON.PizzaSize.LARGE, (Object)response.form().pizzaSize());
        Assert.assertEquals((long)2L, (long)response.form().toppings().size());
        Assert.assertEquals((Object)"Bacon", response.form().toppings().get(0));
        Assert.assertEquals((Object)"Onion", response.form().toppings().get(1));
    }

    protected <T> T createService(Class<T> serviceClass) {
        HttpClient httpClient = this.createHttpClient();
        return this.createService(serviceClass, httpClient);
    }

    protected <T> T createService(Class<T> serviceClass, HttpClient httpClient) {
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(httpClient).build();
        return (T)RestProxy.create(serviceClass, (HttpPipeline)httpPipeline, (SerializerAdapter)SERIALIZER);
    }

    private static void assertContains(String value, String expectedSubstring) {
        Assert.assertTrue((String)("Expected \"" + value + "\" to contain \"" + expectedSubstring + "\"."), (boolean)value.contains(expectedSubstring));
    }

    private static void assertMatchWithHttpOrHttps(String url1, String url2) {
        String s1 = "http://" + url1;
        if (s1.equalsIgnoreCase(url2)) {
            return;
        }
        String s2 = "https://" + url1;
        if (s2.equalsIgnoreCase(url2)) {
            return;
        }
        Assert.assertTrue((String)("'" + url2 + "' does not match with '" + s1 + "' or '" + s2 + "'."), (boolean)false);
    }

    @Host(value="http://httpbin.org/")
    @ServiceInterface(name="Service26")
    static interface Service26 {
        @Post(value="post")
        public HttpBinFormDataJSON postForm(@FormParam(value="custname") String var1, @FormParam(value="custtel") String var2, @FormParam(value="custemail") String var3, @FormParam(value="size") HttpBinFormDataJSON.PizzaSize var4, @FormParam(value="toppings") List<String> var5);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service25")
    static interface Service25 {
        @Get(value="anything")
        public HttpBinJSON get();

        @Get(value="anything")
        public Mono<HttpBinJSON> getAsync();

        @Get(value="anything")
        public Mono<Response<HttpBinJSON>> getBodyResponseAsync();
    }

    @Host(value="http://httpbin.org/")
    @ServiceInterface(name="Service24")
    static interface Service24 {
        @Put(value="put")
        public HttpBinJSON put(@HeaderParam(value="ABC") Map<String, String> var1);
    }

    @Host(value="http://httpbin.org/")
    @ServiceInterface(name="Service23")
    static interface Service23 {
        @Get(value="bytes/28")
        public byte[] getBytes();
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service22")
    static interface Service22 {
        @Get(value="/")
        public byte[] getBytes(@HostParam(value="url") String var1);
    }

    @Host(value="https://httpbin.org")
    @ServiceInterface(name="FlowableUploadService")
    static interface FlowableUploadService {
        @Put(value="/put")
        public Response<HttpBinJSON> put(@BodyParam(value="text/plain") Flux<ByteBuffer> var1, @HeaderParam(value="Content-Length") long var2);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="DownloadService")
    static interface DownloadService {
        @Get(value="/bytes/30720")
        public StreamResponse getBytes();

        @Get(value="/bytes/30720")
        public Flux<ByteBuffer> getBytesFlowable();
    }

    @Host(value="https://www.example.com")
    @ServiceInterface(name="Service21")
    private static interface Service21 {
        @Get(value="http://httpbin.org/bytes/100")
        @ExpectedResponses(value={200})
        public byte[] getBytes100();
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="UnexpectedOKService")
    static interface UnexpectedOKService {
        @Get(value="/bytes/1024")
        @ExpectedResponses(value={400})
        public StreamResponse getBytes();
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service20")
    private static interface Service20 {
        @Get(value="bytes/100")
        public ResponseBase<HttpBinHeaders, Void> getBytes100OnlyHeaders();

        @Get(value="bytes/100")
        public ResponseBase<HttpHeaders, Void> getBytes100OnlyRawHeaders();

        @Get(value="bytes/100")
        public ResponseBase<HttpBinHeaders, byte[]> getBytes100BodyAndHeaders();

        @Put(value="put")
        public ResponseBase<HttpBinHeaders, Void> putOnlyHeaders(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        public ResponseBase<HttpBinHeaders, HttpBinJSON> putBodyAndHeaders(@BodyParam(value="application/octet-stream") String var1);

        @Get(value="bytes/100")
        public ResponseBase<Void, Void> getBytesOnlyStatus();

        @Get(value="bytes/100")
        public Response<Void> getVoidResponse();

        @Put(value="put")
        public Response<HttpBinJSON> putBody(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service19")
    private static interface Service19 {
        @Put(value="put")
        public HttpBinJSON putWithNoContentTypeAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        public HttpBinJSON putWithNoContentTypeAndByteArrayBody(@BodyParam(value="application/octet-stream") byte[] var1);

        @Put(value="put")
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndStringBody(@BodyParam(value="application/json") String var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/json"})
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndByteArrayBody(@BodyParam(value="application/json") byte[] var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/octet-stream"})
        public HttpBinJSON putWithHeaderApplicationOctetStreamContentTypeAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @Headers(value={"Content-Type: application/octet-stream"})
        public HttpBinJSON putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(@BodyParam(value="application/octet-stream") byte[] var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndStringBody(@BodyParam(value="application/json") String var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(@BodyParam(value="application/json; charset=utf-8") String var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(@BodyParam(value="application/json") byte[] var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(@BodyParam(value="application/octet-stream") byte[] var1);
    }

    @Host(value="https://httpbin.org")
    @ServiceInterface(name="Service18")
    private static interface Service18 {
        @Get(value="status/200")
        public void getStatus200();

        @Get(value="status/200")
        @ExpectedResponses(value={200})
        public void getStatus200WithExpectedResponse200();

        @Get(value="status/300")
        public void getStatus300();

        @Get(value="status/300")
        @ExpectedResponses(value={300})
        public void getStatus300WithExpectedResponse300();

        @Get(value="status/400")
        public void getStatus400();

        @Get(value="status/400")
        @ExpectedResponses(value={400})
        public void getStatus400WithExpectedResponse400();

        @Get(value="status/500")
        public void getStatus500();

        @Get(value="status/500")
        @ExpectedResponses(value={500})
        public void getStatus500WithExpectedResponse500();
    }

    @Host(value="http://{hostPart1}{hostPart2}.org")
    @ServiceInterface(name="Service17")
    private static interface Service17 {
        @Get(value="get")
        @ExpectedResponses(value={200})
        public HttpBinJSON get(@HostParam(value="hostPart1") String var1, @HostParam(value="hostPart2") String var2);

        @Get(value="get")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAsync(@HostParam(value="hostPart1") String var1, @HostParam(value="hostPart2") String var2);
    }

    @Host(value="https://httpbin.org")
    @ServiceInterface(name="Service16")
    private static interface Service16 {
        @Put(value="put")
        @ExpectedResponses(value={200})
        public HttpBinJSON putByteArray(@BodyParam(value="application/octet-stream") byte[] var1);

        @Put(value="put")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> putByteArrayAsync(@BodyParam(value="application/octet-stream") byte[] var1);
    }

    @Host(value="https://httpbin.org")
    @ServiceInterface(name="Service14")
    private static interface Service14 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue"})
        public HttpBinJSON get();

        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue"})
        public Mono<HttpBinJSON> getAsync();
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service13")
    private static interface Service13 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue", "MyOtherHeader:My,Header,Value"})
        public HttpBinJSON get();

        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue", "MyOtherHeader:My,Header,Value"})
        public Mono<HttpBinJSON> getAsync();
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service12")
    private static interface Service12 {
        @Patch(value="patch")
        @ExpectedResponses(value={200})
        public HttpBinJSON patch(@BodyParam(value="application/octet-stream") String var1);

        @Patch(value="patch")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> patchAsync(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service11")
    private static interface Service11 {
        @Delete(value="delete")
        @ExpectedResponses(value={200})
        public HttpBinJSON delete(@BodyParam(value="application/octet-stream") boolean var1);

        @Delete(value="delete")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> deleteAsync(@BodyParam(value="application/octet-stream") boolean var1);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service10")
    private static interface Service10 {
        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Response<Void> head();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public boolean headBoolean();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public void voidHead();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Response<Void>> headAsync();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Boolean> headBooleanAsync();

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Void> completableHeadAsync();
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service9")
    private static interface Service9 {
        @Put(value="put")
        @ExpectedResponses(value={200})
        public HttpBinJSON put(@BodyParam(value="application/octet-stream") int var1);

        @Put(value="put")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> putAsync(@BodyParam(value="application/octet-stream") int var1);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public HttpBinJSON putBodyAndContentLength(@BodyParam(value="application/octet-stream") ByteBuffer var1, @HeaderParam(value="Content-Length") long var2);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public Mono<HttpBinJSON> putAsyncBodyAndContentLength(@BodyParam(value="application/octet-stream") Flux<ByteBuffer> var1, @HeaderParam(value="Content-Length") long var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        public HttpBinJSON putWithUnexpectedResponse(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public HttpBinJSON putWithUnexpectedResponseAndExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={200}, value=MyRestException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public HttpBinJSON putWithUnexpectedResponseAndDeterminedExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={200}, value=MyRestException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndDeterminedExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyRestException.class)})
        public HttpBinJSON putWithUnexpectedResponseAndFallthroughExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyRestException.class)})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndFallthroughExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(code={400}, value=MyRestException.class)
        public HttpBinJSON putWithUnexpectedResponseAndNoFallthroughExceptionType(@BodyParam(value="application/octet-stream") String var1);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(code={400}, value=MyRestException.class)
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndNoFallthroughExceptionTypeAsync(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service8")
    private static interface Service8 {
        @Post(value="post")
        @ExpectedResponses(value={200})
        public HttpBinJSON post(@BodyParam(value="application/octet-stream") String var1);

        @Post(value="post")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> postAsync(@BodyParam(value="application/octet-stream") String var1);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service7")
    private static interface Service7 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything(@HeaderParam(value="a") String var1, @HeaderParam(value="b") int var2);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync(@HeaderParam(value="a") String var1, @HeaderParam(value="b") int var2);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service6")
    private static interface Service6 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything(@QueryParam(value="a") String var1, @QueryParam(value="b") int var2);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithEncoded(@QueryParam(value="a", encoded=true) String var1, @QueryParam(value="b") int var2);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync(@QueryParam(value="a") String var1, @QueryParam(value="b") int var2);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service5")
    private static interface Service5 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything();

        @Get(value="anything/with+plus")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithPlus();

        @Get(value="anything/{path}")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithPathParam(@PathParam(value="path") String var1);

        @Get(value="anything/{path}")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithEncodedPathParam(@PathParam(value="path", encoded=true) String var1);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync();
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service3")
    private static interface Service3 {
        @Get(value="bytes/2")
        @ExpectedResponses(value={200})
        public void getNothing();

        @Get(value="bytes/2")
        @ExpectedResponses(value={200})
        public Mono<Void> getNothingAsync();
    }

    @Host(value="http://{hostName}.org")
    @ServiceInterface(name="Service2")
    private static interface Service2 {
        @Get(value="bytes/{numberOfBytes}")
        @ExpectedResponses(value={200})
        public byte[] getByteArray(@HostParam(value="hostName") String var1, @PathParam(value="numberOfBytes") int var2);

        @Get(value="bytes/{numberOfBytes}")
        @ExpectedResponses(value={200})
        public Mono<byte[]> getByteArrayAsync(@HostParam(value="hostName") String var1, @PathParam(value="numberOfBytes") int var2);
    }

    @Host(value="http://httpbin.org")
    @ServiceInterface(name="Service1")
    private static interface Service1 {
        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public byte[] getByteArray();

        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public Mono<byte[]> getByteArrayAsync();

        @Get(value="bytes/100")
        public Mono<byte[]> getByteArrayAsyncWithNoExpectedResponses();
    }
}

