/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.http.HttpClient;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.TestMode;
import com.azure.core.test.http.PlaybackClient;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.policy.RecordNetworkCallPolicy;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InterceptorManager
implements AutoCloseable {
    private static final String RECORD_FOLDER = "session-records/";
    private final ClientLogger logger = new ClientLogger(InterceptorManager.class);
    private final Map<String, String> textReplacementRules;
    private final String testName;
    private final TestMode testMode;
    private final RecordedData recordedData;

    public InterceptorManager(String testName, TestMode testMode) throws IOException {
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        this.testName = testName;
        this.testMode = testMode;
        this.textReplacementRules = new HashMap<String, String>();
        this.recordedData = testMode == TestMode.PLAYBACK ? this.readDataFromFile() : new RecordedData();
    }

    public InterceptorManager(String testName, Map<String, String> textReplacementRules) throws IOException {
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        Objects.requireNonNull(textReplacementRules, "'textReplacementRules' cannot be null.");
        this.testName = testName;
        this.testMode = TestMode.PLAYBACK;
        this.recordedData = this.readDataFromFile();
        this.textReplacementRules = textReplacementRules;
    }

    public boolean isPlaybackMode() {
        return this.testMode == TestMode.PLAYBACK;
    }

    public RecordedData getRecordedData() {
        return this.recordedData;
    }

    public HttpPipelinePolicy getRecordPolicy() {
        return new RecordNetworkCallPolicy(this.recordedData);
    }

    public HttpClient getPlaybackClient() {
        return new PlaybackClient(this.recordedData, this.textReplacementRules);
    }

    @Override
    public void close() {
        switch (this.testMode) {
            case RECORD: {
                try {
                    this.writeDataToFile();
                }
                catch (IOException e) {
                    this.logger.error("Unable to write data to playback file.", new Object[]{e});
                }
                break;
            }
            case PLAYBACK: {
                break;
            }
            default: {
                this.logger.error("==> Unknown AZURE_TEST_MODE: {}", new Object[]{this.testMode});
            }
        }
    }

    private RecordedData readDataFromFile() throws IOException {
        File recordFile = this.getRecordFile(this.testName);
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        return (RecordedData)mapper.readValue(recordFile, RecordedData.class);
    }

    private void writeDataToFile() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File recordFile = this.getRecordFile(this.testName);
        if (recordFile.createNewFile()) {
            this.logger.verbose("Created record file: {}", new Object[]{recordFile.getPath()});
        }
        mapper.writeValue(recordFile, (Object)this.recordedData);
    }

    private File getRecordFile(String testName) {
        URL folderUrl = InterceptorManager.class.getClassLoader().getResource(".");
        File folderFile = new File(folderUrl.getPath() + RECORD_FOLDER);
        if (!folderFile.exists() && folderFile.mkdir()) {
            this.logger.verbose("Created directory: {}", new Object[]{folderFile.getPath()});
        }
        String filePath = folderFile.getPath() + "/" + testName + ".json";
        this.logger.info("==> Playback file path: " + filePath, new Object[0]);
        return new File(filePath);
    }

    public void addTextReplacementRule(String regex, String replacement) {
        this.textReplacementRules.put(regex, replacement);
    }
}

