/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.test.http.MockHttpResponse;
import com.azure.core.test.models.NetworkCallRecord;
import com.azure.core.test.models.RecordedData;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public final class PlaybackClient
implements HttpClient {
    private static final String X_MS_CLIENT_REQUEST_ID = "x-ms-client-request-id";
    private static final String X_MS_ENCRYPTION_KEY_SHA256 = "x-ms-encryption-key-sha256";
    private final ClientLogger logger = new ClientLogger(PlaybackClient.class);
    private final AtomicInteger count = new AtomicInteger(0);
    private final Map<String, String> textReplacementRules;
    private final RecordedData recordedData;

    public PlaybackClient(RecordedData recordedData, Map<String, String> textReplacementRules) {
        Objects.requireNonNull(recordedData, "'recordedData' cannot be null.");
        this.recordedData = recordedData;
        this.textReplacementRules = textReplacementRules == null ? new HashMap() : textReplacementRules;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return Mono.defer(() -> this.playbackHttpResponse(request));
    }

    private Mono<HttpResponse> playbackHttpResponse(HttpRequest request) {
        String incomingUrl = this.applyReplacementRule(request.getUrl().toString());
        String incomingMethod = request.getHttpMethod().toString();
        String matchingUrl = PlaybackClient.removeHost(incomingUrl);
        NetworkCallRecord networkCallRecord = this.recordedData.findFirstAndRemoveNetworkCall(record -> record.getMethod().equalsIgnoreCase(incomingMethod) && PlaybackClient.removeHost(record.getUri()).equalsIgnoreCase(matchingUrl));
        this.count.incrementAndGet();
        if (networkCallRecord == null) {
            this.logger.warning("NOT FOUND - Method: {} URL: {}", new Object[]{incomingMethod, incomingUrl});
            this.logger.warning("Records requested: {}.", new Object[]{this.count});
            return Mono.error((Throwable)new IllegalStateException("==> Unexpected request: " + incomingMethod + " " + incomingUrl));
        }
        if (networkCallRecord.getException() != null) {
            throw this.logger.logExceptionAsWarning(Exceptions.propagate((Throwable)networkCallRecord.getException().get()));
        }
        if (networkCallRecord.getHeaders().containsKey(X_MS_CLIENT_REQUEST_ID)) {
            request.setHeader(X_MS_CLIENT_REQUEST_ID, networkCallRecord.getHeaders().get(X_MS_CLIENT_REQUEST_ID));
        }
        if (request.getHeaders().getValue(X_MS_ENCRYPTION_KEY_SHA256) != null) {
            networkCallRecord.getResponse().put(X_MS_ENCRYPTION_KEY_SHA256, request.getHeaders().getValue(X_MS_ENCRYPTION_KEY_SHA256));
        }
        int recordStatusCode = Integer.parseInt(networkCallRecord.getResponse().get("StatusCode"));
        HttpHeaders headers = new HttpHeaders();
        for (Map.Entry<String, String> pair : networkCallRecord.getResponse().entrySet()) {
            if (pair.getKey().equals("StatusCode") || pair.getKey().equals("Body")) continue;
            Object rawHeader = pair.getValue();
            for (Map.Entry<String, String> rule : this.textReplacementRules.entrySet()) {
                if (rule.getValue() == null) continue;
                rawHeader = ((String)rawHeader).replaceAll(rule.getKey(), rule.getValue());
            }
            headers.put(pair.getKey(), (String)rawHeader);
        }
        String rawBody = networkCallRecord.getResponse().get("Body");
        byte[] bytes = null;
        if (rawBody != null) {
            for (Map.Entry<String, String> rule : this.textReplacementRules.entrySet()) {
                if (rule.getValue() == null) continue;
                rawBody = rawBody.replaceAll(rule.getKey(), rule.getValue());
            }
            String contentType = networkCallRecord.getResponse().get("Content-Type");
            if (contentType != null && contentType.equalsIgnoreCase("application/octet-stream")) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                for (String piece : rawBody.substring(1, rawBody.length() - 1).split(", ")) {
                    outputStream.write(Byte.parseByte(piece));
                }
                bytes = outputStream.toByteArray();
            } else {
                bytes = rawBody.getBytes(StandardCharsets.UTF_8);
            }
            if (bytes.length > 0) {
                headers.put("Content-Length", String.valueOf(bytes.length));
            }
        }
        MockHttpResponse response = new MockHttpResponse(request, recordStatusCode, headers, bytes);
        return Mono.just((Object)((Object)response));
    }

    private String applyReplacementRule(String text) {
        for (Map.Entry<String, String> rule : this.textReplacementRules.entrySet()) {
            if (rule.getValue() == null) continue;
            text = text.replaceAll(rule.getKey(), rule.getValue());
        }
        return text;
    }

    private static String removeHost(String url) {
        UrlBuilder urlBuilder = UrlBuilder.parse((String)url);
        if (urlBuilder.getQuery().containsKey("sig")) {
            urlBuilder.setQueryParameter("sig", "REDACTED");
        }
        return String.format("%s%s", urlBuilder.getPath(), urlBuilder.queryString());
    }
}

