/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.utils.TestResourceNamer;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class TestBase
implements BeforeEachCallback {
    private static final String AZURE_TEST_MODE = "AZURE_TEST_MODE";
    private static TestMode testMode;
    private final ClientLogger logger = new ClientLogger(TestBase.class);
    protected InterceptorManager interceptorManager;
    protected TestResourceNamer testResourceNamer;
    private ExtensionContext extensionContext;

    @BeforeAll
    public static void setupClass() {
        testMode = TestBase.initializeTestMode();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    @BeforeEach
    public void setupTest(TestInfo testInfo) {
        String testName = ((Method)testInfo.getTestMethod().get()).getName();
        this.logger.info("Test Mode: {}, Name: {}", new Object[]{testMode, testName});
        try {
            this.interceptorManager = new InterceptorManager(testName, testMode);
        }
        catch (IOException e) {
            this.logger.error("Could not create interceptor for {}", new Object[]{testName, e});
            Assertions.fail();
        }
        this.testResourceNamer = new TestResourceNamer(testName, testMode, this.interceptorManager.getRecordedData());
        this.beforeTest();
    }

    @AfterEach
    public void teardownTest(TestInfo testInfo) {
        this.afterTest();
        this.interceptorManager.close();
    }

    public TestMode getTestMode() {
        return testMode;
    }

    @Deprecated
    protected String getTestName() {
        if (this.extensionContext != null) {
            return this.extensionContext.getTestMethod().map(Method::getName).orElse(null);
        }
        return null;
    }

    protected void beforeTest() {
    }

    protected void afterTest() {
    }

    private static TestMode initializeTestMode() {
        ClientLogger logger = new ClientLogger(TestBase.class);
        String azureTestMode = Configuration.getGlobalConfiguration().get(AZURE_TEST_MODE);
        if (azureTestMode != null) {
            try {
                return TestMode.valueOf(azureTestMode.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                logger.error("Could not parse '{}' into TestEnum. Using 'Playback' mode.", new Object[]{azureTestMode});
                return TestMode.PLAYBACK;
            }
        }
        logger.info("Environment variable '{}' has not been set yet. Using 'Playback' mode.", new Object[]{AZURE_TEST_MODE});
        return TestMode.PLAYBACK;
    }
}

