/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.util.logging.ClientLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ThreadDumper
implements BeforeAllCallback {
    private static final ClientLogger LOGGER = new ClientLogger(ThreadDumper.class);
    private static volatile ExecutorService executorService;
    private static final int INITIAL_DELAY_IN_MINUTES = 30;
    private static final int RATE_IN_MINUTES = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize() {
        if (executorService != null) return;
        Class<ThreadDumper> clazz = ThreadDumper.class;
        synchronized (ThreadDumper.class) {
            if (executorService != null) return;
            executorService = ThreadDumper.createExecutorService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static ExecutorService createExecutorService() {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        Runtime.getRuntime().addShutdownHook(new Thread(service::shutdown));
        service.scheduleAtFixedRate(ThreadDumper::printThreadStacks, 30L, 2L, TimeUnit.MINUTES);
        return service;
    }

    private static void printThreadStacks() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder("============= THREAD DUMP START =========");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        dump.append("============= THREAD DUMP END =========");
        String output = dump.toString();
        System.err.println(output);
        LOGGER.info(output);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ThreadDumper.initialize();
    }
}

