/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.http.HttpClient;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.http.PlaybackClient;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.policy.RecordNetworkCallPolicy;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class InterceptorManager
implements AutoCloseable {
    private static final String RECORD_FOLDER = "session-records/";
    private static final ObjectMapper RECORD_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final ClientLogger logger = new ClientLogger(InterceptorManager.class);
    private final Map<String, String> textReplacementRules;
    private final String testName;
    private final String playbackRecordName;
    private final TestMode testMode;
    private final boolean allowedToReadRecordedValues;
    private final boolean allowedToRecordValues;
    private final RecordedData recordedData;

    @Deprecated
    public InterceptorManager(String testName, TestMode testMode) {
        this(testName, testName, testMode, false);
    }

    public InterceptorManager(TestContextManager testContextManager) {
        this(testContextManager.getTestName(), testContextManager.getTestPlaybackRecordingName(), testContextManager.getTestMode(), testContextManager.doNotRecordTest());
    }

    private InterceptorManager(String testName, String playbackRecordName, TestMode testMode, boolean doNotRecord) {
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        this.testName = testName;
        this.playbackRecordName = CoreUtils.isNullOrEmpty((CharSequence)playbackRecordName) ? testName : playbackRecordName;
        this.testMode = testMode;
        this.textReplacementRules = new HashMap<String, String>();
        this.allowedToReadRecordedValues = testMode == TestMode.PLAYBACK && !doNotRecord;
        boolean bl = this.allowedToRecordValues = testMode == TestMode.RECORD && !doNotRecord;
        this.recordedData = this.allowedToReadRecordedValues ? this.readDataFromFile() : (this.allowedToRecordValues ? new RecordedData() : null);
    }

    @Deprecated
    public InterceptorManager(String testName, Map<String, String> textReplacementRules) {
        this(testName, textReplacementRules, false, testName);
    }

    @Deprecated
    public InterceptorManager(String testName, Map<String, String> textReplacementRules, boolean doNotRecord) {
        this(testName, textReplacementRules, doNotRecord, testName);
    }

    public InterceptorManager(String testName, Map<String, String> textReplacementRules, boolean doNotRecord, String playbackRecordName) {
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        Objects.requireNonNull(textReplacementRules, "'textReplacementRules' cannot be null.");
        this.testName = testName;
        this.playbackRecordName = CoreUtils.isNullOrEmpty((CharSequence)playbackRecordName) ? testName : playbackRecordName;
        this.testMode = TestMode.PLAYBACK;
        this.allowedToReadRecordedValues = !doNotRecord;
        this.allowedToRecordValues = false;
        this.recordedData = this.allowedToReadRecordedValues ? this.readDataFromFile() : null;
        this.textReplacementRules = textReplacementRules;
    }

    public boolean isPlaybackMode() {
        return this.testMode == TestMode.PLAYBACK;
    }

    public boolean isLiveMode() {
        return this.testMode == TestMode.LIVE;
    }

    public RecordedData getRecordedData() {
        return this.recordedData;
    }

    public HttpPipelinePolicy getRecordPolicy() {
        return this.getRecordPolicy(Collections.emptyList());
    }

    public HttpPipelinePolicy getRecordPolicy(List<Function<String, String>> recordingRedactors) {
        return new RecordNetworkCallPolicy(this.recordedData, recordingRedactors);
    }

    public HttpClient getPlaybackClient() {
        return new PlaybackClient(this.recordedData, this.textReplacementRules);
    }

    @Override
    public void close() {
        if (this.allowedToRecordValues) {
            try (BufferedWriter writer = Files.newBufferedWriter(this.createRecordFile(this.playbackRecordName).toPath(), new OpenOption[0]);){
                RECORD_MAPPER.writeValue((Writer)writer, (Object)this.recordedData);
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException("Unable to write data to playback file.", ex));
            }
        }
    }

    private RecordedData readDataFromFile() {
        RecordedData recordedData;
        block8: {
            File recordFile = this.getRecordFile();
            BufferedReader reader = Files.newBufferedReader(recordFile.toPath());
            try {
                recordedData = (RecordedData)RECORD_MAPPER.readValue((Reader)reader, RecordedData.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw this.logger.logExceptionAsWarning((RuntimeException)new UncheckedIOException(ex));
                }
            }
            reader.close();
        }
        return recordedData;
    }

    private File getRecordFolder() {
        URL folderUrl = InterceptorManager.class.getClassLoader().getResource(RECORD_FOLDER);
        if (folderUrl != null) {
            return new File(InterceptorManager.toURI(folderUrl, this.logger));
        }
        folderUrl = InterceptorManager.class.getClassLoader().getResource("");
        Path recordFolder = new File(InterceptorManager.toURI(folderUrl, this.logger)).toPath().resolve(RECORD_FOLDER);
        try {
            Files.createDirectory(recordFolder, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
        return recordFolder.toFile();
    }

    private static URI toURI(URL url, ClientLogger logger) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalStateException(ex));
        }
    }

    private File getRecordFile() {
        File recordFolder = this.getRecordFolder();
        File playbackFile = new File(recordFolder, this.playbackRecordName + ".json");
        File oldPlaybackFile = new File(recordFolder, this.testName + ".json");
        if (!playbackFile.exists() && !oldPlaybackFile.exists()) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Missing both new and old playback files. Files are %s and %s.", playbackFile.getPath(), oldPlaybackFile.getPath())));
        }
        if (playbackFile.exists()) {
            this.logger.info("==> Playback file path: {}", new Object[]{playbackFile.getPath()});
            return playbackFile;
        }
        this.logger.info("==> Playback file path: {}", new Object[]{oldPlaybackFile.getPath()});
        return oldPlaybackFile;
    }

    private File createRecordFile(String testName) throws IOException {
        File recordFile;
        File recordFolder = this.getRecordFolder();
        if (!recordFolder.exists() && recordFolder.mkdir()) {
            this.logger.verbose("Created directory: {}", new Object[]{recordFolder.getPath()});
        }
        if ((recordFile = new File(recordFolder, testName + ".json")).createNewFile()) {
            this.logger.verbose("Created record file: {}", new Object[]{recordFile.getPath()});
        }
        this.logger.info("==> Playback file path: " + recordFile);
        return recordFile;
    }

    public void addTextReplacementRule(String regex, String replacement) {
        this.textReplacementRules.put(regex, replacement);
    }
}

