/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

public final class AssertingClient
implements HttpClient {
    private final HttpClient delegate;
    private final List<Predicate<HttpRequest>> syncAssertions;
    private final List<Predicate<HttpRequest>> asyncAssertions;
    private final BiFunction<HttpRequest, Context, Boolean> skipRequestBiFunction;

    AssertingClient(HttpClient delegate, List<Predicate<HttpRequest>> syncAssertions, List<Predicate<HttpRequest>> asyncAssertions, BiFunction<HttpRequest, Context, Boolean> function) {
        this.delegate = delegate;
        this.syncAssertions = syncAssertions;
        this.asyncAssertions = asyncAssertions;
        this.skipRequestBiFunction = function;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        for (Predicate<HttpRequest> asyncAssertion : this.asyncAssertions) {
            if (asyncAssertion.test(request)) continue;
            return Mono.error((Throwable)new IllegalStateException("unexpected request"));
        }
        return this.delegate.send(request);
    }

    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        this.skipRequest(request, this.asyncAssertions, context);
        for (Predicate<HttpRequest> asyncAssertion : this.asyncAssertions) {
            if (asyncAssertion.test(request)) continue;
            return Mono.error((Throwable)new IllegalStateException("unexpected request"));
        }
        return this.delegate.send(request, context);
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        this.skipRequest(request, this.syncAssertions, context);
        for (Predicate<HttpRequest> syncAssertion : this.syncAssertions) {
            if (syncAssertion.test(request)) continue;
            throw new IllegalStateException("unexpected request");
        }
        return this.delegate.sendSync(request, context);
    }

    private void skipRequest(HttpRequest request, List<Predicate<HttpRequest>> assertions, Context context) {
        if (this.skipRequestBiFunction.apply(request, context).booleanValue() && !assertions.isEmpty()) {
            assertions.remove(assertions.size() - 1);
        }
    }
}

