/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.http.MockHttpResponse;
import com.azure.core.test.http.NoOpHttpClient;
import com.azure.core.test.implementation.entities.HttpBinFormDataJSON;
import com.azure.core.test.implementation.entities.HttpBinJSON;
import com.azure.core.test.utils.MessageDigestUtils;
import com.azure.core.util.Base64Url;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockHttpClient
extends NoOpHttpClient {
    private static final HttpHeaders RESPONSE_HEADERS = new HttpHeaders().set("Date", "Fri, 13 Oct 2017 20:33:09 GMT").set("Via", "1.1 vegur").set("Connection", "keep-alive").set("X-Processed-Time", "1.0").set("Access-Control-Allow-Credentials", "true").set("Content-Type", "application/json");
    private static final Random RANDOM = new Random();

    @Override
    public Mono<HttpResponse> send(HttpRequest request) {
        MockHttpResponse response = null;
        try {
            URL requestUrl = request.getUrl();
            String requestHost = requestUrl.getHost();
            String contentType = request.getHeaders().getValue("Content-Type");
            if ("localhost".equalsIgnoreCase(requestHost)) {
                String requestPath = requestUrl.getPath();
                String requestPathLower = requestPath.toLowerCase();
                if (requestPathLower.startsWith("/anything")) {
                    if ("HEAD".equals(request.getHttpMethod().name())) {
                        response = new MockHttpResponse(request, 200, new byte[0]);
                    } else {
                        HttpBinJSON json = new HttpBinJSON();
                        json.url(MockHttpClient.cleanseUrl(requestUrl));
                        json.headers(MockHttpClient.toMap(request.getHeaders()));
                        response = new MockHttpResponse(request, 200, json);
                    }
                } else if (requestPathLower.startsWith("/bytes/")) {
                    byte[] content;
                    String byteCountString = requestPath.substring("/bytes/".length());
                    int byteCount = Integer.parseInt(byteCountString);
                    HttpHeaders newHeaders = new HttpHeaders((Iterable)RESPONSE_HEADERS).set("Content-Type", "application/octet-stream").set("Content-Length", Integer.toString(byteCount));
                    if (byteCount > 0) {
                        content = new byte[byteCount];
                        RANDOM.nextBytes(content);
                        newHeaders = newHeaders.set("ETag", MessageDigestUtils.md5(content));
                    } else {
                        content = null;
                    }
                    response = new MockHttpResponse(request, 200, newHeaders, content);
                } else if (requestPathLower.startsWith("/base64urlbytes/")) {
                    String byteCountString = requestPath.substring("/base64urlbytes/".length());
                    int byteCount = Integer.parseInt(byteCountString);
                    byte[] bytes2 = new byte[byteCount];
                    for (int i = 0; i < byteCount; ++i) {
                        bytes2[i] = (byte)i;
                    }
                    Base64Url base64EncodedBytes = bytes2.length == 0 ? null : Base64Url.encode((byte[])bytes2);
                    response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, base64EncodedBytes);
                } else if ("/base64urllistofbytes".equals(requestPathLower)) {
                    ArrayList<String> base64EncodedBytesList = new ArrayList<String>();
                    for (int i = 0; i < 3; ++i) {
                        int byteCount = (i + 1) * 10;
                        byte[] bytes3 = new byte[byteCount];
                        for (int j = 0; j < byteCount; ++j) {
                            bytes3[j] = (byte)j;
                        }
                        Base64Url base64UrlEncodedBytes = Base64Url.encode((byte[])bytes3);
                        base64EncodedBytesList.add(base64UrlEncodedBytes.toString());
                    }
                    response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, base64EncodedBytesList);
                } else if ("/base64urllistoflistofbytes".equals(requestPathLower)) {
                    ArrayList result = new ArrayList();
                    for (int i = 0; i < 2; ++i) {
                        ArrayList<String> innerList = new ArrayList<String>();
                        for (int j = 0; j < (i + 1) * 2; ++j) {
                            int byteCount = (j + 1) * 5;
                            byte[] bytes4 = new byte[byteCount];
                            for (int k = 0; k < byteCount; ++k) {
                                bytes4[k] = (byte)k;
                            }
                            Base64Url base64UrlEncodedBytes = Base64Url.encode((byte[])bytes4);
                            innerList.add(base64UrlEncodedBytes.toString());
                        }
                        result.add(innerList);
                    }
                    response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, result);
                } else if ("/base64urlmapofbytes".equals(requestPathLower)) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    for (int i = 0; i < 2; ++i) {
                        String key = Integer.toString(i);
                        int byteCount = (i + 1) * 10;
                        byte[] bytes5 = new byte[byteCount];
                        for (int j = 0; j < byteCount; ++j) {
                            bytes5[j] = (byte)j;
                        }
                        Base64Url base64UrlEncodedBytes = Base64Url.encode((byte[])bytes5);
                        result.put(key, base64UrlEncodedBytes.toString());
                    }
                    response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, result);
                } else if ("/datetimerfc1123".equals(requestPathLower)) {
                    DateTimeRfc1123 now = new DateTimeRfc1123(OffsetDateTime.ofInstant(Instant.ofEpochSecond(0L), ZoneOffset.UTC));
                    String result = now.toString();
                    response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, result);
                } else if ("/unixtime".equals(requestPathLower)) {
                    response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, 0);
                } else if ("/delete".equals(requestPathLower)) {
                    HttpBinJSON json = new HttpBinJSON();
                    json.url(MockHttpClient.cleanseUrl(requestUrl));
                    json.data(MockHttpClient.createHttpBinResponseDataForRequest(request));
                    response = new MockHttpResponse(request, 200, json);
                } else if ("/get".equals(requestPathLower)) {
                    HttpBinJSON json = new HttpBinJSON();
                    json.url(MockHttpClient.cleanseUrl(requestUrl));
                    json.headers(MockHttpClient.toMap(request.getHeaders()));
                    response = new MockHttpResponse(request, 200, json);
                } else if ("/patch".equals(requestPathLower)) {
                    HttpBinJSON json = new HttpBinJSON();
                    json.url(MockHttpClient.cleanseUrl(requestUrl));
                    json.data(MockHttpClient.createHttpBinResponseDataForRequest(request));
                    response = new MockHttpResponse(request, 200, json);
                } else if ("/post".equals(requestPathLower)) {
                    if (contentType != null && contentType.contains("x-www-form-urlencoded")) {
                        Map<String, String> parsed = MockHttpClient.bodyToMap(request);
                        HttpBinFormDataJSON json = new HttpBinFormDataJSON();
                        HttpBinFormDataJSON.Form form = new HttpBinFormDataJSON.Form();
                        form.customerName(parsed.get("custname"));
                        form.customerEmail(parsed.get("custemail"));
                        form.customerTelephone(parsed.get("custtel"));
                        form.pizzaSize(HttpBinFormDataJSON.PizzaSize.valueOf(parsed.get("size")));
                        form.toppings(Arrays.asList(parsed.get("toppings").split(",")));
                        json.form(form);
                        response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, json);
                    } else {
                        HttpBinJSON json = new HttpBinJSON();
                        json.url(MockHttpClient.cleanseUrl(requestUrl));
                        json.data(MockHttpClient.createHttpBinResponseDataForRequest(request));
                        json.headers(MockHttpClient.toMap(request.getHeaders()));
                        response = new MockHttpResponse(request, 200, json);
                    }
                } else if ("/put".equals(requestPathLower)) {
                    HttpBinJSON json = new HttpBinJSON();
                    json.url(MockHttpClient.cleanseUrl(requestUrl));
                    json.data(MockHttpClient.createHttpBinResponseDataForRequest(request));
                    json.headers(MockHttpClient.toMap(request.getHeaders()));
                    response = new MockHttpResponse(request, 200, RESPONSE_HEADERS, json);
                } else if (requestPathLower.startsWith("/status/")) {
                    String statusCodeString = requestPathLower.substring("/status/".length());
                    int statusCode = Integer.parseInt(statusCodeString);
                    response = new MockHttpResponse(request, statusCode);
                }
            } else if ("echo.org".equalsIgnoreCase(requestHost)) {
                return FluxUtil.collectBytesInByteBufferStream((Flux)request.getBody()).map(bytes -> new MockHttpResponse(request, 200, new HttpHeaders((Iterable)request.getHeaders()), (byte[])bytes));
            }
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
        if (response == null) {
            response = new MockHttpResponse(request, 500);
        }
        return Mono.just(response);
    }

    private static String createHttpBinResponseDataForRequest(HttpRequest request) {
        String body = MockHttpClient.bodyToString(request);
        return body == null ? "" : body;
    }

    private static String bodyToString(HttpRequest request) {
        String body = "";
        if (request.getBody() != null) {
            Mono asyncString = FluxUtil.collectBytesInByteBufferStream((Flux)request.getBody()).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8));
            body = (String)asyncString.block();
        }
        return body;
    }

    private static Map<String, List<String>> toMap(HttpHeaders headers) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (HttpHeader header : headers) {
            result.put(header.getName(), header.getValuesList());
        }
        return result;
    }

    private static Map<String, String> bodyToMap(HttpRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        String body = MockHttpClient.bodyToString(request);
        for (String keyValPair : body.split("&")) {
            String[] parts = keyValPair.split("=");
            assert (parts.length == 2);
            if (result.containsKey(parts[0])) {
                result.put(parts[0], (String)result.get(parts[0]) + "," + parts[1]);
                continue;
            }
            result.put(parts[0], parts[1]);
        }
        return result;
    }

    private static String cleanseUrl(URL url) {
        StringBuilder builder = new StringBuilder();
        builder.append(url.getProtocol()).append("://").append(url.getHost()).append(url.getPath().replace("%20", " "));
        if (url.getQuery() != null) {
            builder.append("?").append(url.getQuery().replace("%20", " "));
        }
        return builder.toString();
    }
}

