/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public final class TestUtils {
    public static void assertArraysEqual(byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            TestUtils.assertArraysEqual(expected, actual);
        }
    }

    public static void assertArraysEqual(byte[] expected, int expectedOffset, byte[] actual, int actualOffset, int length) {
        TestUtils.assertByteBuffersEqual(ByteBuffer.wrap(expected, expectedOffset, length), ByteBuffer.wrap(actual, actualOffset, length));
    }

    public static void assertByteBuffersEqual(ByteBuffer expected, ByteBuffer actual) {
        if (!Objects.equals(expected, actual)) {
            expected.reset();
            actual.reset();
            byte[] expectedArray = new byte[expected.remaining()];
            expected.get(expectedArray);
            byte[] actualArray = new byte[actual.remaining()];
            actual.get(actualArray);
            TestUtils.assertArraysEqual(expectedArray, actualArray);
        }
    }

    private TestUtils() {
    }
}

