/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.models.TestProxyRequestMatcher;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import reactor.core.publisher.Mono;

public class TestProxyPlaybackClient
implements HttpClient {
    private final HttpURLConnectionHttpClient client = new HttpURLConnectionHttpClient();
    private String xRecordingId;
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private static final List<TestProxySanitizer> DEFAULT_SANITIZERS = TestProxyUtils.loadSanitizers();
    private final List<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>();
    private final List<TestProxyRequestMatcher> matchers = new ArrayList<TestProxyRequestMatcher>();

    public TestProxyPlaybackClient() {
        this.sanitizers.addAll(DEFAULT_SANITIZERS);
    }

    public Queue<String> startPlayback(String recordFile) {
        LinkedList<String> linkedList;
        block9: {
            HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/playback/start", TestProxyUtils.getProxyUrl())).setBody(String.format("{\"x-recording-file\": \"%s\"}", recordFile));
            HttpResponse response = this.client.sendSync(request, Context.NONE);
            try {
                TestProxyUtils.checkForTestProxyErrors(response);
                this.xRecordingId = response.getHeaderValue("x-recording-id");
                this.addProxySanitization(this.sanitizers);
                this.addMatcherRequests(this.matchers);
                String body = (String)response.getBodyAsString().block();
                ArrayList toSort = new ArrayList(((Map)SERIALIZER.deserialize(body, Map.class, SerializerEncoding.JSON)).entrySet());
                toSort.sort(Comparator.comparingInt(e -> Integer.parseInt((String)e.getKey())));
                LinkedList<String> strings = new LinkedList<String>();
                for (Map.Entry entry : toSort) {
                    String value = (String)entry.getValue();
                    strings.add(value);
                }
                linkedList = strings;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            response.close();
        }
        return linkedList;
    }

    public void stopPlayback() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/playback/stop", TestProxyUtils.getProxyUrl())).setHeader("x-recording-id", this.xRecordingId);
        this.client.sendSync(request, Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        if (this.xRecordingId == null) {
            throw new RuntimeException("Playback was not started before a request was sent.");
        }
        TestProxyUtils.changeHeaders(request, this.xRecordingId, "playback");
        return this.client.send(request).map(response -> {
            TestProxyUtils.checkForTestProxyErrors(response);
            return response;
        });
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        if (this.xRecordingId == null) {
            throw new RuntimeException("Playback was not started before a request was sent.");
        }
        TestProxyUtils.changeHeaders(request, this.xRecordingId, "playback");
        HttpResponse response = this.client.sendSync(request, context);
        TestProxyUtils.checkForTestProxyErrors(response);
        return response;
    }

    public void addProxySanitization(List<TestProxySanitizer> sanitizers) {
        if (this.isPlayingBack()) {
            TestProxyUtils.getSanitizerRequests(sanitizers).forEach(request -> {
                request.setHeader("x-recording-id", this.xRecordingId);
                this.client.sendSync((HttpRequest)request, Context.NONE);
            });
        } else {
            this.sanitizers.addAll(sanitizers);
        }
    }

    public void addMatcherRequests(List<TestProxyRequestMatcher> matchers) {
        if (this.isPlayingBack()) {
            TestProxyUtils.getMatcherRequests(matchers).forEach(request -> {
                request.setHeader("x-recording-id", this.xRecordingId);
                this.client.sendSync((HttpRequest)request, Context.NONE);
            });
        } else {
            this.matchers.addAll(matchers);
        }
    }

    private boolean isPlayingBack() {
        return this.xRecordingId != null;
    }
}

