/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.policy;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class TestProxyRecordPolicy
implements HttpPipelinePolicy {
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private final HttpURLConnectionHttpClient client = new HttpURLConnectionHttpClient();
    private String xRecordingId;
    private final List<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>();
    private static final List<TestProxySanitizer> DEFAULT_SANITIZERS = TestProxyUtils.loadSanitizers();

    public TestProxyRecordPolicy() {
        this.sanitizers.addAll(DEFAULT_SANITIZERS);
    }

    public void startRecording(String recordFile) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/record/start", TestProxyUtils.getProxyUrl())).setBody(String.format("{\"x-recording-file\": \"%s\"}", recordFile));
        HttpResponse response = this.client.sendSync(request, Context.NONE);
        this.xRecordingId = response.getHeaderValue("x-recording-id");
        this.addProxySanitization(this.sanitizers);
    }

    public void stopRecording(Queue<String> variables) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/record/stop", TestProxyUtils.getProxyUrl())).setHeader("content-type", "application/json").setHeader("x-recording-id", this.xRecordingId).setBody(this.serializeVariables(variables));
        this.client.sendSync(request, Context.NONE);
    }

    private String serializeVariables(Queue<String> variables) {
        if (variables.isEmpty()) {
            return "{}";
        }
        AtomicInteger count = new AtomicInteger(0);
        Map<String, String> map = variables.stream().collect(Collectors.toMap(k -> String.format("%d", count.getAndIncrement()), k -> k));
        try {
            return SERIALIZER.serialize(map, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        TestProxyUtils.changeHeaders(context.getHttpRequest(), this.xRecordingId, "record");
        HttpResponse response = next.processSync();
        TestProxyUtils.checkForTestProxyErrors(response);
        return response;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest request = context.getHttpRequest();
        TestProxyUtils.changeHeaders(request, this.xRecordingId, "record");
        return next.process().map(response -> {
            TestProxyUtils.checkForTestProxyErrors(response);
            return response;
        });
    }

    public void addProxySanitization(List<TestProxySanitizer> sanitizers) {
        if (this.isRecording()) {
            TestProxyUtils.getSanitizerRequests(sanitizers).forEach(request -> {
                request.setHeader("x-recording-id", this.xRecordingId);
                this.client.sendSync((HttpRequest)request, Context.NONE);
            });
        } else {
            this.sanitizers.addAll(sanitizers);
        }
    }

    private boolean isRecording() {
        return this.xRecordingId != null;
    }
}

