/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpURLConnectionHttpClient
implements HttpClient {
    public HttpResponse sendSync(HttpRequest request, Context context) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)request.getUrl().openConnection();
            connection.setRequestMethod(request.getHttpMethod().name());
            HttpURLConnectionHttpClient.setHeadersOnRequest(request, connection);
            HttpURLConnectionHttpClient.setBodyOnRequest(request, connection);
            connection.connect();
            HttpResponse httpResponse = this.createHttpResponse(connection, request);
            return httpResponse;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)request.getUrl().openConnection();
            connection.setRequestMethod(request.getHttpMethod().toString());
            HttpURLConnectionHttpClient.setHeadersOnRequest(request, connection);
            HttpURLConnectionHttpClient.setBodyOnRequest(request, connection);
            connection.connect();
            Mono mono = Mono.just((Object)this.createHttpResponse(connection, request));
            return mono;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpResponse createHttpResponse(HttpURLConnection connection, HttpRequest request) {
        if (connection == null) {
            return null;
        }
        return new HttpURLResponse(connection, request);
    }

    private static void setBodyOnRequest(HttpRequest request, HttpURLConnection connection) {
        block7: {
            try {
                BinaryData body = request.getBodyAsBinaryData();
                if (body == null) break block7;
                connection.setDoOutput(true);
                try (BufferedOutputStream stream = new BufferedOutputStream(connection.getOutputStream());){
                    stream.write(body.toBytes());
                    stream.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static void setHeadersOnRequest(HttpRequest request, HttpURLConnection connection) {
        HttpHeaders headers = request.getHeaders();
        if (headers != null) {
            for (HttpHeader header : headers) {
                String name = header.getName();
                connection.setRequestProperty(name, headers.getValue(name));
            }
        }
    }

    private static class HttpURLResponse
    extends HttpResponse {
        private final HttpURLConnection connection;
        private final ByteBuffer body;

        protected HttpURLResponse(HttpRequest request) {
            super(request);
            this.connection = null;
            this.body = null;
        }

        HttpURLResponse(HttpURLConnection connection, HttpRequest request) {
            super(request);
            this.connection = connection;
            try {
                byte[] bytes = null;
                if (connection.getResponseCode() >= 100 && connection.getResponseCode() < 400) {
                    bytes = BinaryData.fromStream((InputStream)connection.getInputStream()).toBytes();
                } else {
                    InputStream inputStream = connection.getErrorStream();
                    if (inputStream != null) {
                        bytes = BinaryData.fromStream((InputStream)inputStream).toBytes();
                    }
                }
                this.body = bytes != null ? ByteBuffer.wrap(bytes) : null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public int getStatusCode() {
            try {
                return this.connection.getResponseCode();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getHeaderValue(String name) {
            return this.connection.getHeaderField(name);
        }

        public HttpHeaders getHeaders() {
            HttpHeaders ret = new HttpHeaders();
            for (Map.Entry<String, List<String>> entry : this.connection.getHeaderFields().entrySet()) {
                for (String value : entry.getValue()) {
                    ret.add(entry.getKey(), value);
                }
            }
            return ret;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)this.body);
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.body.array());
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.body.array(), StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.body.array(), charset));
        }
    }
}

