/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyDownloader;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TestProxyManager {
    private static final ClientLogger LOGGER = new ClientLogger(TestProxyManager.class);
    private static final Path PROXYPATH = Paths.get(System.getProperty("java.io.tmpdir"), "test-proxy");
    private final File recordingPath;
    private Process proxy;

    public TestProxyManager(File recordingPath) {
        this.recordingPath = recordingPath;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopProxy));
        TestProxyDownloader.installTestProxy();
    }

    public void startProxy() {
        try {
            ProcessBuilder builder = new ProcessBuilder(Paths.get(TestProxyDownloader.getProxyDirectory().toString(), TestProxyUtils.getProxyProcessName()).toString(), "--storage-location", this.recordingPath.getPath()).directory(TestProxyDownloader.getProxyDirectory().toFile());
            this.proxy = builder.start();
            HttpURLConnectionHttpClient client = new HttpURLConnectionHttpClient();
            HttpRequest request = new HttpRequest(HttpMethod.GET, String.format("%s/admin/isalive", TestProxyUtils.getProxyUrl()));
            for (int i = 0; i < 10; ++i) {
                HttpResponse response = null;
                try {
                    response = client.sendSync(request, Context.NONE);
                    if (response != null && response.getStatusCode() == 200) {
                        return;
                    }
                    TestProxyUtils.checkForTestProxyErrors(response);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.sleep(1000L);
            }
            throw new RuntimeException("Test proxy did not initialize.");
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopProxy() {
        if (this.proxy.isAlive()) {
            this.proxy.destroy();
        }
    }
}

