/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;

public final class TestUtils {
    private static final ClientLogger LOGGER = new ClientLogger(TestUtils.class);
    private static final String RECORD_FOLDER = "session-records/";

    public static void assertArraysEqual(byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    public static void assertArraysEqual(byte[] expected, int expectedOffset, byte[] actual, int actualOffset, int length) {
        TestUtils.assertByteBuffersEqual(ByteBuffer.wrap(expected, expectedOffset, length), ByteBuffer.wrap(actual, actualOffset, length));
    }

    public static void assertByteBuffersEqual(ByteBuffer expected, ByteBuffer actual) {
        if (!Objects.equals(expected, actual)) {
            expected.reset();
            actual.reset();
            byte[] expectedArray = new byte[expected.remaining()];
            expected.get(expectedArray);
            byte[] actualArray = new byte[actual.remaining()];
            actual.get(actualArray);
            Assertions.assertArrayEquals((byte[])expectedArray, (byte[])actualArray);
        }
    }

    public static File getRecordFolder() {
        URL folderUrl = TestUtils.class.getClassLoader().getResource(RECORD_FOLDER);
        if (folderUrl != null) {
            return new File(TestUtils.toURI(folderUrl, LOGGER));
        }
        throw new IllegalStateException("Unable to locate session-records folder. Please create a session-records folder in '/src/test/resources' of the module (ex. for azure-core-test this is '/sdk/core/azure-core-test/src/test/resources/session-records').");
    }

    private static URI toURI(URL url, ClientLogger logger) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalStateException(ex));
        }
    }

    private TestUtils() {
    }
}

