/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.models.RecordFilePayload;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Queue;
import reactor.core.publisher.Mono;

public class TestProxyRecordPolicy
implements HttpPipelinePolicy {
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private static final HttpHeaderName X_RECORDING_ID = HttpHeaderName.fromString((String)"x-recording-id");
    private final HttpClient client;
    private final URL proxyUrl;
    private final boolean skipRecordingRequestBody;
    private String xRecordingId;
    private final List<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>();
    private static final List<TestProxySanitizer> DEFAULT_SANITIZERS = TestProxyUtils.loadSanitizers();
    public static final String RECORD_MODE = "record";

    public TestProxyRecordPolicy(HttpClient httpClient, boolean skipRecordingRequestBody) {
        this.client = httpClient == null ? new HttpURLConnectionHttpClient() : httpClient;
        this.skipRecordingRequestBody = skipRecordingRequestBody;
        this.proxyUrl = TestProxyUtils.getProxyUrl();
        this.sanitizers.addAll(DEFAULT_SANITIZERS);
    }

    public void startRecording(File recordFile) {
        HttpRequest request = null;
        try {
            request = new HttpRequest(HttpMethod.POST, String.format("%s/record/start", this.proxyUrl.toString())).setBody(SERIALIZER.serialize((Object)new RecordFilePayload(recordFile.toString()), SerializerEncoding.JSON));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpResponse response = this.client.sendSync(request, Context.NONE);
        this.xRecordingId = response.getHeaderValue(X_RECORDING_ID);
        this.addProxySanitization(this.sanitizers);
        this.setDefaultRecordingOptions();
    }

    private void setDefaultRecordingOptions() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/Admin/SetRecordingOptions", this.proxyUrl.toString()));
        request.setBody("{\"HandleRedirects\": false}");
        request.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
        this.client.sendSync(request, Context.NONE);
    }

    public void stopRecording(Queue<String> variables) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/record/stop", this.proxyUrl.toString())).setHeader(HttpHeaderName.CONTENT_TYPE, "application/json").setHeader(X_RECORDING_ID, this.xRecordingId).setBody(this.serializeVariables(variables));
        this.client.sendSync(request, Context.NONE);
    }

    private String serializeVariables(Queue<String> variables) {
        if (variables.isEmpty()) {
            return "{}";
        }
        int count = 0;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String variable : variables) {
            map.put(String.valueOf(count++), variable);
        }
        try {
            return SERIALIZER.serialize(map, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void beforeSendingRequest(HttpPipelineCallContext context) {
        TestProxyUtils.changeHeaders(context.getHttpRequest(), this.proxyUrl, this.xRecordingId, RECORD_MODE, this.skipRecordingRequestBody);
    }

    private HttpResponse afterReceivedResponse(HttpResponse response) {
        TestProxyUtils.checkForTestProxyErrors(response);
        return TestProxyUtils.resetTestProxyData(response);
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        this.beforeSendingRequest(context);
        HttpResponse response = next.processSync();
        return this.afterReceivedResponse(response);
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return Mono.fromCallable(() -> {
            this.beforeSendingRequest(context);
            return next;
        }).flatMap(ignored -> next.process()).map(this::afterReceivedResponse);
    }

    public void addProxySanitization(List<TestProxySanitizer> sanitizers) {
        if (this.isRecording()) {
            TestProxyUtils.getSanitizerRequests(sanitizers, this.proxyUrl).forEach(request -> {
                request.setHeader(X_RECORDING_ID, this.xRecordingId);
                this.client.sendSync(request, Context.NONE);
            });
        } else {
            this.sanitizers.addAll(sanitizers);
        }
    }

    private boolean isRecording() {
        return this.xRecordingId != null;
    }
}

