/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class TestProxyDownloader {
    private static final ClientLogger LOGGER = new ClientLogger(TestProxyDownloader.class);
    private static final Path PROXY_PATH = Paths.get(System.getProperty("java.io.tmpdir"), "test-proxy");
    private static String testProxyTag;

    private TestProxyDownloader() {
    }

    public static Path getProxyDirectory() {
        return PROXY_PATH;
    }

    public static void installTestProxy(Path testClassPath) {
        testProxyTag = TestProxyUtils.getTestProxyVersion(testClassPath);
        if (!TestProxyDownloader.checkDownloadedVersion()) {
            PlatformInfo platformInfo = new PlatformInfo();
            TestProxyDownloader.downloadProxy(platformInfo);
            TestProxyDownloader.extractTestProxy(platformInfo);
        }
    }

    private static void extractTestProxy(PlatformInfo platformInfo) {
        block43: {
            Path zipFile = TestProxyDownloader.getZipFileLocation(platformInfo.getExtension());
            if (Files.exists(PROXY_PATH, new LinkOption[0])) {
                try {
                    Files.walk(PROXY_PATH, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Could not delete old test proxy zip file %s", zipFile.toString()), e);
                }
            }
            try {
                if (platformInfo.extension.equals("tar.gz")) {
                    try (InputStream file = Files.newInputStream(zipFile, new OpenOption[0]);
                         BufferedInputStream buffer = new BufferedInputStream(file);
                         GZIPInputStream gzipInputStream = new GZIPInputStream(buffer);
                         TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)gzipInputStream);){
                        TestProxyDownloader.decompress((ArchiveInputStream)archive);
                        break block43;
                    }
                }
                try (InputStream file = Files.newInputStream(zipFile, new OpenOption[0]);
                     BufferedInputStream buffer = new BufferedInputStream(file);
                     ZipArchiveInputStream archive = new ZipArchiveInputStream((InputStream)buffer);){
                    TestProxyDownloader.decompress((ArchiveInputStream)archive);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void decompress(ArchiveInputStream archive) {
        try {
            ArchiveEntry entry = archive.getNextEntry();
            while (entry != null) {
                File outputFile = TestProxyDownloader.getOutputFile(entry);
                if (entry.isDirectory()) {
                    if (!outputFile.isDirectory() && !outputFile.mkdirs()) {
                        throw new RuntimeException("Could not create all required directories");
                    }
                } else {
                    File parent = outputFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new RuntimeException("Could not create all required directories");
                    }
                    try (OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
                        IOUtils.copy((InputStream)archive, (OutputStream)outputStream);
                        if (outputFile.getName().equals(TestProxyUtils.getProxyProcessName())) {
                            outputFile.setExecutable(true, false);
                        }
                    }
                }
                entry = archive.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getOutputFile(ArchiveEntry entry) {
        return new File(PROXY_PATH.toFile(), entry.getName());
    }

    private static void downloadProxy(PlatformInfo platformInfo) {
        LOGGER.log(LogLevel.INFORMATIONAL, () -> "Downloading test proxy. This may take a few moments.");
        try {
            URL url = UrlBuilder.parse((String)TestProxyDownloader.getProxyDownloadUrl(platformInfo)).toUrl();
            Files.copy(url.openStream(), TestProxyDownloader.getZipFileLocation(platformInfo.getExtension()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save test proxy download", e);
        }
        TestProxyDownloader.updateDownloadedFileVersion();
    }

    private static Path getZipFileLocation(String extension) {
        return Paths.get(System.getProperty("java.io.tmpdir"), String.format("testproxy.%s", extension));
    }

    private static void updateDownloadedFileVersion() {
        Path filePath = TestProxyDownloader.getFileVersionPath();
        try {
            Files.write(filePath, Arrays.asList(testProxyTag), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write version data to file", e);
        }
    }

    private static boolean checkDownloadedVersion() {
        String fileVersion;
        Path filePath = TestProxyDownloader.getFileVersionPath();
        if (!Files.exists(filePath, new LinkOption[0])) {
            return false;
        }
        try {
            fileVersion = Files.readAllLines(filePath).get(0);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read version data from file", e);
        }
        return fileVersion.equals(testProxyTag);
    }

    private static Path getFileVersionPath() {
        return Paths.get(System.getProperty("java.io.tmpdir"), "test-proxy-version.txt");
    }

    private static String getProxyDownloadUrl(PlatformInfo platformInfo) {
        return String.format("https://github.com/Azure/azure-sdk-tools/releases/download/Azure.Sdk.Tools.TestProxy_%s/test-proxy-standalone-%s-%s.%s", testProxyTag, platformInfo.getPlatform(), platformInfo.getArchitecture(), platformInfo.getExtension());
    }

    private static class PlatformInfo {
        private final String platform;
        private final String extension;
        private final String architecture;

        PlatformInfo() {
            String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            if (osName.contains("windows")) {
                this.platform = "win";
                this.extension = "zip";
            } else if (osName.contains("linux")) {
                this.platform = "linux";
                this.extension = "tar.gz";
            } else if (osName.contains("mac os x")) {
                this.platform = "osx";
                this.extension = "zip";
            } else {
                throw new RuntimeException("unexpected osName " + osName);
            }
            String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
            if (arch.contains("amd64") || arch.contains("x86_64")) {
                this.architecture = "x64";
            } else if (arch.contains("arm64")) {
                this.architecture = "arm64";
            } else {
                throw new RuntimeException("Unsupported platform " + arch);
            }
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

