/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.test.models.CustomMatcher;
import com.azure.core.test.models.TestProxyRequestMatcher;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.models.TestProxySanitizerType;
import com.azure.core.test.utils.TestUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class TestProxyUtils {
    private static final ClientLogger LOGGER = new ClientLogger(TestProxyUtils.class);
    private static final HttpHeaderName X_RECORDING_SKIP = HttpHeaderName.fromString((String)"x-recording-skip");
    private static final List<String> JSON_PROPERTIES_TO_REDACT = new ArrayList<String>(Arrays.asList("authHeader", "accountKey", "accessToken", "accountName", "applicationId", "apiKey", "connectionString", "url", "host", "password", "userName"));
    private static final Map<String, String> HEADER_KEY_REGEX_TO_REDACT = new HashMap<String, String>(){
        {
            this.put("Operation-Location", TestProxyUtils.URL_REGEX);
            this.put("operation-location", TestProxyUtils.URL_REGEX);
        }
    };
    private static final List<String> BODY_REGEX_TO_REDACT = new ArrayList<String>(Arrays.asList("(?:<Value>)(?<secret>.*)(?:</Value>)", "(?:Password=)(?<secret>.*)(?:;)", "(?:User ID=)(?<secret>.*)(?:;)", "(?:<PrimaryKey>)(?<secret>.*)(?:</PrimaryKey>)", "(?:<SecondaryKey>)(?<secret>.*)(?:</SecondaryKey>)"));
    private static final String URL_REGEX = "(?<=http://|https://)([^/?]+)";
    private static final List<String> HEADER_KEYS_TO_REDACT = new ArrayList<String>(Arrays.asList("Ocp-Apim-Subscription-Key", "api-key", "x-api-key"));
    private static final String REDACTED_VALUE = "REDACTED";
    private static final String DELEGATION_KEY_CLIENTID_REGEX = "(?:<SignedOid>)(?<secret>.*)(?:</SignedOid>)";
    private static final String DELEGATION_KEY_TENANTID_REGEX = "(?:<SignedTid>)(?<secret>.*)(?:</SignedTid>)";
    private static final HttpHeaderName X_RECORDING_UPSTREAM_BASE_URI = HttpHeaderName.fromString((String)"x-recording-upstream-base-uri");
    private static final HttpHeaderName X_RECORDING_MODE = HttpHeaderName.fromString((String)"x-recording-mode");
    private static final HttpHeaderName X_REQUEST_MISMATCH_ERROR = HttpHeaderName.fromString((String)"x-request-mismatch-error");
    private static final HttpHeaderName X_REQUEST_KNOWN_EXCEPTION_ERROR = HttpHeaderName.fromString((String)"x-request-known-exception-error");
    private static final HttpHeaderName X_REQUEST_EXCEPTION_EXCEPTION_ERROR = HttpHeaderName.fromString((String)"x-request-exception-exception-error");
    private static final HttpHeaderName X_ABSTRACTION_IDENTIFIER = HttpHeaderName.fromString((String)"x-abstraction-identifier");
    private static volatile URL proxyUrl;

    public static void changeHeaders(HttpRequest request, URL proxyUrl, String xRecordingId, String mode, boolean skipRecordingRequestBody) {
        HttpHeader upstreamUri = request.getHeaders().get(X_RECORDING_UPSTREAM_BASE_URI);
        UrlBuilder proxyUrlBuilder = UrlBuilder.parse((URL)request.getUrl());
        proxyUrlBuilder.setScheme(proxyUrl.getProtocol());
        proxyUrlBuilder.setHost(proxyUrl.getHost());
        if (proxyUrl.getPort() != -1) {
            proxyUrlBuilder.setPort(proxyUrl.getPort());
        }
        UrlBuilder originalUrlBuilder = UrlBuilder.parse((URL)request.getUrl());
        originalUrlBuilder.setPath("");
        originalUrlBuilder.setQuery("");
        try {
            URL originalUrl = originalUrlBuilder.toUrl();
            HttpHeaders headers = request.getHeaders();
            if (upstreamUri == null) {
                headers.set(X_RECORDING_UPSTREAM_BASE_URI, originalUrl.toString());
                headers.set(X_RECORDING_MODE, mode);
                headers.set(TestingHelpers.X_RECORDING_ID, xRecordingId);
                if (mode.equals("record") && skipRecordingRequestBody) {
                    headers.set(X_RECORDING_SKIP, "request-body");
                }
            }
            request.setUrl(proxyUrlBuilder.toUrl());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getAssetJsonFile(File recordFile, Path testClassPath) {
        if (TestProxyUtils.assetJsonFileExists(testClassPath)) {
            return Paths.get(recordFile.toPath().subpath(0, 3).toString(), "assets.json").toString();
        }
        return null;
    }

    private static boolean assetJsonFileExists(Path testClassPath) {
        return Files.exists(Paths.get(String.valueOf(TestUtils.getRepoRootResolveUntil(testClassPath, "target")), "assets.json"), new LinkOption[0]);
    }

    public static HttpResponse resetTestProxyData(HttpResponse response) {
        HttpRequest responseRequest = response.getRequest();
        HttpHeaders requestHeaders = responseRequest.getHeaders();
        try {
            URL originalUrl = UrlBuilder.parse((String)requestHeaders.getValue(X_RECORDING_UPSTREAM_BASE_URI)).toUrl();
            UrlBuilder currentUrl = UrlBuilder.parse((URL)responseRequest.getUrl());
            currentUrl.setScheme(originalUrl.getProtocol());
            currentUrl.setHost(originalUrl.getHost());
            int port = originalUrl.getPort();
            if (port == -1) {
                currentUrl.setPort("");
            } else {
                currentUrl.setPort(port);
            }
            responseRequest.setUrl(currentUrl.toUrl());
            requestHeaders.remove(X_RECORDING_UPSTREAM_BASE_URI);
            requestHeaders.remove(X_RECORDING_MODE);
            requestHeaders.remove(X_RECORDING_SKIP);
            requestHeaders.remove(TestingHelpers.X_RECORDING_ID);
            return response;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getProxyProcessName() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (osName.contains("windows")) {
            return "Azure.Sdk.Tools.TestProxy.exe";
        }
        if (osName.contains("linux")) {
            return "Azure.Sdk.Tools.TestProxy";
        }
        if (osName.contains("mac os x")) {
            return "Azure.Sdk.Tools.TestProxy";
        }
        throw new UnsupportedOperationException();
    }

    public static void checkForTestProxyErrors(HttpResponse httpResponse) {
        String error = httpResponse.getHeaderValue(X_REQUEST_MISMATCH_ERROR);
        if (error == null) {
            error = httpResponse.getHeaderValue(X_REQUEST_KNOWN_EXCEPTION_ERROR);
        }
        if (error == null) {
            error = httpResponse.getHeaderValue(X_REQUEST_EXCEPTION_EXCEPTION_ERROR);
        }
        if (error != null) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Test proxy exception: " + new String(Base64.getDecoder().decode(error), StandardCharsets.UTF_8)));
        }
    }

    public static String getTestProxyVersion(Path testClassPath) {
        Path rootPath = TestUtils.getRepoRootResolveUntil(testClassPath, "eng");
        Path versionFile = Paths.get("eng", "common", "testproxy", "target_version.txt");
        rootPath = rootPath.resolve(versionFile);
        try {
            return Files.readAllLines(rootPath).get(0).replace(System.getProperty("line.separator"), "");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL getProxyUrl() {
        if (proxyUrl != null) {
            return proxyUrl;
        }
        UrlBuilder builder = new UrlBuilder();
        builder.setHost("localhost");
        builder.setScheme("http");
        builder.setPort(5000);
        try {
            proxyUrl = builder.toUrl();
            return proxyUrl;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<TestProxySanitizer> loadSanitizers() {
        ArrayList<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>(TestProxyUtils.addDefaultRegexSanitizers());
        sanitizers.add(TestProxyUtils.addDefaultUrlSanitizer());
        sanitizers.addAll(TestProxyUtils.addDefaultBodySanitizers());
        sanitizers.addAll(TestProxyUtils.addDefaultHeaderKeySanitizers());
        return sanitizers;
    }

    private static String createCustomMatcherRequestBody(CustomMatcher customMatcher) {
        return String.format("{\"ignoredHeaders\":\"%s\",\"excludedHeaders\":\"%s\",\"compareBodies\":%s,\"ignoredQueryParameters\":\"%s\", \"ignoreQueryOrdering\":%s}", TestProxyUtils.getCommaSeperatedString(customMatcher.getHeadersKeyOnlyMatch()), TestProxyUtils.getCommaSeperatedString(customMatcher.getExcludedHeaders()), customMatcher.isComparingBodies(), TestProxyUtils.getCommaSeperatedString(customMatcher.getIgnoredQueryParameters()), customMatcher.isQueryOrderingIgnored());
    }

    private static String getCommaSeperatedString(List<String> stringList) {
        if (stringList == null) {
            return null;
        }
        return stringList.stream().filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(","));
    }

    private static String createBodyJsonKeyRequestBody(String jsonKey, String regex, String redactedValue) {
        if (regex == null) {
            return String.format("{\"value\":\"%s\",\"jsonPath\":\"%s\"}", redactedValue, jsonKey);
        }
        return String.format("{\"value\":\"%s\",\"jsonPath\":\"%s\",\"regex\":\"%s\"}", redactedValue, jsonKey, regex);
    }

    private static String createRegexRequestBody(String key, String regex, String value, String groupForReplace) {
        if (key == null) {
            if (groupForReplace == null) {
                return String.format("{\"value\":\"%s\",\"regex\":\"%s\"}", value, regex);
            }
            return String.format("{\"value\":\"%s\",\"regex\":\"%s\",\"groupForReplace\":\"%s\"}", value, regex, groupForReplace);
        }
        if (regex == null) {
            return String.format("{\"key\":\"%s\",\"value\":\"%s\"}", key, value);
        }
        if (groupForReplace == null) {
            return String.format("{\"key\":\"%s\",\"value\":\"%s\",\"regex\":\"%s\"}", key, value, regex);
        }
        return String.format("{\"key\":\"%s\",\"value\":\"%s\",\"regex\":\"%s\",\"groupForReplace\":\"%s\"}", key, value, regex, groupForReplace);
    }

    public static List<HttpRequest> getSanitizerRequests(List<TestProxySanitizer> sanitizers, URL proxyUrl) {
        return sanitizers.stream().map(testProxySanitizer -> {
            switch (testProxySanitizer.getType()) {
                case URL: {
                    String sanitizerType = TestProxySanitizerType.URL.getName();
                    String requestBody = TestProxyUtils.createRegexRequestBody(null, testProxySanitizer.getRegex(), testProxySanitizer.getRedactedValue(), testProxySanitizer.getGroupForReplace());
                    return TestProxyUtils.createHttpRequest(requestBody, sanitizerType, proxyUrl);
                }
                case BODY_REGEX: {
                    String sanitizerType = TestProxySanitizerType.BODY_REGEX.getName();
                    String requestBody = TestProxyUtils.createRegexRequestBody(null, testProxySanitizer.getRegex(), testProxySanitizer.getRedactedValue(), testProxySanitizer.getGroupForReplace());
                    return TestProxyUtils.createHttpRequest(requestBody, sanitizerType, proxyUrl);
                }
                case BODY_KEY: {
                    String sanitizerType = TestProxySanitizerType.BODY_KEY.getName();
                    String requestBody = TestProxyUtils.createBodyJsonKeyRequestBody(testProxySanitizer.getKey(), testProxySanitizer.getRegex(), testProxySanitizer.getRedactedValue());
                    return TestProxyUtils.createHttpRequest(requestBody, sanitizerType, proxyUrl);
                }
                case HEADER: {
                    String sanitizerType = TestProxySanitizerType.HEADER.getName();
                    if (testProxySanitizer.getKey() == null && testProxySanitizer.getRegex() == null) {
                        throw new RuntimeException(String.format("Missing regexKey and/or headerKey for sanitizer type {%s}", sanitizerType));
                    }
                    String requestBody = TestProxyUtils.createRegexRequestBody(testProxySanitizer.getKey(), testProxySanitizer.getRegex(), testProxySanitizer.getRedactedValue(), testProxySanitizer.getGroupForReplace());
                    return TestProxyUtils.createHttpRequest(requestBody, sanitizerType, proxyUrl);
                }
            }
            throw new RuntimeException(String.format("Sanitizer type {%s} not supported", new Object[]{testProxySanitizer.getType()}));
        }).collect(Collectors.toList());
    }

    private static HttpRequest createHttpRequest(String requestBody, String sanitizerType, URL proxyUrl) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/Admin/AddSanitizer", proxyUrl.toString())).setBody(requestBody);
        request.setHeader(X_ABSTRACTION_IDENTIFIER, sanitizerType);
        return request;
    }

    public static List<HttpRequest> getMatcherRequests(List<TestProxyRequestMatcher> matchers, URL proxyUrl) {
        return matchers.stream().map(testProxyMatcher -> {
            HttpRequest request;
            String matcherType;
            switch (testProxyMatcher.getType()) {
                case HEADERLESS: {
                    matcherType = TestProxyRequestMatcher.TestProxyRequestMatcherType.HEADERLESS.getName();
                    request = new HttpRequest(HttpMethod.POST, String.format("%s/Admin/setmatcher", proxyUrl.toString()));
                    break;
                }
                case BODILESS: {
                    request = new HttpRequest(HttpMethod.POST, String.format("%s/Admin/setmatcher", proxyUrl.toString()));
                    matcherType = TestProxyRequestMatcher.TestProxyRequestMatcherType.BODILESS.getName();
                    break;
                }
                case CUSTOM: {
                    CustomMatcher customMatcher = (CustomMatcher)testProxyMatcher;
                    String requestBody = TestProxyUtils.createCustomMatcherRequestBody(customMatcher);
                    matcherType = TestProxyRequestMatcher.TestProxyRequestMatcherType.CUSTOM.getName();
                    request = new HttpRequest(HttpMethod.POST, String.format("%s/Admin/setmatcher", proxyUrl.toString())).setBody(requestBody);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Matcher type {%s} not supported", new Object[]{testProxyMatcher.getType()}));
                }
            }
            request.setHeader(X_ABSTRACTION_IDENTIFIER, matcherType);
            return request;
        }).collect(Collectors.toList());
    }

    public static HttpRequest setCompareBodiesMatcher() {
        String requestBody = TestProxyUtils.createCustomMatcherRequestBody(new CustomMatcher().setComparingBodies(false));
        HttpRequest request = new HttpRequest(HttpMethod.POST, String.format("%s/Admin/setmatcher", proxyUrl.toString())).setBody(requestBody);
        request.setHeader(X_ABSTRACTION_IDENTIFIER, TestProxyRequestMatcher.TestProxyRequestMatcherType.CUSTOM.getName());
        return request;
    }

    private static TestProxySanitizer addDefaultUrlSanitizer() {
        return new TestProxySanitizer(URL_REGEX, REDACTED_VALUE, TestProxySanitizerType.URL);
    }

    private static List<TestProxySanitizer> addDefaultBodySanitizers() {
        return JSON_PROPERTIES_TO_REDACT.stream().map(jsonProperty -> new TestProxySanitizer(String.format("$..%s", jsonProperty), null, REDACTED_VALUE, TestProxySanitizerType.BODY_KEY)).collect(Collectors.toList());
    }

    private static List<TestProxySanitizer> addDefaultRegexSanitizers() {
        List<TestProxySanitizer> regexSanitizers = TestProxyUtils.getUserDelegationSanitizers();
        regexSanitizers.addAll(BODY_REGEX_TO_REDACT.stream().map(bodyRegex -> new TestProxySanitizer((String)bodyRegex, REDACTED_VALUE, TestProxySanitizerType.BODY_REGEX).setGroupForReplace("secret")).collect(Collectors.toList()));
        ArrayList keyRegexSanitizers = new ArrayList();
        HEADER_KEY_REGEX_TO_REDACT.forEach((key, regex) -> keyRegexSanitizers.add(new TestProxySanitizer((String)key, (String)regex, REDACTED_VALUE, TestProxySanitizerType.HEADER)));
        regexSanitizers.addAll(keyRegexSanitizers);
        return regexSanitizers;
    }

    private static List<TestProxySanitizer> addDefaultHeaderKeySanitizers() {
        return HEADER_KEYS_TO_REDACT.stream().map(headerKey -> new TestProxySanitizer((String)headerKey, null, REDACTED_VALUE, TestProxySanitizerType.HEADER)).collect(Collectors.toList());
    }

    private static List<TestProxySanitizer> getUserDelegationSanitizers() {
        ArrayList<TestProxySanitizer> userDelegationSanitizers = new ArrayList<TestProxySanitizer>();
        userDelegationSanitizers.add(new TestProxySanitizer(DELEGATION_KEY_CLIENTID_REGEX, REDACTED_VALUE, TestProxySanitizerType.BODY_REGEX).setGroupForReplace("secret"));
        userDelegationSanitizers.add(new TestProxySanitizer(DELEGATION_KEY_TENANTID_REGEX, REDACTED_VALUE, TestProxySanitizerType.BODY_REGEX).setGroupForReplace("secret"));
        return userDelegationSanitizers;
    }
}

