/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;

public final class TestUtils {
    private static final ClientLogger LOGGER = new ClientLogger(TestUtils.class);
    private static final String RECORD_FOLDER = "session-records/";

    public static void assertArraysEqual(byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    public static void assertArraysEqual(byte[] expected, int expectedOffset, byte[] actual, int actualOffset, int length) {
        TestUtils.assertByteBuffersEqual(ByteBuffer.wrap(expected, expectedOffset, length), ByteBuffer.wrap(actual, actualOffset, length));
    }

    public static void assertByteBuffersEqual(ByteBuffer expected, ByteBuffer actual) {
        int expectedPosition = 0;
        int actualPosition = 0;
        if (expected != null) {
            expectedPosition = expected.position();
        }
        if (actual != null) {
            actualPosition = actual.position();
        }
        if (!Objects.equals(expected, actual)) {
            byte[] expectedArray = null;
            if (expected != null) {
                expected.position(expectedPosition);
                expectedArray = new byte[expected.remaining()];
                expected.get(expectedArray);
            }
            byte[] actualArray = null;
            if (actual != null) {
                actual.position(actualPosition);
                actualArray = new byte[actual.remaining()];
                actual.get(actualArray);
            }
            Assertions.assertArrayEquals(expectedArray, actualArray);
        }
    }

    public static File getRecordFolder() {
        URL folderUrl = TestUtils.class.getClassLoader().getResource(RECORD_FOLDER);
        if (folderUrl != null) {
            return new File(TestUtils.toURI(folderUrl));
        }
        throw new IllegalStateException("Unable to locate session-records folder. Please create a session-records folder in '/src/test/resources' of the module (ex. for azure-core-test this is '/sdk/core/azure-core-test/src/test/resources/session-records').");
    }

    public static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(ex));
        }
    }

    private TestUtils() {
    }

    public static Path getRepoRootResolveUntil(Path testClassPath, String resolveFolder) {
        Path path;
        String repoName = "\\azure-sdk-for-java";
        Path candidate = null;
        for (path = testClassPath; path != null && !path.endsWith(repoName) && !Files.exists(candidate = path.resolve(resolveFolder), new LinkOption[0]); path = path.getParent()) {
        }
        if (path == null) {
            throw new RuntimeException(String.format("Could not locate %s folder within repository %s", resolveFolder, repoName));
        }
        return path;
    }
}

