/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.TestBase;
import com.azure.core.test.TestMode;
import com.azure.core.test.utils.TestProxyManager;
import com.azure.core.test.utils.TestUtils;
import com.azure.core.util.logging.ClientLogger;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInfo;

public abstract class TestProxyTestBase
extends TestBase {
    private static final ClientLogger LOGGER = new ClientLogger(TestProxyTestBase.class);
    private static TestProxyManager testProxyManager;

    @BeforeAll
    public static void setupTestProxy(TestInfo testInfo) {
        testMode = TestProxyTestBase.initializeTestMode();
        Path testClassPath = Paths.get(TestUtils.toURI(((Class)testInfo.getTestClass().get()).getResource(((Class)testInfo.getTestClass().get()).getSimpleName() + ".class")));
        if (TestProxyTestBase.isTestProxyEnabled() && (testMode == TestMode.PLAYBACK || testMode == TestMode.RECORD)) {
            testProxyManager = new TestProxyManager(testClassPath);
            testProxyManager.startProxy();
        }
    }

    @AfterAll
    public static void teardownTestProxy() {
        if (testProxyManager != null) {
            testProxyManager.stopProxy();
        }
    }

    static {
        TestProxyTestBase.setTestProxyEnabled();
    }
}

