/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyDownloader;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.test.utils.TestUtils;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;

public class TestProxyManager {
    private static final ClientLogger LOGGER = new ClientLogger(TestProxyManager.class);
    private Process proxy;
    private final Path testClassPath;

    public TestProxyManager(Path testClassPath) {
        this.testClassPath = testClassPath;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopProxy));
        if (this.runningLocally()) {
            TestProxyDownloader.installTestProxy(testClassPath);
        }
    }

    public void startProxy() {
        try {
            if (this.runningLocally() && !this.checkAlive(1, Duration.ofSeconds(1L))) {
                String commandLine = Paths.get(TestProxyDownloader.getProxyDirectory().toString(), TestProxyUtils.getProxyProcessName()).toString();
                ProcessBuilder builder = new ProcessBuilder(commandLine, "--storage-location", TestUtils.getRepoRootResolveUntil(this.testClassPath, "eng").toString());
                Map<String, String> environment = builder.environment();
                environment.put("LOGGING__LOGLEVEL", "Information");
                environment.put("LOGGING__LOGLEVEL__MICROSOFT", "Warning");
                environment.put("LOGGING__LOGLEVEL__DEFAULT", "Information");
                this.proxy = builder.start();
            }
            if (this.checkAlive(10, Duration.ofSeconds(6L))) {
                return;
            }
            throw new RuntimeException("Test proxy did not initialize.");
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkAlive(int loops, Duration waitTime) throws InterruptedException {
        HttpURLConnectionHttpClient client = new HttpURLConnectionHttpClient();
        HttpRequest request = new HttpRequest(HttpMethod.GET, String.format("%s/admin/isalive", TestProxyUtils.getProxyUrl()));
        for (int i = 0; i < loops; ++i) {
            HttpResponse response = null;
            try {
                response = client.sendSync(request, Context.NONE);
                if (response != null && response.getStatusCode() == 200) {
                    return true;
                }
                TestProxyUtils.checkForTestProxyErrors(response);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.sleep(waitTime.toMillis());
        }
        return false;
    }

    public void stopProxy() {
        if (this.proxy != null && this.proxy.isAlive()) {
            this.proxy.destroy();
        }
    }

    private boolean runningLocally() {
        return Configuration.getGlobalConfiguration().get("TF_BUILD") == null && Configuration.getGlobalConfiguration().get("CI") == null;
    }
}

