/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.PortPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.test.MyRestException;
import com.azure.core.test.SyncAsyncExtension;
import com.azure.core.test.annotation.SyncAsyncTest;
import com.azure.core.test.implementation.entities.HttpBinFormDataJSON;
import com.azure.core.test.implementation.entities.HttpBinHeaders;
import com.azure.core.test.implementation.entities.HttpBinJSON;
import com.azure.core.test.utils.MessageDigestUtils;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.io.IOUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Named;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.test.StepVerifier;
import reactor.util.function.Tuples;

@Execution(value=ExecutionMode.SAME_THREAD)
public abstract class HttpClientTests {
    private static final ClientLogger LOGGER = new ClientLogger(HttpClientTests.class);
    private static final String PLAIN_RESPONSE = "plainBytesNoHeader";
    private static final String HEADER_RESPONSE = "plainBytesWithHeader";
    private static final String INVALID_HEADER_RESPONSE = "plainBytesInvalidHeader";
    private static final String UTF_8_BOM_RESPONSE = "utf8BomBytes";
    private static final String UTF_16BE_BOM_RESPONSE = "utf16BeBomBytes";
    private static final String UTF_16LE_BOM_RESPONSE = "utf16LeBomBytes";
    private static final String UTF_32BE_BOM_RESPONSE = "utf32BeBomBytes";
    private static final String UTF_32LE_BOM_RESPONSE = "utf32LeBomBytes";
    private static final String BOM_WITH_SAME_HEADER = "bomBytesWithSameHeader";
    private static final String BOM_WITH_DIFFERENT_HEADER = "bomBytesWithDifferentHeader";
    protected static final String ECHO_RESPONSE = "echo";
    private static final byte[] EXPECTED_RETURN_BYTES = "Hello World!".getBytes(StandardCharsets.UTF_8);
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private static final HttpHeaderName HEADER_A = HttpHeaderName.fromString((String)"A");
    private static final HttpHeaderName HEADER_B = HttpHeaderName.fromString((String)"B");
    private static final HttpHeaderName MY_HEADER = HttpHeaderName.fromString((String)"MyHeader");
    private static final HttpHeaderName MY_OTHER_HEADER = HttpHeaderName.fromString((String)"MyOtherHeader");
    private static final HttpHeaderName RANDOM_HEADER = HttpHeaderName.fromString((String)"randomHeader");

    protected abstract HttpClient createHttpClient();

    @Deprecated
    protected abstract int getPort();

    protected abstract String getServerUri(boolean var1);

    protected boolean isSecure() {
        return false;
    }

    private String getRequestUri() {
        return this.getServerUri(this.isSecure());
    }

    private String getRequestScheme() {
        return this.isSecure() ? "https" : "http";
    }

    @SyncAsyncTest
    public void plainResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(PLAIN_RESPONSE), () -> this.sendRequest(PLAIN_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void headerResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16BE);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(HEADER_RESPONSE), () -> this.sendRequest(HEADER_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void invalidHeaderResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(INVALID_HEADER_RESPONSE), () -> this.sendRequest(INVALID_HEADER_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf8BomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_8_BOM_RESPONSE), () -> this.sendRequest(UTF_8_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf16BeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16BE);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_16BE_BOM_RESPONSE), () -> this.sendRequest(UTF_16BE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf16LeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16LE);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_16LE_BOM_RESPONSE), () -> this.sendRequest(UTF_16LE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf32BeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, Charset.forName("UTF-32BE"));
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_32BE_BOM_RESPONSE), () -> this.sendRequest(UTF_32BE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void utf32LeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, Charset.forName("UTF-32LE"));
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(UTF_32LE_BOM_RESPONSE), () -> this.sendRequest(UTF_32LE_BOM_RESPONSE));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void bomWithSameHeader() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(BOM_WITH_SAME_HEADER), () -> this.sendRequest(BOM_WITH_SAME_HEADER));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void bomWithDifferentHeader() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        String actual = SyncAsyncExtension.execute(() -> this.sendRequestSync(BOM_WITH_DIFFERENT_HEADER), () -> this.sendRequest(BOM_WITH_DIFFERENT_HEADER));
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @SyncAsyncTest
    public void canAccessResponseBody() throws IOException {
        BinaryData requestBody = BinaryData.fromString((String)"test body");
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        Supplier<HttpResponse> responseSupplier = () -> SyncAsyncExtension.execute(() -> this.createHttpClient().sendSync(request, Context.NONE), () -> this.createHttpClient().send(request));
        Assertions.assertEquals((Object)requestBody.toString(), (Object)responseSupplier.get().getBodyAsString().block());
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])responseSupplier.get().getBodyAsByteArray().block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])responseSupplier.get().getBodyAsBinaryData().toBytes());
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])responseSupplier.get().getBodyAsInputStream().map(s -> BinaryData.fromStream((InputStream)s).toBytes()).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])BinaryData.fromFlux((Flux)responseSupplier.get().getBody()).map(BinaryData::toBytes).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])this.getResponseBytesViaWritableChannel(responseSupplier.get()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])this.getResponseBytesViaAsynchronousChannel(responseSupplier.get()));
    }

    @SyncAsyncTest
    public void shouldBufferResponse() {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), BinaryData.fromString((String)"test body"));
        Context context = Context.NONE.addData((Object)"azure-eagerly-read-response", (Object)true);
        HttpResponse response = SyncAsyncExtension.execute(() -> this.createHttpClient().sendSync(request, context), () -> this.createHttpClient().send(request, context));
        HttpResponse bufferedResponse = response.buffer();
        Assertions.assertSame((Object)response, (Object)bufferedResponse);
    }

    @SyncAsyncTest
    public void bufferedResponseCanBeReadMultipleTimes() throws IOException {
        BinaryData requestBody = BinaryData.fromString((String)"test body");
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        Context context = Context.NONE.addData((Object)"azure-eagerly-read-response", (Object)true);
        HttpResponse response = SyncAsyncExtension.execute(() -> this.createHttpClient().sendSync(request, context), () -> this.createHttpClient().send(request, context));
        Assertions.assertEquals((Object)requestBody.toString(), (Object)response.getBodyAsString().block());
        Assertions.assertEquals((Object)requestBody.toString(), (Object)response.getBodyAsString().block());
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsByteArray().block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsByteArray().block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])response.getBodyAsBinaryData().toBytes());
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])response.getBodyAsBinaryData().toBytes());
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsInputStream().map(s -> BinaryData.fromStream((InputStream)s).toBytes()).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])response.getBodyAsInputStream().map(s -> BinaryData.fromStream((InputStream)s).toBytes()).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])BinaryData.fromFlux((Flux)response.getBody()).map(BinaryData::toBytes).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])((byte[])BinaryData.fromFlux((Flux)response.getBody()).map(BinaryData::toBytes).block()));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])this.getResponseBytesViaWritableChannel(response));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])this.getResponseBytesViaWritableChannel(response));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])this.getResponseBytesViaAsynchronousChannel(response));
        Assertions.assertArrayEquals((byte[])requestBody.toBytes(), (byte[])this.getResponseBytesViaAsynchronousChannel(response));
    }

    @SyncAsyncTest
    public void eagerlyConvertedHeadersAreHttpHeaders() {
        BinaryData requestBody = BinaryData.fromString((String)"test body");
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        Context context = Context.NONE.addData((Object)"azure-eagerly-convert-headers", (Object)true);
        try (HttpResponse response = SyncAsyncExtension.execute(() -> this.createHttpClient().sendSync(request, context), () -> this.createHttpClient().send(request, context));){
            Assertions.assertEquals(HttpHeaders.class, response.getHeaders().getClass());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryData(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        StepVerifier.create((Publisher)this.createHttpClient().send(request).flatMap(HttpResponse::getBodyAsByteArray)).assertNext(responseBytes -> Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes)).verifyComplete();
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryDataSync(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        HttpResponse httpResponse = this.createHttpClient().sendSync(request, Context.NONE);
        byte[] responseBytes = (byte[])httpResponse.getBodyAsByteArray().block();
        Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes);
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryDataWithProgressReporting(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        AtomicLong progress = new AtomicLong();
        Context context = Contexts.empty().setHttpRequestProgressReporter(ProgressReporter.withProgressListener(progress::set)).getContext();
        StepVerifier.create((Publisher)this.createHttpClient().send(request, context).flatMap(HttpResponse::getBodyAsByteArray)).assertNext(responseBytes -> Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes)).verifyComplete();
        Assertions.assertEquals((int)expectedResponseBody.length, (int)progress.intValue());
    }

    @ParameterizedTest
    @MethodSource(value={"getBinaryDataBodyVariants"})
    public void canSendBinaryDataWithProgressReportingSync(BinaryData requestBody, byte[] expectedResponseBody) {
        HttpRequest request = new HttpRequest(HttpMethod.PUT, this.getRequestUrl(ECHO_RESPONSE), new HttpHeaders(), requestBody);
        AtomicLong progress = new AtomicLong();
        Context context = Contexts.empty().setHttpRequestProgressReporter(ProgressReporter.withProgressListener(progress::set)).getContext();
        HttpResponse httpResponse = this.createHttpClient().sendSync(request, context);
        byte[] responseBytes = (byte[])httpResponse.getBodyAsByteArray().block();
        Assertions.assertArrayEquals((byte[])expectedResponseBody, (byte[])responseBytes);
        Assertions.assertEquals((int)expectedResponseBody.length, (int)progress.intValue());
    }

    private static Stream<Arguments> getBinaryDataBodyVariants() {
        return Stream.of(1, 2, 10, 127, 1024, 1181, 8195, 0xA0000D).flatMap(size -> {
            try {
                byte[] bytes = new byte[size.intValue()];
                ThreadLocalRandom.current().nextBytes(bytes);
                BinaryData byteArrayData = BinaryData.fromBytes((byte[])bytes);
                String randomString = new String(bytes, StandardCharsets.UTF_8);
                byte[] randomStringBytes = randomString.getBytes(StandardCharsets.UTF_8);
                BinaryData stringBinaryData = BinaryData.fromString((String)randomString);
                BinaryData streamData = BinaryData.fromStream((InputStream)new ByteArrayInputStream(bytes), (Long)Long.valueOf(bytes.length));
                ArrayList<ByteBuffer> bufferList = new ArrayList<ByteBuffer>();
                int bufferSize = 1023;
                for (int startIndex = 0; startIndex < bytes.length; startIndex += bufferSize) {
                    bufferList.add(ByteBuffer.wrap(bytes, startIndex, Math.min(bytes.length - startIndex, bufferSize)));
                }
                BinaryData fluxBinaryData = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate), null, (boolean)false).block();
                BinaryData fluxBinaryDataWithLength = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate), (Long)size.longValue(), (boolean)false).block();
                BinaryData asyncFluxBinaryData = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate).delayElements(Duration.ofNanos(10L)), null, (boolean)false).block();
                BinaryData asyncFluxBinaryDataWithLength = (BinaryData)BinaryData.fromFlux((Flux)Flux.fromIterable(bufferList).map(ByteBuffer::duplicate).delayElements(Duration.ofNanos(10L)), (Long)size.longValue(), (boolean)false).block();
                BinaryData objectBinaryData = BinaryData.fromObject((Object)bytes, (ObjectSerializer)new ByteArraySerializer());
                Path wholeFile = Files.createTempFile("http-client-tests", null, new FileAttribute[0]);
                wholeFile.toFile().deleteOnExit();
                Files.write(wholeFile, bytes, new OpenOption[0]);
                BinaryData fileData = BinaryData.fromFile((Path)wholeFile);
                Path sliceFile = Files.createTempFile("http-client-tests", null, new FileAttribute[0]);
                sliceFile.toFile().deleteOnExit();
                Files.write(sliceFile, new byte[size.intValue()], StandardOpenOption.APPEND);
                Files.write(sliceFile, bytes, StandardOpenOption.APPEND);
                Files.write(sliceFile, new byte[size.intValue()], StandardOpenOption.APPEND);
                BinaryData sliceFileData = BinaryData.fromFile((Path)sliceFile, (Long)((Object)size), (Long)((Object)size));
                return Stream.of(Arguments.of((Object[])new Object[]{Named.named((String)"byte[]", (Object)byteArrayData), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"String", (Object)stringBinaryData), Named.named((String)String.valueOf(randomStringBytes.length), (Object)randomStringBytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"InputStream", (Object)streamData), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"Flux", (Object)fluxBinaryData), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"Flux with length", (Object)fluxBinaryDataWithLength), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"async Flux", (Object)asyncFluxBinaryData), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"async Flux with length", (Object)asyncFluxBinaryDataWithLength), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"Object", (Object)objectBinaryData), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"File", (Object)fileData), Named.named((String)String.valueOf(size), (Object)bytes)}), Arguments.of((Object[])new Object[]{Named.named((String)"File slice", (Object)sliceFileData), Named.named((String)String.valueOf(size), (Object)bytes)}));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Mono<String> sendRequest(String requestPath) {
        return this.createHttpClient().send(new HttpRequest(HttpMethod.GET, this.getRequestUrl(requestPath))).flatMap(HttpResponse::getBodyAsString);
    }

    private String sendRequestSync(String requestPath) {
        HttpResponse httpResponse = this.createHttpClient().sendSync(new HttpRequest(HttpMethod.GET, this.getRequestUrl(requestPath)), Context.NONE);
        return (String)httpResponse.getBodyAsString().block();
    }

    protected URL getRequestUrl(String requestPath) {
        try {
            return UrlBuilder.parse((String)(this.getServerUri(this.isSecure()) + "/" + requestPath)).toUrl();
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    private byte[] getResponseBytesViaWritableChannel(HttpResponse response) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        response.writeBodyTo(Channels.newChannel(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] getResponseBytesViaAsynchronousChannel(HttpResponse response) {
        try {
            Path tempFile = Files.createTempFile("httpclienttestsasyncchannel", null, new FileAttribute[0]);
            try (AsynchronousByteChannel channel = IOUtils.toAsynchronousByteChannel((AsynchronousFileChannel)AsynchronousFileChannel.open(tempFile, StandardOpenOption.WRITE), (long)0L);){
                response.writeBodyToAsync(channel).block();
            }
            return Files.readAllBytes(tempFile);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    @Test
    public void syncRequestWithByteArrayReturnType() {
        byte[] result = this.createService(Service1.class).getByteArray(this.getRequestUri());
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)100, (int)result.length);
    }

    @Test
    public void asyncRequestWithByteArrayReturnType() {
        StepVerifier.create(this.createService(Service1.class).getByteArrayAsync(this.getRequestUri())).assertNext(bytes -> Assertions.assertEquals((int)100, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void getByteArrayAsyncWithNoExpectedResponses() {
        StepVerifier.create(this.createService(Service1.class).getByteArrayAsyncWithNoExpectedResponses(this.getRequestUri())).assertNext(bytes -> Assertions.assertEquals((int)100, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void syncRequestWithByteArrayReturnTypeAndParameterizedHostAndPath() {
        byte[] result = this.createService(Service2.class).getByteArray(this.getRequestScheme(), "localhost", 100);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)result.length, (int)100);
    }

    @Test
    public void asyncRequestWithByteArrayReturnTypeAndParameterizedHostAndPath() {
        StepVerifier.create(this.createService(Service2.class).getByteArrayAsync(this.getRequestScheme(), "localhost", 100)).assertNext(bytes -> Assertions.assertEquals((int)100, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void syncRequestWithEmptyByteArrayReturnTypeAndParameterizedHostAndPath() {
        byte[] result = this.createService(Service2.class).getByteArray(this.getRequestScheme(), "localhost", 0);
        Assertions.assertNull((Object)result);
    }

    @Test
    public void syncGetRequestWithNoReturn() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service3.class).getNothing(this.getRequestUri()));
    }

    @Test
    public void asyncGetRequestWithNoReturn() {
        StepVerifier.create(this.createService(Service3.class).getNothingAsync(this.getRequestUri())).verifyComplete();
    }

    @Test
    public void syncGetRequestWithAnything() {
        HttpBinJSON json = this.createService(Service5.class).getAnything(this.getRequestUri());
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPlus(this.getRequestUri());
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything/with+plus", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParam() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam(this.getRequestUri(), "withpathparam");
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything/withpathparam", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParamWithSpace() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam(this.getRequestUri(), "with path param");
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything/with path param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithPathParamWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithPathParam(this.getRequestUri(), "with+path+param");
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything/with+path+param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParam() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam(this.getRequestUri(), "withpathparam");
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything/withpathparam", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParamWithPercent20() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam(this.getRequestUri(), "with%20path%20param");
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything/with path param", json.url());
    }

    @Test
    public void syncGetRequestWithAnythingWithEncodedPathParamWithPlus() {
        HttpBinJSON json = this.createService(Service5.class).getAnythingWithEncodedPathParam(this.getRequestUri(), "with+path+param");
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything/with+path+param", json.url());
    }

    @Test
    public void asyncGetRequestWithAnything() {
        StepVerifier.create(this.createService(Service5.class).getAnythingAsync(this.getRequestUri())).assertNext(json -> HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything", json.url())).verifyComplete();
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnything() {
        HttpBinJSON json = this.createService(Service6.class).getAnything(this.getRequestUri(), "A", 15);
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything?a=A&b=15", json.url());
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnythingWithPercent20() {
        HttpBinJSON json = this.createService(Service6.class).getAnything(this.getRequestUri(), "A%20Z", 15);
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything?a=A%2520Z&b=15", json.url());
    }

    @Test
    public void syncGetRequestWithQueryParametersAndAnythingWithEncodedWithPercent20() {
        HttpBinJSON json = this.createService(Service6.class).getAnythingWithEncoded(this.getRequestUri(), "x%20y", 15);
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything?a=x y&b=15", json.url());
    }

    @Test
    public void asyncGetRequestWithQueryParametersAndAnything() {
        StepVerifier.create(this.createService(Service6.class).getAnythingAsync(this.getRequestUri(), "A", 15)).assertNext(json -> HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything?a=A&b=15", json.url())).verifyComplete();
    }

    @Test
    public void syncGetRequestWithNullQueryParameter() {
        HttpBinJSON json = this.createService(Service6.class).getAnything(this.getRequestUri(), null, 15);
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything?b=15", json.url());
    }

    @Test
    public void syncGetRequestWithHeaderParametersAndAnythingReturn() {
        HttpBinJSON json = this.createService(Service7.class).getAnything(this.getRequestUri(), "A", 15);
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
        Assertions.assertNotNull(json.headers());
        HttpHeaders headers = new HttpHeaders().setAll(json.headers());
        Assertions.assertEquals((Object)"A", (Object)headers.getValue(HEADER_A));
        Assertions.assertArrayEquals((Object[])new String[]{"A"}, (Object[])headers.getValues(HEADER_A));
        Assertions.assertEquals((Object)"15", (Object)headers.getValue(HEADER_B));
        Assertions.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues(HEADER_B));
    }

    @Test
    public void asyncGetRequestWithHeaderParametersAndAnything() {
        StepVerifier.create(this.createService(Service7.class).getAnythingAsync(this.getRequestUri(), "A", 15)).assertNext(json -> {
            HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
            Assertions.assertNotNull(json.headers());
            HttpHeaders headers = new HttpHeaders().setAll(json.headers());
            Assertions.assertEquals((Object)"A", (Object)headers.getValue(HEADER_A));
            Assertions.assertArrayEquals((Object[])new String[]{"A"}, (Object[])headers.getValues(HEADER_A));
            Assertions.assertEquals((Object)"15", (Object)headers.getValue(HEADER_B));
            Assertions.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues(HEADER_B));
        }).verifyComplete();
    }

    @Test
    public void syncGetRequestWithNullHeader() {
        HttpBinJSON json = this.createService(Service7.class).getAnything(this.getRequestUri(), null, 15);
        HttpHeaders headers = new HttpHeaders().setAll(json.headers());
        Assertions.assertNull((Object)headers.getValue(HEADER_A));
        Assertions.assertArrayEquals(null, (Object[])headers.getValues(HEADER_A));
        Assertions.assertEquals((Object)"15", (Object)headers.getValue(HEADER_B));
        Assertions.assertArrayEquals((Object[])new String[]{"15"}, (Object[])headers.getValues(HEADER_B));
    }

    @Test
    public void syncPostRequestWithStringBody() {
        HttpBinJSON json = this.createService(Service8.class).post(this.getRequestUri(), "I'm a post body!");
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"I'm a post body!", (Object)json.data());
    }

    @Test
    public void asyncPostRequestWithStringBody() {
        StepVerifier.create(this.createService(Service8.class).postAsync(this.getRequestUri(), "I'm a post body!")).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"I'm a post body!", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncPostRequestWithNullBody() {
        HttpBinJSON result = this.createService(Service8.class).post(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void syncPutRequestWithIntBody() {
        HttpBinJSON json = this.createService(Service9.class).put(this.getRequestUri(), 42);
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"42", (Object)json.data());
    }

    @Test
    public void asyncPutRequestWithIntBody() {
        StepVerifier.create(this.createService(Service9.class).putAsync(this.getRequestUri(), 42)).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"42", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncPutRequestWithBodyAndEqualContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        HttpBinJSON json = this.createService(Service9.class).putBodyAndContentLength(this.getRequestUri(), body, 4L);
        Assertions.assertEquals((Object)"test", (Object)json.data());
        Assertions.assertEquals((Object)"application/octet-stream", (Object)json.getHeaderValue("Content-Type"));
        Assertions.assertEquals((Object)"4", (Object)json.getHeaderValue("Content-Length"));
    }

    @Test
    public void syncPutRequestWithBodyLessThanContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        Exception unexpectedLengthException = (Exception)Assertions.assertThrows(Exception.class, () -> {
            this.createService(Service9.class).putBodyAndContentLength(this.getRequestUri(), body, 5L);
            body.clear();
        });
        Assertions.assertTrue((boolean)unexpectedLengthException.getMessage().contains("less than"));
    }

    @Test
    public void syncPutRequestWithBodyMoreThanContentLength() {
        ByteBuffer body = ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8));
        Exception unexpectedLengthException = (Exception)Assertions.assertThrows(Exception.class, () -> {
            this.createService(Service9.class).putBodyAndContentLength(this.getRequestUri(), body, 3L);
            body.clear();
        });
        Assertions.assertTrue((boolean)unexpectedLengthException.getMessage().contains("more than"));
    }

    @Test
    public void asyncPutRequestWithBodyAndEqualContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), (Flux<ByteBuffer>)body, 4L)).assertNext(json -> {
            Assertions.assertEquals((Object)"test", (Object)json.data());
            Assertions.assertEquals((Object)"application/octet-stream", (Object)json.getHeaderValue("Content-Type"));
            Assertions.assertEquals((Object)"4", (Object)json.getHeaderValue("Content-Length"));
        }).verifyComplete();
    }

    @Test
    public void asyncPutRequestWithBodyAndLessThanContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), (Flux<ByteBuffer>)body, 5L)).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((exception instanceof UnexpectedLengthException || exception.getSuppressed().length > 0 && exception.getSuppressed()[0] instanceof UnexpectedLengthException ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)exception.getMessage().contains("less than"));
        });
    }

    @Test
    public void asyncPutRequestWithBodyAndMoreThanContentLength() {
        Flux body = Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), (Flux<ByteBuffer>)body, 3L)).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((exception instanceof UnexpectedLengthException || exception.getSuppressed().length > 0 && exception.getSuppressed()[0] instanceof UnexpectedLengthException ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)exception.getMessage().contains("more than"));
        });
    }

    @Test
    public void asyncPutRequestWithBinaryDataBodyAndEqualContentLength() {
        Mono bodyMono = BinaryData.fromFlux((Flux)Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8))));
        StepVerifier.create((Publisher)bodyMono.flatMap(body -> this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), (BinaryData)body, 4L))).assertNext(json -> {
            Assertions.assertEquals((Object)"test", (Object)json.data());
            Assertions.assertEquals((Object)"application/octet-stream", (Object)json.getHeaderValue("Content-Type"));
            Assertions.assertEquals((Object)"4", (Object)json.getHeaderValue("Content-Length"));
        }).verifyComplete();
    }

    @Test
    public void asyncPutRequestWithBinaryDataBodyAndLessThanContentLength() {
        Mono bodyMono = BinaryData.fromFlux((Flux)Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8))));
        StepVerifier.create((Publisher)bodyMono.flatMap(body -> this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), (BinaryData)body, 5L))).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((exception instanceof UnexpectedLengthException || exception.getSuppressed().length > 0 && exception.getSuppressed()[0] instanceof UnexpectedLengthException ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)exception.getMessage().contains("less than"));
        });
    }

    @Test
    public void asyncPutRequestWithStreamBinaryDataBodyAndLessThanContentLength() {
        Mono bodyMono = Mono.just((Object)BinaryData.fromStream((InputStream)new ByteArrayInputStream("test".getBytes(StandardCharsets.UTF_8))));
        StepVerifier.create((Publisher)bodyMono.flatMap(body -> this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), (BinaryData)body, 5L))).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((exception instanceof UnexpectedLengthException || exception.getSuppressed().length > 0 && exception.getSuppressed()[0] instanceof UnexpectedLengthException ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)exception.getMessage().contains("less than"));
        });
    }

    @Test
    public void asyncPutRequestWithBinaryDataBodyAndMoreThanContentLength() {
        Mono bodyMono = BinaryData.fromFlux((Flux)Flux.just((Object)ByteBuffer.wrap("test".getBytes(StandardCharsets.UTF_8))));
        StepVerifier.create((Publisher)bodyMono.flatMap(body -> this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), (BinaryData)body, 3L))).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((exception instanceof UnexpectedLengthException || exception.getSuppressed().length > 0 && exception.getSuppressed()[0] instanceof UnexpectedLengthException ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)exception.getMessage().contains("more than"));
        });
    }

    @Test
    public void asyncPutRequestWithStreamBinaryDataBodyAndMoreThanContentLength() {
        BinaryData body = BinaryData.fromStream((InputStream)new ByteArrayInputStream("test".getBytes(StandardCharsets.UTF_8)));
        StepVerifier.create(this.createService(Service9.class).putAsyncBodyAndContentLength(this.getRequestUri(), body, 3L)).verifyErrorSatisfies(exception -> {
            Assertions.assertTrue((exception instanceof UnexpectedLengthException || exception.getSuppressed().length > 0 && exception.getSuppressed()[0] instanceof UnexpectedLengthException ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)exception.getMessage().contains("more than"));
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponse() {
        HttpResponseException e = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service9.class).putWithUnexpectedResponse(this.getRequestUri(), "I'm the body!"));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
        LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
        Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponse() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAsync(this.getRequestUri(), "I'm the body!")).verifyErrorSatisfies(throwable -> {
            Assertions.assertTrue((boolean)(throwable instanceof HttpResponseException));
            HttpResponseException exception = (HttpResponseException)throwable;
            Assertions.assertNotNull((Object)exception.getValue());
            Assertions.assertTrue((boolean)(exception.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)exception.getValue();
            Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndExceptionType() {
        MyRestException e = (MyRestException)((Object)Assertions.assertThrows(MyRestException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndExceptionType(this.getRequestUri(), "I'm the body!")));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndExceptionTypeAsync(this.getRequestUri(), "I'm the body!")).verifyErrorSatisfies(throwable -> {
            MyRestException myRestException = (MyRestException)((Object)((Object)Assertions.assertInstanceOf(MyRestException.class, (Object)throwable, (String)("Expected MyRestException would be thrown. Instead got " + throwable.getClass().getSimpleName()))));
            Assertions.assertNotNull((Object)myRestException.getValue());
            Assertions.assertEquals((Object)"I'm the body!", (Object)myRestException.getValue().data());
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndDeterminedExceptionType() {
        MyRestException e = (MyRestException)((Object)Assertions.assertThrows(MyRestException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndDeterminedExceptionType(this.getRequestUri(), "I'm the body!")));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndDeterminedExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndDeterminedExceptionTypeAsync(this.getRequestUri(), "I'm the body!")).verifyErrorSatisfies(throwable -> {
            MyRestException myRestException = (MyRestException)((Object)((Object)Assertions.assertInstanceOf(MyRestException.class, (Object)throwable, (String)("Expected MyRestException would be thrown. Instead got " + throwable.getClass().getSimpleName()))));
            Assertions.assertNotNull((Object)myRestException.getValue());
            Assertions.assertEquals((Object)"I'm the body!", (Object)myRestException.getValue().data());
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndFallthroughExceptionType() {
        MyRestException e = (MyRestException)((Object)Assertions.assertThrows(MyRestException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndFallthroughExceptionType(this.getRequestUri(), "I'm the body!")));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertEquals((Object)"I'm the body!", (Object)e.getValue().data());
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndFallthroughExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndFallthroughExceptionTypeAsync(this.getRequestUri(), "I'm the body!")).verifyErrorSatisfies(throwable -> {
            MyRestException myRestException = (MyRestException)((Object)((Object)Assertions.assertInstanceOf(MyRestException.class, (Object)throwable, (String)("Expected MyRestException would be thrown. Instead got " + throwable.getClass().getSimpleName()))));
            Assertions.assertNotNull((Object)myRestException.getValue());
            Assertions.assertEquals((Object)"I'm the body!", (Object)myRestException.getValue().data());
        });
    }

    @Test
    public void syncPutRequestWithUnexpectedResponseAndNoFallthroughExceptionType() {
        HttpResponseException e = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service9.class).putWithUnexpectedResponseAndNoFallthroughExceptionType(this.getRequestUri(), "I'm the body!"));
        Assertions.assertNotNull((Object)e.getValue());
        Assertions.assertTrue((boolean)(e.getValue() instanceof LinkedHashMap));
        LinkedHashMap expectedBody = (LinkedHashMap)e.getValue();
        Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
    }

    @Test
    public void asyncPutRequestWithUnexpectedResponseAndNoFallthroughExceptionType() {
        StepVerifier.create(this.createService(Service9.class).putWithUnexpectedResponseAndNoFallthroughExceptionTypeAsync(this.getRequestUri(), "I'm the body!")).verifyErrorSatisfies(throwable -> {
            HttpResponseException responseException = (HttpResponseException)Assertions.assertInstanceOf(HttpResponseException.class, (Object)throwable, (String)("Expected HttpResponseException would be thrown. Instead got " + throwable.getClass().getSimpleName()));
            Assertions.assertNotNull((Object)responseException.getValue());
            Assertions.assertTrue((boolean)(responseException.getValue() instanceof LinkedHashMap));
            LinkedHashMap expectedBody = (LinkedHashMap)responseException.getValue();
            Assertions.assertEquals((Object)"I'm the body!", expectedBody.get("data"));
        });
    }

    @Test
    public void syncHeadRequest() {
        Void body = (Void)this.createService(Service10.class).head(this.getRequestUri()).getValue();
        Assertions.assertNull((Object)body);
    }

    @Test
    public void syncHeadBooleanRequest() {
        boolean result = this.createService(Service10.class).headBoolean(this.getRequestUri());
        Assertions.assertTrue((boolean)result);
    }

    @Test
    public void syncVoidHeadRequest() {
        this.createService(Service10.class).voidHead(this.getRequestUri());
    }

    @Test
    public void asyncHeadRequest() {
        StepVerifier.create(this.createService(Service10.class).headAsync(this.getRequestUri())).assertNext(response -> Assertions.assertNull((Object)response.getValue())).verifyComplete();
    }

    @Test
    public void asyncHeadBooleanRequest() {
        StepVerifier.create(this.createService(Service10.class).headBooleanAsync(this.getRequestUri())).assertNext(Assertions::assertTrue).verifyComplete();
    }

    @Test
    public void asyncCompletableHeadRequest() {
        StepVerifier.create(this.createService(Service10.class).completableHeadAsync(this.getRequestUri())).verifyComplete();
    }

    @Test
    public void syncDeleteRequest() {
        HttpBinJSON json = this.createService(Service11.class).delete(this.getRequestUri(), false);
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"false", (Object)json.data());
    }

    @Test
    public void asyncDeleteRequest() {
        StepVerifier.create(this.createService(Service11.class).deleteAsync(this.getRequestUri(), false)).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"false", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncPatchRequest() {
        HttpBinJSON json = this.createService(Service12.class).patch(this.getRequestUri(), "body-contents");
        Assertions.assertEquals(String.class, json.data().getClass());
        Assertions.assertEquals((Object)"body-contents", (Object)json.data());
    }

    @Test
    public void asyncPatchRequest() {
        StepVerifier.create(this.createService(Service12.class).patchAsync(this.getRequestUri(), "body-contents")).assertNext(json -> {
            Assertions.assertEquals(String.class, json.data().getClass());
            Assertions.assertEquals((Object)"body-contents", (Object)json.data());
        }).verifyComplete();
    }

    @Test
    public void syncHeadersRequest() {
        HttpBinJSON json = this.createService(Service13.class).get(this.getRequestUri());
        Assertions.assertNotNull((Object)json);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
        Assertions.assertNotNull(json.headers());
        HttpHeaders headers = new HttpHeaders().setAll(json.headers());
        Assertions.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue(MY_HEADER));
        Assertions.assertArrayEquals((Object[])new String[]{"MyHeaderValue"}, (Object[])headers.getValues(MY_HEADER));
        Assertions.assertEquals((Object)"My,Header,Value", (Object)headers.getValue(MY_OTHER_HEADER));
        Assertions.assertArrayEquals((Object[])new String[]{"My", "Header", "Value"}, (Object[])headers.getValues(MY_OTHER_HEADER));
    }

    @Test
    public void asyncHeadersRequest() {
        StepVerifier.create(this.createService(Service13.class).getAsync(this.getRequestUri())).assertNext(json -> {
            HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
            Assertions.assertNotNull(json.headers());
            HttpHeaders headers = new HttpHeaders().setAll(json.headers());
            Assertions.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue(MY_HEADER));
            Assertions.assertArrayEquals((Object[])new String[]{"MyHeaderValue"}, (Object[])headers.getValues(MY_HEADER));
        }).verifyComplete();
    }

    @Test
    public void asyncHttpsHeadersRequest() {
        StepVerifier.create(this.createService(Service14.class).getAsync(this.getRequestUri())).assertNext(json -> {
            HttpClientTests.assertMatchWithHttpOrHttps("localhost/anything", json.url());
            Assertions.assertNotNull(json.headers());
            HttpHeaders headers = new HttpHeaders().setAll(json.headers());
            Assertions.assertEquals((Object)"MyHeaderValue", (Object)headers.getValue(MY_HEADER));
        }).verifyComplete();
    }

    @Test
    public void service16Put() {
        Service16 service16 = this.createService(Service16.class);
        byte[] expectedBytes = new byte[]{1, 2, 3, 4};
        HttpBinJSON httpBinJSON = service16.putByteArray(this.getRequestUri(), expectedBytes);
        Assertions.assertTrue((boolean)(httpBinJSON.data() instanceof String));
        String base64String = (String)httpBinJSON.data();
        byte[] actualBytes = base64String.getBytes();
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
    }

    @Test
    public void service16PutAsync() {
        byte[] expectedBytes = new byte[]{1, 2, 3, 4};
        StepVerifier.create(this.createService(Service16.class).putByteArrayAsync(this.getRequestUri(), expectedBytes)).assertNext(json -> {
            Assertions.assertTrue((boolean)(json.data() instanceof String));
            Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])((String)json.data()).getBytes());
        }).verifyComplete();
    }

    @Test
    public void syncRequestWithMultipleHostParams() {
        HttpBinJSON result = this.createService(Service17.class).get(this.getRequestScheme(), "local", "host");
        Assertions.assertNotNull((Object)result);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/get", result.url());
    }

    @Test
    public void asyncRequestWithMultipleHostParams() {
        StepVerifier.create(this.createService(Service17.class).getAsync(this.getRequestScheme(), "local", "host")).assertNext(json -> HttpClientTests.assertMatchWithHttpOrHttps("localhost/get", json.url())).verifyComplete();
    }

    @Test
    public void service18GetStatus200() {
        this.createService(Service18.class).getStatus200(this.getRequestUri());
    }

    @Test
    public void service18GetStatus200WithExpectedResponse200() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus200WithExpectedResponse200(this.getRequestUri()));
    }

    @Test
    public void service18GetStatus300() {
        this.createService(Service18.class).getStatus300(this.getRequestUri());
    }

    @Test
    public void service18GetStatus300WithExpectedResponse300() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus300WithExpectedResponse300(this.getRequestUri()));
    }

    @Test
    public void service18GetStatus400() {
        Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service18.class).getStatus400(this.getRequestUri()));
    }

    @Test
    public void service18GetStatus400WithExpectedResponse400() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus400WithExpectedResponse400(this.getRequestUri()));
    }

    @Test
    public void service18GetStatus500() {
        Assertions.assertThrows(HttpResponseException.class, () -> this.createService(Service18.class).getStatus500(this.getRequestUri()));
    }

    @Test
    public void service18GetStatus500WithExpectedResponse500() {
        Assertions.assertDoesNotThrow(() -> this.createService(Service18.class).getStatus500WithExpectedResponse500(this.getRequestUri()));
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody(this.getRequestUri(), "");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndStringBody(this.getRequestUri(), "hello");
        Assertions.assertEquals((Object)"hello", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(this.getRequestUri(), new byte[0]);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithNoContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithNoContentTypeAndByteArrayBody(this.getRequestUri(), new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody(this.getRequestUri(), "");
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndStringBody(this.getRequestUri(), "soups and stuff");
        Assertions.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(this.getRequestUri(), new byte[0]);
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndByteArrayBody(this.getRequestUri(), new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)"\"AAECAwQ=\"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(this.getRequestUri(), "");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationJsonContentTypeAndCharsetAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(this.getRequestUri(), "soups and stuff");
        Assertions.assertEquals((Object)"soups and stuff", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody(this.getRequestUri(), "");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndStringBody(this.getRequestUri(), "penguins");
        Assertions.assertEquals((Object)"penguins", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(this.getRequestUri(), new byte[0]);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithHeaderApplicationOctetStreamContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(this.getRequestUri(), new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody(this.getRequestUri(), "");
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndStringBody(this.getRequestUri(), "soups and stuff");
        Assertions.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(this.getRequestUri(), "");
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(this.getRequestUri(), "soups and stuff");
        Assertions.assertEquals((Object)"\"soups and stuff\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(this.getRequestUri(), new byte[0]);
        Assertions.assertEquals((Object)"\"\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationJsonContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(this.getRequestUri(), new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)"\"AAECAwQ=\"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(this.getRequestUri(), "");
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndStringBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(this.getRequestUri(), "penguins");
        Assertions.assertEquals((Object)"penguins", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithNullBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(this.getRequestUri(), null);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(this.getRequestUri(), new byte[0]);
        Assertions.assertEquals((Object)"", (Object)result.data());
    }

    @Test
    public void service19PutWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBodyWithNonEmptyBody() {
        HttpBinJSON result = this.createService(Service19.class).putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(this.getRequestUri(), new byte[]{0, 1, 2, 3, 4});
        Assertions.assertEquals((Object)new String(new byte[]{0, 1, 2, 3, 4}), (Object)result.data());
    }

    @Test
    public void service20GetBytes100OnlyHeaders() {
        ResponseBase<HttpBinHeaders, Void> response = this.createService(Service20.class).getBytes100OnlyHeaders(this.getRequestUri());
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals(HttpHeaders.class, response.getHeaders().getClass());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetBytes100BodyAndHeaders() {
        ResponseBase<HttpBinHeaders, byte[]> response = this.createService(Service20.class).getBytes100BodyAndHeaders(this.getRequestUri());
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals(HttpHeaders.class, response.getHeaders().getClass());
        byte[] body = (byte[])response.getValue();
        Assertions.assertNotNull((Object)body);
        Assertions.assertEquals((int)100, (int)body.length);
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetBytesOnlyStatus() {
        ResponseBase<Void, Void> response = this.createService(Service20.class).getBytesOnlyStatus(this.getRequestUri());
        Assertions.assertEquals(HttpHeaders.class, response.getHeaders().getClass());
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void service20GetBytesOnlyHeaders() {
        ResponseBase<HttpHeaders, Void> response = this.createService(Service20.class).getBytes100OnlyRawHeaders(this.getRequestUri());
        Assertions.assertEquals(HttpHeaders.class, response.getHeaders().getClass());
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertNotNull((Object)response.getHeaders());
        Assertions.assertNotEquals((int)0, (int)response.getHeaders().getSize());
    }

    @Test
    public void service20PutOnlyHeaders() {
        ResponseBase<HttpBinHeaders, Void> response = this.createService(Service20.class).putOnlyHeaders(this.getRequestUri(), "body string");
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals(HttpHeaders.class, response.getHeaders().getClass());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20PutBodyAndHeaders() {
        ResponseBase<HttpBinHeaders, HttpBinJSON> response = this.createService(Service20.class).putBodyAndHeaders(this.getRequestUri(), "body string");
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        Assertions.assertEquals(HttpHeaders.class, response.getHeaders().getClass());
        HttpBinJSON body = (HttpBinJSON)response.getValue();
        Assertions.assertNotNull((Object)body);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/put", body.url());
        Assertions.assertEquals((Object)"body string", (Object)body.data());
        HttpBinHeaders headers = (HttpBinHeaders)response.getDeserializedHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.accessControlAllowCredentials());
        Assertions.assertNotNull((Object)headers.date());
        Assertions.assertNotEquals((Object)0, (Object)headers.xProcessedTime());
    }

    @Test
    public void service20GetVoidResponse() {
        Response<Void> response = this.createService(Service20.class).getVoidResponse(this.getRequestUri());
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
    }

    @Test
    public void service20GetResponseBody() {
        Response<HttpBinJSON> response = this.createService(Service20.class).putBody(this.getRequestUri(), "body string");
        Assertions.assertNotNull(response);
        Assertions.assertEquals((int)200, (int)response.getStatusCode());
        HttpBinJSON body = (HttpBinJSON)response.getValue();
        Assertions.assertNotNull((Object)body);
        HttpClientTests.assertMatchWithHttpOrHttps("localhost/put", body.url());
        Assertions.assertEquals((Object)"body string", (Object)body.data());
        HttpHeaders headers = response.getHeaders();
        Assertions.assertNotNull((Object)headers);
    }

    @Test
    public void unexpectedHTTPOK() {
        HttpResponseException e = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> this.createService(UnexpectedOKService.class).getBytes(this.getRequestUri()));
        Assertions.assertEquals((Object)"Status code 200, (1024-byte body)", (Object)e.getMessage());
    }

    @Test
    public void service21GetBytes100() {
        byte[] bytes = this.createService(Service21.class).getBytes100(this.getRequestUri());
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)100, (int)bytes.length);
    }

    @ParameterizedTest
    @MethodSource(value={"downloadTestArgumentProvider"})
    public void simpleDownloadTest(Context context) {
        StepVerifier.create((Publisher)Flux.using(() -> this.createService(DownloadService.class).getBytes(this.getRequestUri(), context), response -> response.getValue().map(Buffer::remaining).reduce((Object)0, Integer::sum), StreamResponse::close)).assertNext(count -> Assertions.assertEquals((int)30720, (Integer)count)).verifyComplete();
        StepVerifier.create((Publisher)Flux.using(() -> this.createService(DownloadService.class).getBytes(this.getRequestUri(), context), response -> Mono.zip(MessageDigestUtils.md5((Flux<ByteBuffer>)response.getValue()), (Mono)Mono.just((Object)response.getHeaders().getValue(HttpHeaderName.ETAG))), StreamResponse::close)).assertNext(hashTuple -> Assertions.assertEquals((Object)hashTuple.getT2(), (Object)hashTuple.getT1())).verifyComplete();
    }

    @ParameterizedTest
    @MethodSource(value={"downloadTestArgumentProvider"})
    public void simpleDownloadTestAsync(Context context) {
        StepVerifier.create((Publisher)this.createService(DownloadService.class).getBytesAsync(this.getRequestUri(), context).flatMap(response -> response.getValue().map(Buffer::remaining).reduce((Object)0, Integer::sum).doFinally(ignore -> response.close()))).assertNext(count -> Assertions.assertEquals((int)30720, (Integer)count)).verifyComplete();
        StepVerifier.create((Publisher)this.createService(DownloadService.class).getBytesAsync(this.getRequestUri(), context).flatMap(response -> Mono.zip(MessageDigestUtils.md5((Flux<ByteBuffer>)response.getValue()), (Mono)Mono.just((Object)response.getHeaders().getValue(HttpHeaderName.ETAG))).doFinally(ignore -> response.close()))).assertNext(hashTuple -> Assertions.assertEquals((Object)hashTuple.getT2(), (Object)hashTuple.getT1())).verifyComplete();
    }

    @ParameterizedTest
    @MethodSource(value={"downloadTestArgumentProvider"})
    public void streamResponseCanTransferBody(Context context) throws IOException {
        try (StreamResponse streamResponse = this.createService(DownloadService.class).getBytes(this.getRequestUri(), context);){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            streamResponse.writeValueTo(Channels.newChannel(bos));
            Assertions.assertEquals((Object)streamResponse.getHeaders().getValue(HttpHeaderName.ETAG), (Object)MessageDigestUtils.md5(bos.toByteArray()));
        }
        Path tempFile = Files.createTempFile("streamResponseCanTransferBody", null, new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        try (StreamResponse streamResponse = this.createService(DownloadService.class).getBytes(this.getRequestUri(), context);){
            StepVerifier.create((Publisher)Mono.using(() -> IOUtils.toAsynchronousByteChannel((AsynchronousFileChannel)AsynchronousFileChannel.open(tempFile, StandardOpenOption.WRITE), (long)0L), arg_0 -> ((StreamResponse)streamResponse).writeValueToAsync(arg_0), channel -> {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }).then(Mono.fromCallable(() -> MessageDigestUtils.md5(Files.readAllBytes(tempFile))))).assertNext(hash -> Assertions.assertEquals((Object)streamResponse.getHeaders().getValue(HttpHeaderName.ETAG), (Object)hash)).verifyComplete();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"downloadTestArgumentProvider"})
    public void streamResponseCanTransferBodyAsync(Context context) throws IOException {
        StepVerifier.create((Publisher)this.createService(DownloadService.class).getBytesAsync(this.getRequestUri(), context).publishOn(Schedulers.boundedElastic()).map(streamResponse -> {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                streamResponse.writeValueTo(Channels.newChannel(bos));
            }
            finally {
                streamResponse.close();
            }
            return Tuples.of((Object)streamResponse.getHeaders().getValue(HttpHeaderName.ETAG), (Object)MessageDigestUtils.md5(bos.toByteArray()));
        })).assertNext(hashTuple -> Assertions.assertEquals((Object)hashTuple.getT1(), (Object)hashTuple.getT2())).verifyComplete();
        Path tempFile = Files.createTempFile("streamResponseCanTransferBody", null, new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        StepVerifier.create((Publisher)this.createService(DownloadService.class).getBytesAsync(this.getRequestUri(), context).flatMap(streamResponse -> Mono.using(() -> IOUtils.toAsynchronousByteChannel((AsynchronousFileChannel)AsynchronousFileChannel.open(tempFile, StandardOpenOption.WRITE), (long)0L), arg_0 -> ((StreamResponse)streamResponse).writeValueToAsync(arg_0), channel -> {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).doFinally(ignored -> streamResponse.close()).then(Mono.just((Object)streamResponse.getHeaders().getValue(HttpHeaderName.ETAG))))).assertNext(hash -> {
            try {
                Assertions.assertEquals((Object)hash, (Object)MessageDigestUtils.md5(Files.readAllBytes(tempFile)));
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).verifyComplete();
    }

    public static Stream<Arguments> downloadTestArgumentProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Named.named((String)"default", (Object)Context.NONE)}), Arguments.of((Object[])new Object[]{Named.named((String)"sync proxy enabled", (Object)Context.NONE.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true))}));
    }

    @Test
    public void rawFluxDownloadTest() {
        StepVerifier.create((Publisher)this.createService(DownloadService.class).getBytesFlux(this.getRequestUri()).map(Buffer::remaining).reduce((Object)0, Integer::sum)).assertNext(count -> Assertions.assertEquals((int)30720, (Integer)count)).verifyComplete();
    }

    @Test
    public void fluxUploadTest() throws Exception {
        Path filePath = Paths.get(this.getClass().getClassLoader().getResource("upload.txt").toURI());
        Flux stream = FluxUtil.readFile((AsynchronousFileChannel)AsynchronousFileChannel.open(filePath, new OpenOption[0]));
        HttpClient httpClient = this.createHttpClient();
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(httpClient).policies(new HttpPipelinePolicy[]{new PortPolicy(this.getPort(), true), new HttpLoggingPolicy(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS))}).build();
        Response<HttpBinJSON> response = ((FluxUploadService)RestProxy.create(FluxUploadService.class, (HttpPipeline)httpPipeline)).put(this.getRequestUri(), (Flux<ByteBuffer>)stream, Files.size(filePath));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)((HttpBinJSON)response.getValue()).data());
    }

    @Test
    public void segmentUploadTest() throws Exception {
        Path filePath = Paths.get(this.getClass().getClassLoader().getResource("upload.txt").toURI());
        AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(filePath, StandardOpenOption.READ);
        Response<HttpBinJSON> response = this.createService(FluxUploadService.class).put(this.getRequestUri(), (Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)fileChannel, (long)4L, (long)15L), 15L);
        Assertions.assertEquals((Object)"quick brown fox", (Object)((HttpBinJSON)response.getValue()).data());
    }

    @Test
    public void binaryDataUploadTest() throws Exception {
        Path filePath = Paths.get(this.getClass().getClassLoader().getResource("upload.txt").toURI());
        BinaryData data = BinaryData.fromFile((Path)filePath);
        HttpClient httpClient = this.createHttpClient();
        HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(httpClient).policies(new HttpPipelinePolicy[]{new PortPolicy(this.getPort(), true), new HttpLoggingPolicy(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS))}).build();
        Response<HttpBinJSON> response = ((BinaryDataUploadService)RestProxy.create(BinaryDataUploadService.class, (HttpPipeline)httpPipeline)).put(this.getServerUri(this.isSecure()), data, Files.size(filePath));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)((HttpBinJSON)response.getValue()).data());
    }

    @Test
    public void service22GetBytes() {
        byte[] bytes = this.createService(Service22.class).getBytes(this.getRequestUri() + "/bytes/27");
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)27, (int)bytes.length);
    }

    @Test
    public void service23GetBytes() {
        byte[] bytes = this.createService(Service23.class).getBytes(this.getRequestUri());
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertEquals((int)28, (int)bytes.length);
    }

    @Test
    public void service24Put() {
        HashMap<String, String> headerCollection = new HashMap<String, String>();
        headerCollection.put("DEF", "GHIJ");
        headerCollection.put("123", "45");
        HttpBinJSON result = this.createService(Service24.class).put(this.getRequestUri(), headerCollection);
        Assertions.assertNotNull(result.headers());
        HttpHeaders resultHeaders = new HttpHeaders().setAll(result.headers());
        Assertions.assertEquals((Object)"GHIJ", (Object)resultHeaders.getValue(HttpHeaderName.fromString((String)"ABCDEF")));
        Assertions.assertEquals((Object)"45", (Object)resultHeaders.getValue(HttpHeaderName.fromString((String)"ABC123")));
    }

    @Test
    public void postUrlForm() {
        Service26 service = this.createService(Service26.class);
        HttpBinFormDataJSON response = service.postForm(this.getRequestUri(), "Foo", "123", "foo@bar.com", HttpBinFormDataJSON.PizzaSize.LARGE, Arrays.asList("Bacon", "Onion"));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.form());
        Assertions.assertEquals((Object)"Foo", (Object)response.form().customerName());
        Assertions.assertEquals((Object)"123", (Object)response.form().customerTelephone());
        Assertions.assertEquals((Object)"foo%40bar.com", (Object)response.form().customerEmail());
        Assertions.assertEquals((Object)((Object)HttpBinFormDataJSON.PizzaSize.LARGE), (Object)((Object)response.form().pizzaSize()));
        Assertions.assertEquals((int)2, (int)response.form().toppings().size());
        Assertions.assertEquals((Object)"Bacon", (Object)response.form().toppings().get(0));
        Assertions.assertEquals((Object)"Onion", (Object)response.form().toppings().get(1));
    }

    @Test
    public void postUrlFormEncoded() {
        Service26 service = this.createService(Service26.class);
        HttpBinFormDataJSON response = service.postEncodedForm(this.getRequestUri(), "Foo", "123", "foo@bar.com", HttpBinFormDataJSON.PizzaSize.LARGE, Arrays.asList("Bacon", "Onion"));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.form());
        Assertions.assertEquals((Object)"Foo", (Object)response.form().customerName());
        Assertions.assertEquals((Object)"123", (Object)response.form().customerTelephone());
        Assertions.assertEquals((Object)"foo@bar.com", (Object)response.form().customerEmail());
        Assertions.assertEquals((Object)((Object)HttpBinFormDataJSON.PizzaSize.LARGE), (Object)((Object)response.form().pizzaSize()));
        Assertions.assertEquals((int)2, (int)response.form().toppings().size());
        Assertions.assertEquals((Object)"Bacon", (Object)response.form().toppings().get(0));
        Assertions.assertEquals((Object)"Onion", (Object)response.form().toppings().get(1));
    }

    @Test
    public void requestOptionsChangesBody() {
        Service27 service = this.createService(Service27.class);
        HttpBinJSON response = service.put(this.getServerUri(this.isSecure()), 42, new RequestOptions().setBody(BinaryData.fromString((String)"24")));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.data());
        Assertions.assertTrue((boolean)(response.data() instanceof String));
        Assertions.assertEquals((Object)"24", (Object)response.data());
    }

    @Test
    public void requestOptionsChangesBodyAndContentLength() {
        Service27 service = this.createService(Service27.class);
        HttpBinJSON response = service.put(this.getServerUri(this.isSecure()), 42, new RequestOptions().setBody(BinaryData.fromString((String)"4242")).setHeader(HttpHeaderName.CONTENT_LENGTH, "4"));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.data());
        Assertions.assertTrue((boolean)(response.data() instanceof String));
        Assertions.assertEquals((Object)"4242", (Object)response.data());
        Assertions.assertEquals((Object)"4", (Object)response.getHeaderValue("Content-Length"));
    }

    @Test
    public void requestOptionsAddAHeader() {
        Service27 service = this.createService(Service27.class);
        HttpBinJSON response = service.put(this.getServerUri(this.isSecure()), 42, new RequestOptions().addHeader(RANDOM_HEADER, "randomValue"));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.data());
        Assertions.assertTrue((boolean)(response.data() instanceof String));
        Assertions.assertEquals((Object)"42", (Object)response.data());
        Assertions.assertEquals((Object)"randomValue", (Object)response.getHeaderValue("randomHeader"));
    }

    @Test
    public void requestOptionsSetsAHeader() {
        Service27 service = this.createService(Service27.class);
        HttpBinJSON response = service.put(this.getServerUri(this.isSecure()), 42, new RequestOptions().addHeader(RANDOM_HEADER, "randomValue").setHeader(RANDOM_HEADER, "randomValue2"));
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.data());
        Assertions.assertTrue((boolean)(response.data() instanceof String));
        Assertions.assertEquals((Object)"42", (Object)response.data());
        Assertions.assertEquals((Object)"randomValue2", (Object)response.getHeaderValue("randomHeader"));
    }

    @ParameterizedTest
    @MethodSource(value={"voidDoesNotEagerlyReadResponseSupplier"})
    public void voidDoesNotEagerlyReadResponse(BiConsumer<String, Service28> executable) {
        Assertions.assertDoesNotThrow(() -> executable.accept(this.getServerUri(this.isSecure()), this.createService(Service28.class)));
    }

    private static Stream<BiConsumer<String, Service28>> voidDoesNotEagerlyReadResponseSupplier() {
        return Stream.of((url, service28) -> service28.headvoid((String)url), (url, service28) -> service28.headVoid((String)url), (url, service28) -> service28.headResponseVoid((String)url), (url, service28) -> service28.headResponseBaseVoid((String)url), (url, service28) -> service28.headMonoVoid((String)url).block(), (url, service28) -> service28.headMonoResponseVoid((String)url).block(), (url, service28) -> service28.headMonoResponseBaseVoid((String)url).block());
    }

    @ParameterizedTest
    @MethodSource(value={"voidErrorReturnsErrorBodySupplier"})
    public void voidErrorReturnsErrorBody(BiConsumer<String, Service29> executable) {
        HttpResponseException exception = (HttpResponseException)Assertions.assertThrows(HttpResponseException.class, () -> executable.accept(this.getServerUri(this.isSecure()), this.createService(Service29.class)));
        Assertions.assertTrue((boolean)exception.getMessage().contains("void exception body thrown"));
    }

    private static Stream<BiConsumer<String, Service29>> voidErrorReturnsErrorBodySupplier() {
        return Stream.of((url, service29) -> service29.headvoid((String)url), (url, service29) -> service29.headVoid((String)url), (url, service29) -> service29.headResponseVoid((String)url), (url, service29) -> service29.headResponseBaseVoid((String)url), (url, service29) -> service29.headMonoVoid((String)url).block(), (url, service29) -> service29.headMonoResponseVoid((String)url).block(), (url, service29) -> service29.headMonoResponseBaseVoid((String)url).block());
    }

    protected <T> T createService(Class<T> serviceClass) {
        HttpClient httpClient = this.createHttpClient();
        return this.createService(serviceClass, httpClient);
    }

    protected <T> T createService(Class<T> serviceClass, HttpClient httpClient) {
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new PortPolicy(this.getPort(), true)}).httpClient(httpClient).build();
        return (T)RestProxy.create(serviceClass, (HttpPipeline)httpPipeline);
    }

    private static void assertMatchWithHttpOrHttps(String url1, String url2) {
        String s1 = "http://" + url1;
        if (s1.equalsIgnoreCase(url2)) {
            return;
        }
        String s2 = "https://" + url1;
        if (s2.equalsIgnoreCase(url2)) {
            return;
        }
        Assertions.fail((String)("'" + url2 + "' does not match with '" + s1 + "' or '" + s2 + "'."));
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service1")
    private static interface Service1 {
        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public byte[] getByteArray(@HostParam(value="url") String var1);

        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public Mono<byte[]> getByteArrayAsync(@HostParam(value="url") String var1);

        @Get(value="bytes/100")
        public Mono<byte[]> getByteArrayAsyncWithNoExpectedResponses(@HostParam(value="url") String var1);
    }

    @Host(value="{scheme}://{hostName}")
    @ServiceInterface(name="Service2")
    private static interface Service2 {
        @Get(value="bytes/{numberOfBytes}")
        @ExpectedResponses(value={200})
        public byte[] getByteArray(@HostParam(value="scheme") String var1, @HostParam(value="hostName") String var2, @PathParam(value="numberOfBytes") int var3);

        @Get(value="bytes/{numberOfBytes}")
        @ExpectedResponses(value={200})
        public Mono<byte[]> getByteArrayAsync(@HostParam(value="scheme") String var1, @HostParam(value="hostName") String var2, @PathParam(value="numberOfBytes") int var3);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service3")
    private static interface Service3 {
        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public void getNothing(@HostParam(value="url") String var1);

        @Get(value="bytes/100")
        @ExpectedResponses(value={200})
        public Mono<Void> getNothingAsync(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service5")
    private static interface Service5 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything(@HostParam(value="url") String var1);

        @Get(value="anything/with+plus")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithPlus(@HostParam(value="url") String var1);

        @Get(value="anything/{path}")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithPathParam(@HostParam(value="url") String var1, @PathParam(value="path") String var2);

        @Get(value="anything/{path}")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithEncodedPathParam(@HostParam(value="url") String var1, @PathParam(value="path", encoded=true) String var2);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service6")
    private static interface Service6 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything(@HostParam(value="url") String var1, @QueryParam(value="a") String var2, @QueryParam(value="b") int var3);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnythingWithEncoded(@HostParam(value="url") String var1, @QueryParam(value="a", encoded=true) String var2, @QueryParam(value="b") int var3);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync(@HostParam(value="url") String var1, @QueryParam(value="a") String var2, @QueryParam(value="b") int var3);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service7")
    private static interface Service7 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        public HttpBinJSON getAnything(@HostParam(value="url") String var1, @HeaderParam(value="a") String var2, @HeaderParam(value="b") int var3);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAnythingAsync(@HostParam(value="url") String var1, @HeaderParam(value="a") String var2, @HeaderParam(value="b") int var3);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service8")
    private static interface Service8 {
        @Post(value="post")
        @ExpectedResponses(value={200})
        public HttpBinJSON post(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Post(value="post")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> postAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service9")
    private static interface Service9 {
        @Put(value="put")
        @ExpectedResponses(value={200})
        public HttpBinJSON put(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") int var2);

        @Put(value="put")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> putAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") int var2);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public HttpBinJSON putBodyAndContentLength(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") ByteBuffer var2, @HeaderParam(value="Content-Length") long var3);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public Mono<HttpBinJSON> putAsyncBodyAndContentLength(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="Content-Length") long var3);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public Mono<HttpBinJSON> putAsyncBodyAndContentLength(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") BinaryData var2, @HeaderParam(value="Content-Length") long var3);

        @Put(value="put")
        @ExpectedResponses(value={201})
        public HttpBinJSON putWithUnexpectedResponse(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public HttpBinJSON putWithUnexpectedResponseAndExceptionType(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndExceptionTypeAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={200}, value=MyRestException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public HttpBinJSON putWithUnexpectedResponseAndDeterminedExceptionType(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={200}, value=MyRestException.class), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndDeterminedExceptionTypeAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyRestException.class)})
        public HttpBinJSON putWithUnexpectedResponseAndFallthroughExceptionType(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={400}, value=HttpResponseException.class), @UnexpectedResponseExceptionType(value=MyRestException.class)})
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndFallthroughExceptionTypeAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(code={400}, value=MyRestException.class)
        public HttpBinJSON putWithUnexpectedResponseAndNoFallthroughExceptionType(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(code={400}, value=MyRestException.class)
        public Mono<HttpBinJSON> putWithUnexpectedResponseAndNoFallthroughExceptionTypeAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service10")
    private static interface Service10 {
        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Response<Void> head(@HostParam(value="url") String var1);

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public boolean headBoolean(@HostParam(value="url") String var1);

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public void voidHead(@HostParam(value="url") String var1);

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Response<Void>> headAsync(@HostParam(value="url") String var1);

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Boolean> headBooleanAsync(@HostParam(value="url") String var1);

        @Head(value="anything")
        @ExpectedResponses(value={200})
        public Mono<Void> completableHeadAsync(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service11")
    private static interface Service11 {
        @Delete(value="delete")
        @ExpectedResponses(value={200})
        public HttpBinJSON delete(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") boolean var2);

        @Delete(value="delete")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> deleteAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") boolean var2);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service12")
    private static interface Service12 {
        @Patch(value="patch")
        @ExpectedResponses(value={200})
        public HttpBinJSON patch(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Patch(value="patch")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> patchAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service13")
    private static interface Service13 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue", "MyOtherHeader:My,Header,Value"})
        public HttpBinJSON get(@HostParam(value="url") String var1);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue", "MyOtherHeader:My,Header,Value"})
        public Mono<HttpBinJSON> getAsync(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service14")
    private static interface Service14 {
        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue"})
        public HttpBinJSON get(@HostParam(value="url") String var1);

        @Get(value="anything")
        @ExpectedResponses(value={200})
        @Headers(value={"MyHeader:MyHeaderValue"})
        public Mono<HttpBinJSON> getAsync(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service16")
    private static interface Service16 {
        @Put(value="put")
        @ExpectedResponses(value={200})
        public HttpBinJSON putByteArray(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") byte[] var2);

        @Put(value="put")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> putByteArrayAsync(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") byte[] var2);
    }

    @Host(value="{scheme}://{hostPart1}{hostPart2}")
    @ServiceInterface(name="Service17")
    private static interface Service17 {
        @Get(value="get")
        @ExpectedResponses(value={200})
        public HttpBinJSON get(@HostParam(value="scheme") String var1, @HostParam(value="hostPart1") String var2, @HostParam(value="hostPart2") String var3);

        @Get(value="get")
        @ExpectedResponses(value={200})
        public Mono<HttpBinJSON> getAsync(@HostParam(value="scheme") String var1, @HostParam(value="hostPart1") String var2, @HostParam(value="hostPart2") String var3);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service18")
    private static interface Service18 {
        @Get(value="status/200")
        public void getStatus200(@HostParam(value="url") String var1);

        @Get(value="status/200")
        @ExpectedResponses(value={200})
        public void getStatus200WithExpectedResponse200(@HostParam(value="url") String var1);

        @Get(value="status/300")
        public void getStatus300(@HostParam(value="url") String var1);

        @Get(value="status/300")
        @ExpectedResponses(value={300})
        public void getStatus300WithExpectedResponse300(@HostParam(value="url") String var1);

        @Get(value="status/400")
        public void getStatus400(@HostParam(value="url") String var1);

        @Get(value="status/400")
        @ExpectedResponses(value={400})
        public void getStatus400WithExpectedResponse400(@HostParam(value="url") String var1);

        @Get(value="status/500")
        public void getStatus500(@HostParam(value="url") String var1);

        @Get(value="status/500")
        @ExpectedResponses(value={500})
        public void getStatus500WithExpectedResponse500(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service19")
    private static interface Service19 {
        @Put(value="put")
        public HttpBinJSON putWithNoContentTypeAndStringBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        public HttpBinJSON putWithNoContentTypeAndByteArrayBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") byte[] var2);

        @Put(value="put")
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndStringBody(@HostParam(value="url") String var1, @BodyParam(value="application/json") String var2);

        @Put(value="put")
        @Headers(value={"Content-Type: application/json"})
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndByteArrayBody(@HostParam(value="url") String var1, @BodyParam(value="application/json") byte[] var2);

        @Put(value="put")
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        public HttpBinJSON putWithHeaderApplicationJsonContentTypeAndCharsetAndStringBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @Headers(value={"Content-Type: application/octet-stream"})
        public HttpBinJSON putWithHeaderApplicationOctetStreamContentTypeAndStringBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        @Headers(value={"Content-Type: application/octet-stream"})
        public HttpBinJSON putWithHeaderApplicationOctetStreamContentTypeAndByteArrayBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") byte[] var2);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndStringBody(@HostParam(value="url") String var1, @BodyParam(value="application/json") String var2);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndCharsetAndStringBody(@HostParam(value="url") String var1, @BodyParam(value="application/json; charset=utf-8") String var2);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationJsonContentTypeAndByteArrayBody(@HostParam(value="url") String var1, @BodyParam(value="application/json") byte[] var2);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationOctetStreamContentTypeAndStringBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        public HttpBinJSON putWithBodyParamApplicationOctetStreamContentTypeAndByteArrayBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") byte[] var2);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service20")
    private static interface Service20 {
        @Get(value="bytes/100")
        public ResponseBase<HttpBinHeaders, Void> getBytes100OnlyHeaders(@HostParam(value="url") String var1);

        @Get(value="bytes/100")
        public ResponseBase<HttpHeaders, Void> getBytes100OnlyRawHeaders(@HostParam(value="url") String var1);

        @Get(value="bytes/100")
        public ResponseBase<HttpBinHeaders, byte[]> getBytes100BodyAndHeaders(@HostParam(value="url") String var1);

        @Put(value="put")
        public ResponseBase<HttpBinHeaders, Void> putOnlyHeaders(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Put(value="put")
        public ResponseBase<HttpBinHeaders, HttpBinJSON> putBodyAndHeaders(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);

        @Get(value="bytes/100")
        public ResponseBase<Void, Void> getBytesOnlyStatus(@HostParam(value="url") String var1);

        @Get(value="bytes/100")
        public Response<Void> getVoidResponse(@HostParam(value="url") String var1);

        @Put(value="put")
        public Response<HttpBinJSON> putBody(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") String var2);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service21")
    private static interface Service21 {
        @Get(value="/bytes/100")
        @ExpectedResponses(value={200})
        public byte[] getBytes100(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="DownloadService")
    static interface DownloadService {
        @Get(value="/bytes/30720")
        public StreamResponse getBytes(@HostParam(value="url") String var1, Context var2);

        @Get(value="/bytes/30720")
        public Mono<StreamResponse> getBytesAsync(@HostParam(value="url") String var1, Context var2);

        @Get(value="/bytes/30720")
        public Flux<ByteBuffer> getBytesFlux(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="FluxUploadService")
    static interface FluxUploadService {
        @Put(value="/put")
        public Response<HttpBinJSON> put(@HostParam(value="url") String var1, @BodyParam(value="text/plain") Flux<ByteBuffer> var2, @HeaderParam(value="Content-Length") long var3);
    }

    @Host(value="{url}")
    @ServiceInterface(name="BinaryDataUploadServ")
    static interface BinaryDataUploadService {
        @Put(value="/put")
        public Response<HttpBinJSON> put(@HostParam(value="url") String var1, @BodyParam(value="text/plain") BinaryData var2, @HeaderParam(value="Content-Length") long var3);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service22")
    static interface Service22 {
        @Get(value="/")
        public byte[] getBytes(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service23")
    static interface Service23 {
        @Get(value="bytes/28")
        public byte[] getBytes(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service24")
    static interface Service24 {
        @Put(value="put")
        public HttpBinJSON put(@HostParam(value="url") String var1, @HeaderParam(value="ABC") Map<String, String> var2);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service26")
    static interface Service26 {
        @Post(value="post")
        public HttpBinFormDataJSON postForm(@HostParam(value="url") String var1, @FormParam(value="custname") String var2, @FormParam(value="custtel") String var3, @FormParam(value="custemail") String var4, @FormParam(value="size") HttpBinFormDataJSON.PizzaSize var5, @FormParam(value="toppings") List<String> var6);

        @Post(value="post")
        public HttpBinFormDataJSON postEncodedForm(@HostParam(value="url") String var1, @FormParam(value="custname") String var2, @FormParam(value="custtel") String var3, @FormParam(value="custemail", encoded=true) String var4, @FormParam(value="size") HttpBinFormDataJSON.PizzaSize var5, @FormParam(value="toppings") List<String> var6);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service27")
    static interface Service27 {
        @Put(value="put")
        @ExpectedResponses(value={200})
        public HttpBinJSON put(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") int var2, RequestOptions var3);

        @Put(value="put")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=MyRestException.class)
        public HttpBinJSON putBodyAndContentLength(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") ByteBuffer var2, @HeaderParam(value="Content-Length") long var3, RequestOptions var5);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service29")
    public static interface Service29 {
        @Put(value="voiderrorreturned")
        @ExpectedResponses(value={200})
        public void headvoid(@HostParam(value="url") String var1);

        @Put(value="voiderrorreturned")
        @ExpectedResponses(value={200})
        public Void headVoid(@HostParam(value="url") String var1);

        @Put(value="voiderrorreturned")
        @ExpectedResponses(value={200})
        public Response<Void> headResponseVoid(@HostParam(value="url") String var1);

        @Put(value="voiderrorreturned")
        @ExpectedResponses(value={200})
        public ResponseBase<Void, Void> headResponseBaseVoid(@HostParam(value="url") String var1);

        @Put(value="voiderrorreturned")
        @ExpectedResponses(value={200})
        public Mono<Void> headMonoVoid(@HostParam(value="url") String var1);

        @Put(value="voiderrorreturned")
        @ExpectedResponses(value={200})
        public Mono<Response<Void>> headMonoResponseVoid(@HostParam(value="url") String var1);

        @Put(value="voiderrorreturned")
        @ExpectedResponses(value={200})
        public Mono<ResponseBase<Void, Void>> headMonoResponseBaseVoid(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="Service28")
    public static interface Service28 {
        @Head(value="voideagerreadoom")
        @ExpectedResponses(value={200})
        public void headvoid(@HostParam(value="url") String var1);

        @Head(value="voideagerreadoom")
        @ExpectedResponses(value={200})
        public Void headVoid(@HostParam(value="url") String var1);

        @Head(value="voideagerreadoom")
        @ExpectedResponses(value={200})
        public Response<Void> headResponseVoid(@HostParam(value="url") String var1);

        @Head(value="voideagerreadoom")
        @ExpectedResponses(value={200})
        public ResponseBase<Void, Void> headResponseBaseVoid(@HostParam(value="url") String var1);

        @Head(value="voideagerreadoom")
        @ExpectedResponses(value={200})
        public Mono<Void> headMonoVoid(@HostParam(value="url") String var1);

        @Head(value="voideagerreadoom")
        @ExpectedResponses(value={200})
        public Mono<Response<Void>> headMonoResponseVoid(@HostParam(value="url") String var1);

        @Head(value="voideagerreadoom")
        @ExpectedResponses(value={200})
        public Mono<ResponseBase<Void, Void>> headMonoResponseBaseVoid(@HostParam(value="url") String var1);
    }

    @Host(value="{url}")
    @ServiceInterface(name="UnexpectedOKService")
    static interface UnexpectedOKService {
        @Get(value="/bytes/1024")
        @ExpectedResponses(value={400})
        public StreamResponse getBytes(@HostParam(value="url") String var1);
    }

    private static class ByteArraySerializer
    implements ObjectSerializer {
        private ByteArraySerializer() {
        }

        public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
            throw new UnsupportedOperationException("Not supported");
        }

        public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
            throw new UnsupportedOperationException("Not supported");
        }

        public void serialize(OutputStream stream, Object value) {
            try {
                stream.write((byte[])value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Mono<Void> serializeAsync(OutputStream stream, Object value) {
            return Mono.fromRunnable(() -> this.serialize(stream, value));
        }
    }
}

