/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.DoNotRecord;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assumptions;

public class TestContextManager {
    private final String testName;
    private final TestMode testMode;
    private final boolean doNotRecord;
    private final boolean skipInPlayback;
    private final boolean testRan;

    public TestContextManager(Method testMethod, TestMode testMode) {
        this.testName = testMethod.getName();
        this.testMode = testMode;
        DoNotRecord doNotRecordAnnotation = testMethod.getAnnotation(DoNotRecord.class);
        if (doNotRecordAnnotation != null) {
            this.doNotRecord = true;
            this.skipInPlayback = doNotRecordAnnotation.skipInPlayback();
        } else {
            this.doNotRecord = false;
            this.skipInPlayback = false;
        }
        this.testRan = !this.skipInPlayback || testMode != TestMode.PLAYBACK;
        Assumptions.assumeTrue((boolean)this.testRan, (String)"Test does not allow playback and was ran in 'TestMode.PLAYBACK'");
    }

    public String getTestName() {
        return this.testName;
    }

    public TestMode getTestMode() {
        return this.testMode;
    }

    public boolean doNotRecordTest() {
        return this.doNotRecord;
    }

    public boolean didTestRun() {
        return this.testRan;
    }
}

