/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.test.models.RecordFilePayload;
import com.azure.core.test.models.TestProxyRequestMatcher;
import com.azure.core.test.models.TestProxySanitizer;
import com.azure.core.test.utils.HttpURLConnectionHttpClient;
import com.azure.core.test.utils.TestProxyUtils;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import reactor.core.publisher.Mono;

public class TestProxyPlaybackClient
implements HttpClient {
    private final HttpClient client;
    private final URL proxyUrl;
    private String xRecordingId;
    private String xRecordingFileLocation;
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private static final List<TestProxySanitizer> DEFAULT_SANITIZERS = TestProxyUtils.loadSanitizers();
    private final List<TestProxySanitizer> sanitizers = new ArrayList<TestProxySanitizer>();
    private final List<TestProxyRequestMatcher> matchers = new ArrayList<TestProxyRequestMatcher>();
    private final boolean skipRecordingRequestBody;

    public TestProxyPlaybackClient(HttpClient httpClient, boolean skipRecordingRequestBody) {
        this.client = httpClient == null ? new HttpURLConnectionHttpClient() : httpClient;
        this.proxyUrl = TestProxyUtils.getProxyUrl();
        this.sanitizers.addAll(DEFAULT_SANITIZERS);
        this.skipRecordingRequestBody = skipRecordingRequestBody;
    }

    public Queue<String> startPlayback(File recordFile, Path testClassPath) {
        LinkedList<String> linkedList;
        block13: {
            HttpRequest request;
            String assetJsonPath = TestProxyUtils.getAssetJsonFile(recordFile, testClassPath);
            try {
                request = new HttpRequest(HttpMethod.POST, this.proxyUrl + "/playback/start").setBody(SERIALIZER.serialize((Object)new RecordFilePayload(recordFile.toString(), assetJsonPath), SerializerEncoding.JSON)).setHeader(HttpHeaderName.ACCEPT, "application/json").setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            HttpResponse response = this.client.sendSync(request, Context.NONE);
            try {
                ArrayList<Object> toSort;
                TestProxyUtils.checkForTestProxyErrors(response);
                this.xRecordingId = response.getHeaderValue(TestingHelpers.X_RECORDING_ID);
                this.xRecordingFileLocation = new String(Base64.getUrlDecoder().decode(response.getHeaders().getValue(TestingHelpers.X_RECORDING_FILE_LOCATION)), StandardCharsets.UTF_8);
                this.addProxySanitization(this.sanitizers);
                this.addMatcherRequests(this.matchers);
                String body = (String)response.getBodyAsString().block();
                Map variables = (Map)SERIALIZER.deserialize(body, Map.class, SerializerEncoding.JSON);
                if (variables == null) {
                    toSort = new ArrayList();
                } else {
                    toSort = new ArrayList(variables.entrySet());
                    toSort.sort(Comparator.comparingInt(e -> Integer.parseInt((String)e.getKey())));
                }
                LinkedList<String> strings = new LinkedList<String>();
                for (Map.Entry entry : toSort) {
                    String value = (String)entry.getValue();
                    strings.add(value);
                }
                linkedList = strings;
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new UncheckedIOException(e3);
                }
            }
            response.close();
        }
        return linkedList;
    }

    public void stopPlayback() {
        HttpRequest request = new HttpRequest(HttpMethod.POST, this.proxyUrl + "/playback/stop").setHeader(TestingHelpers.X_RECORDING_ID, this.xRecordingId);
        this.client.sendSync(request, Context.NONE).close();
    }

    private void beforeSendingRequest(HttpRequest request) {
        if (this.xRecordingId == null) {
            throw new RuntimeException("Playback was not started before a request was sent.");
        }
        TestProxyUtils.changeHeaders(request, this.proxyUrl, this.xRecordingId, "playback", false);
    }

    private HttpResponse afterReceivedResponse(HttpResponse response) {
        TestProxyUtils.checkForTestProxyErrors(response);
        return TestProxyUtils.resetTestProxyData(response);
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        this.beforeSendingRequest(request);
        return this.client.send(request).map(this::afterReceivedResponse);
    }

    public HttpResponse sendSync(HttpRequest request, Context context) {
        this.beforeSendingRequest(request);
        HttpResponse response = this.client.sendSync(request, context);
        return this.afterReceivedResponse(response);
    }

    public void addProxySanitization(List<TestProxySanitizer> sanitizers) {
        if (this.isPlayingBack()) {
            HttpRequest request = TestProxyUtils.createAddSanitizersRequest(sanitizers, this.proxyUrl).setHeader(TestingHelpers.X_RECORDING_ID, this.xRecordingId);
            this.client.sendSync(request, Context.NONE).close();
        } else {
            this.sanitizers.addAll(sanitizers);
        }
    }

    public void addMatcherRequests(List<TestProxyRequestMatcher> matchers) {
        if (this.isPlayingBack()) {
            List<HttpRequest> matcherRequests = TestProxyUtils.getMatcherRequests(matchers, this.proxyUrl);
            if (this.skipRecordingRequestBody) {
                matcherRequests.add(TestProxyUtils.setCompareBodiesMatcher());
            }
            matcherRequests.forEach(request -> {
                request.setHeader(TestingHelpers.X_RECORDING_ID, this.xRecordingId);
                this.client.sendSync(request, Context.NONE).close();
            });
        } else {
            this.matchers.addAll(matchers);
        }
    }

    private boolean isPlayingBack() {
        return this.xRecordingId != null;
    }

    public String getRecordingFileLocation() {
        return this.xRecordingFileLocation;
    }
}

