/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.TestBase;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AzureTestWatcher
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public void beforeTestExecution(ExtensionContext context) {
        Class clazz = context.getTestClass().orElse(null);
        if (clazz != null && TestBase.class.isAssignableFrom(clazz)) {
            return;
        }
        if (!TestBase.shouldLogExecutionStatus()) {
            return;
        }
        String testName = TestBase.getTestName(context.getTestMethod(), context.getDisplayName());
        System.out.println("Starting test " + testName + ".");
        AzureTestWatcher.getStore(context).put((Object)context.getRequiredTestMethod(), (Object)System.currentTimeMillis());
    }

    public void afterTestExecution(ExtensionContext context) {
        Class clazz = context.getTestClass().orElse(null);
        if (clazz != null && TestBase.class.isAssignableFrom(clazz)) {
            return;
        }
        if (!TestBase.shouldLogExecutionStatus()) {
            return;
        }
        long startMillis = (Long)AzureTestWatcher.getStore(context).remove((Object)context.getRequiredTestMethod(), Long.TYPE);
        long duration = System.currentTimeMillis() - startMillis;
        String testName = TestBase.getTestName(context.getTestMethod(), context.getDisplayName());
        System.out.println("Finished test " + testName + " in " + duration + " ms.");
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{AzureTestWatcher.class, context}));
    }
}

