/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class LocalTestServer {
    private final Server server;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;

    public LocalTestServer(RequestHandler requestHandler) {
        this(requestHandler, 10);
    }

    public LocalTestServer(RequestHandler requestHandler, int maxThreads) {
        this.server = new Server((ThreadPool)new ExecutorThreadPool(maxThreads));
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
        this.httpConnector = new ServerConnector(this.server, new ConnectionFactory[]{httpConnectionFactory});
        this.httpConnector.setHost("localhost");
        this.server.addConnector((Connector)this.httpConnector);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        String mockKeyStore = LocalTestServer.class.getResource("/keystore.jks").toString();
        sslContextFactory.setKeyStorePath(mockKeyStore);
        sslContextFactory.setKeyStorePassword("password");
        sslContextFactory.setKeyManagerPassword("password");
        sslContextFactory.setKeyStorePath(mockKeyStore);
        sslContextFactory.setTrustStorePassword("password");
        sslContextFactory.setTrustAll(true);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, httpConnectionFactory.getProtocol());
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        this.httpsConnector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpConfiguration)});
        this.httpsConnector.setHost("localhost");
        this.server.addConnector((Connector)this.httpsConnector);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        this.server.setHandler((Handler)servletContextHandler);
        ServletHolder servletHolder = new ServletHolder((Servlet)new AzureTestHttpServlet(requestHandler));
        servletContextHandler.addServlet(servletHolder, "/");
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.server.isRunning()) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getHttpPort() {
        return this.httpConnector.getLocalPort();
    }

    public int getHttpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    public String getHttpUri() {
        return "http://localhost:" + this.getHttpPort();
    }

    public String getHttpsUri() {
        this.server.getURI();
        return "https://localhost:" + this.getHttpsPort();
    }

    private static byte[] fullyReadRequest(InputStream requestBody) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)requestBody, (OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    public static interface RequestHandler {
        public void handle(Request var1, Response var2, byte[] var3) throws IOException, ServletException;
    }

    private static final class AzureTestHttpServlet
    extends HttpServlet {
        private final RequestHandler requestHandler;

        private AzureTestHttpServlet(RequestHandler requestHandler) {
            this.requestHandler = requestHandler;
        }

        protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            byte[] requestBody = LocalTestServer.fullyReadRequest((InputStream)req.getInputStream());
            this.requestHandler.handle((Request)req, (Response)resp, requestBody);
        }
    }
}

