/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.DoNotRecord;
import com.azure.core.test.annotation.RecordWithoutRequestBody;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.junit.jupiter.api.Assumptions;

public class TestContextManager {
    private final String testName;
    private final String className;
    private final TestMode testMode;
    private final boolean enableTestProxy;
    private final boolean doNotRecord;
    private final boolean testRan;
    private Integer testIteration;
    private final boolean skipRecordingRequestBody;
    private final Path testClassPath;

    public TestContextManager(Method testMethod, TestMode testMode) {
        this(testMethod, testMode, false, false, null);
    }

    public TestContextManager(Method testMethod, TestMode testMode, boolean enableTestProxy, boolean recordWithoutRequestBodyClassAnnotation, Path testClassPath) {
        boolean skipInPlayback;
        this.testName = testMethod.getName();
        this.className = testMethod.getDeclaringClass().getSimpleName();
        this.testMode = testMode;
        this.enableTestProxy = enableTestProxy;
        RecordWithoutRequestBody recordWithoutRequestBody = testMethod.getAnnotation(RecordWithoutRequestBody.class);
        this.skipRecordingRequestBody = recordWithoutRequestBody != null || recordWithoutRequestBodyClassAnnotation;
        DoNotRecord doNotRecordAnnotation = testMethod.getAnnotation(DoNotRecord.class);
        if (doNotRecordAnnotation != null) {
            this.doNotRecord = true;
            skipInPlayback = doNotRecordAnnotation.skipInPlayback();
        } else {
            this.doNotRecord = false;
            skipInPlayback = false;
        }
        this.testClassPath = testClassPath;
        this.testRan = !skipInPlayback || testMode != TestMode.PLAYBACK;
        Assumptions.assumeTrue((boolean)this.testRan, (String)"Test does not allow playback and was ran in 'TestMode.PLAYBACK'");
    }

    public String getTestName() {
        return this.testName;
    }

    Path getTestClassPath() {
        return this.testClassPath;
    }

    public String getTestPlaybackRecordingName() {
        StringBuilder builder = new StringBuilder(this.className).append(".").append(this.testName);
        if (this.testIteration != null) {
            builder.append("[").append(this.testIteration).append("]");
        }
        return builder.toString();
    }

    public TestMode getTestMode() {
        return this.testMode;
    }

    public boolean isTestProxyEnabled() {
        return this.enableTestProxy;
    }

    public boolean doNotRecordTest() {
        return this.doNotRecord;
    }

    public boolean skipRecordingRequestBody() {
        return this.skipRecordingRequestBody;
    }

    public boolean didTestRun() {
        return this.testRan;
    }

    void setTestIteration(Integer testIteration) {
        this.testIteration = testIteration;
    }
}

