/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.junitextensions;

import com.azure.core.test.TestBase;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.RecordWithoutRequestBody;
import com.azure.core.test.implementation.TestingHelpers;
import com.azure.core.test.utils.TestUtils;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public final class TestContextManagerParameterResolver
implements ParameterResolver {
    private static final Pattern TEST_ITERATION_PATTERN = Pattern.compile("test-template-invocation:#(\\d+)");

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == TestContextManager.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        TestMode localTestMode = TestingHelpers.getTestMode();
        if (context.getTags().contains("Record")) {
            localTestMode = TestMode.RECORD;
        } else if (context.getTags().contains("Playback")) {
            localTestMode = TestMode.PLAYBACK;
        } else if (context.getTags().contains("Live")) {
            localTestMode = TestMode.LIVE;
        }
        String trackerTestName = TestingHelpers.getTestName(context.getTestMethod(), context.getDisplayName(), context.getTestClass());
        Path testClassPath = Paths.get(TestUtils.toURI(((Class)context.getTestClass().get()).getResource(((Class)context.getTestClass().get()).getSimpleName() + ".class")));
        TestContextManager testContextManager = new TestContextManager((Method)context.getTestMethod().get(), localTestMode, TestBase.isTestProxyEnabled(), ((Class)context.getTestClass().get()).getAnnotation(RecordWithoutRequestBody.class) != null, testClassPath, trackerTestName);
        testContextManager.setTestIteration(TestContextManagerParameterResolver.getTestIteration(context));
        return testContextManager;
    }

    private static Integer getTestIteration(ExtensionContext extensionContext) {
        if (extensionContext == null) {
            return null;
        }
        Matcher matcher = TEST_ITERATION_PATTERN.matcher(extensionContext.getUniqueId());
        return matcher.find() ? Integer.valueOf(matcher.group(1)) : null;
    }
}

