/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.test.TestMode;
import com.azure.core.test.annotation.DoNotRecord;
import com.azure.core.test.annotation.RecordWithoutRequestBody;
import java.lang.reflect.Method;
import java.nio.file.Path;

public class TestContextManager {
    private final String testName;
    private final String className;
    private final TestMode testMode;
    private final boolean enableTestProxy;
    private final boolean doNotRecord;
    private final boolean testRan;
    private Integer testIteration;
    private final boolean skipRecordingRequestBody;
    private final Path testClassPath;
    private final String trackerTestName;

    public TestContextManager(Method testMethod, TestMode testMode) {
        this(testMethod, testMode, false, false, null);
    }

    public TestContextManager(Method testMethod, TestMode testMode, boolean enableTestProxy, boolean recordWithoutRequestBodyClassAnnotation, Path testClassPath) {
        this(testMethod, testMode, enableTestProxy, recordWithoutRequestBodyClassAnnotation, testClassPath, testMethod.getName());
    }

    public TestContextManager(Method testMethod, TestMode testMode, boolean enableTestProxy, boolean recordWithoutRequestBodyClassAnnotation, Path testClassPath, String trackerTestName) {
        boolean skipInPlayback;
        this.testName = testMethod.getName();
        this.className = testMethod.getDeclaringClass().getSimpleName();
        this.testMode = testMode;
        this.enableTestProxy = enableTestProxy;
        RecordWithoutRequestBody recordWithoutRequestBody = testMethod.getAnnotation(RecordWithoutRequestBody.class);
        this.skipRecordingRequestBody = recordWithoutRequestBody != null || recordWithoutRequestBodyClassAnnotation;
        DoNotRecord doNotRecordAnnotation = testMethod.getAnnotation(DoNotRecord.class);
        if (doNotRecordAnnotation != null) {
            this.doNotRecord = true;
            skipInPlayback = doNotRecordAnnotation.skipInPlayback();
        } else {
            this.doNotRecord = false;
            skipInPlayback = false;
        }
        this.testClassPath = testClassPath;
        this.testRan = !skipInPlayback || testMode != TestMode.PLAYBACK;
        this.trackerTestName = trackerTestName;
    }

    public String getTestName() {
        return this.testName;
    }

    Path getTestClassPath() {
        return this.testClassPath;
    }

    public String getTestPlaybackRecordingName() {
        StringBuilder builder = new StringBuilder(this.className).append(".").append(this.testName);
        if (this.testIteration != null) {
            builder.append("[").append(this.testIteration).append("]");
        }
        return builder.toString();
    }

    public TestMode getTestMode() {
        return this.testMode;
    }

    public boolean isTestProxyEnabled() {
        return this.enableTestProxy;
    }

    public boolean doNotRecordTest() {
        return this.doNotRecord;
    }

    public boolean skipRecordingRequestBody() {
        return this.skipRecordingRequestBody;
    }

    public boolean didTestRun() {
        return this.testRan;
    }

    public void setTestIteration(Integer testIteration) {
        this.testIteration = testIteration;
    }

    public String getTrackerTestName() {
        return this.trackerTestName;
    }
}

