/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.utils;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import reactor.core.publisher.Mono;

public final class TestUtils {
    private static final ClientLogger LOGGER = new ClientLogger(TestUtils.class);
    private static final String RECORD_FOLDER = "session-records/";
    private static final HttpHeaderName UPSTREAM_URI_HEADER = HttpHeaderName.fromString((String)"X-Upstream-Base-Uri");
    private static final HttpHeaderName HTTP_FAULT_INJECTOR_RESPONSE_HEADER = HttpHeaderName.fromString((String)"x-ms-faultinjector-response-option");

    public static void assertArraysEqual(byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    public static void assertArraysEqual(byte[] expected, int expectedOffset, byte[] actual, int actualOffset, int length) {
        TestUtils.assertByteBuffersEqual(ByteBuffer.wrap(expected, expectedOffset, length), ByteBuffer.wrap(actual, actualOffset, length));
    }

    public static void assertByteBuffersEqual(ByteBuffer expected, ByteBuffer actual) {
        int expectedPosition = 0;
        int actualPosition = 0;
        if (expected != null) {
            expectedPosition = expected.position();
        }
        if (actual != null) {
            actualPosition = actual.position();
        }
        if (!Objects.equals(expected, actual)) {
            byte[] expectedArray = null;
            if (expected != null) {
                expected.position(expectedPosition);
                expectedArray = new byte[expected.remaining()];
                expected.get(expectedArray);
            }
            byte[] actualArray = null;
            if (actual != null) {
                actual.position(actualPosition);
                actualArray = new byte[actual.remaining()];
                actual.get(actualArray);
            }
            Assertions.assertArrayEquals(expectedArray, actualArray);
        }
    }

    public static File getRecordFolder() {
        URL folderUrl = TestUtils.class.getClassLoader().getResource(RECORD_FOLDER);
        if (folderUrl != null) {
            return new File(TestUtils.toURI(folderUrl));
        }
        throw new IllegalStateException("Unable to locate session-records folder. Please create a session-records folder in '/src/test/resources' of the module (ex. for azure-core-test this is '/sdk/core/azure-core-test/src/test/resources/session-records').");
    }

    public static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(ex));
        }
    }

    private TestUtils() {
    }

    public static Path getRepoRootResolveUntil(Path testClassPath, String resolveFolder) {
        Path path;
        String repoName = "\\azure-sdk-for-java";
        Path candidate = null;
        for (path = testClassPath; path != null && !path.endsWith(repoName) && !Files.exists(candidate = path.resolve(resolveFolder), new LinkOption[0]); path = path.getParent()) {
        }
        if (path == null) {
            throw new RuntimeException(String.format("Could not locate %s folder within repository %s", resolveFolder, repoName));
        }
        return path;
    }

    public static HttpClient getFaultInjectingHttpClient(HttpClient clientToWrap, boolean useHttps) {
        return TestUtils.getFaultInjectingHttpClient(clientToWrap, useHttps, 75, 24, 1);
    }

    public static HttpClient getFaultInjectingHttpClient(HttpClient clientToWrap, boolean useHttps, int successRate, int partialRate, int failureRate) {
        if (successRate + partialRate + failureRate != 100 || successRate < 0 || partialRate < 0 || failureRate < 0) {
            throw LOGGER.atError().addKeyValue("successRate", (long)successRate).addKeyValue("partialRage", (long)partialRate).addKeyValue("failureRate", (long)failureRate).log((RuntimeException)new IllegalStateException("'successRate', 'partialRate', and 'failureRate' must add to 100 and no values can be negative."));
        }
        return new HttpFaultInjectingHttpClient(clientToWrap, useHttps, successRate, partialRate);
    }

    private static final class HttpFaultInjectingHttpClient
    implements HttpClient {
        private final HttpClient wrappedHttpClient;
        private final boolean useHttps;
        private final int successRate;
        private final int partialRate;

        HttpFaultInjectingHttpClient(HttpClient wrappedHttpClient, boolean useHttps, int successRate, int partialRate) {
            this.wrappedHttpClient = wrappedHttpClient;
            this.useHttps = useHttps;
            this.successRate = successRate;
            this.partialRate = partialRate;
        }

        public Mono<HttpResponse> send(HttpRequest request) {
            return this.send(request, Context.NONE);
        }

        public Mono<HttpResponse> send(HttpRequest request, Context context) {
            URL originalUrl = request.getUrl();
            request.setHeader(UPSTREAM_URI_HEADER, originalUrl.toString()).setUrl(this.rewriteUrl(originalUrl));
            String faultType = this.faultInjectorHandling();
            request.setHeader(HTTP_FAULT_INJECTOR_RESPONSE_HEADER, faultType);
            return this.wrappedHttpClient.send(request, context).map(response -> {
                HttpRequest request1 = response.getRequest();
                request1.getHeaders().remove(UPSTREAM_URI_HEADER);
                request1.setUrl(originalUrl);
                return response;
            });
        }

        public HttpResponse sendSync(HttpRequest request, Context context) {
            URL originalUrl = request.getUrl();
            request.setHeader(UPSTREAM_URI_HEADER, originalUrl.toString()).setUrl(this.rewriteUrl(originalUrl));
            String faultType = this.faultInjectorHandling();
            request.setHeader(HTTP_FAULT_INJECTOR_RESPONSE_HEADER, faultType);
            HttpResponse response = this.wrappedHttpClient.sendSync(request, context);
            response.getRequest().setUrl(originalUrl);
            response.getRequest().getHeaders().remove(UPSTREAM_URI_HEADER);
            return response;
        }

        private URL rewriteUrl(URL originalUrl) {
            try {
                return UrlBuilder.parse((URL)originalUrl).setScheme(this.useHttps ? "https" : "http").setHost("localhost").setPort(this.useHttps ? 7778 : 7777).toUrl();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        private String faultInjectorHandling() {
            double random = ThreadLocalRandom.current().nextDouble();
            int choice = (int)(random * 100.0);
            if (choice >= 100 - this.successRate) {
                return "f";
            }
            if (choice >= 100 - this.successRate - this.partialRate) {
                if (random <= 0.34) {
                    return "n";
                }
                if (random <= 0.67) {
                    return "nc";
                }
                return "na";
            }
            if (random <= 0.25) {
                return "p";
            }
            if (random <= 0.5) {
                return "pc";
            }
            if (random <= 0.75) {
                return "pa";
            }
            return "pn";
        }
    }
}

