/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import com.azure.core.http.HttpClient;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.TestContextManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.http.PlaybackClient;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.policy.RecordNetworkCallPolicy;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InterceptorManager
implements AutoCloseable {
    private static final String RECORD_FOLDER = "session-records/";
    private final ClientLogger logger = new ClientLogger(InterceptorManager.class);
    private final Map<String, String> textReplacementRules;
    private final String testName;
    private final TestMode testMode;
    private final boolean allowedToReadRecordedValues;
    private final boolean allowedToRecordValues;
    private final RecordedData recordedData;

    @Deprecated
    public InterceptorManager(String testName, TestMode testMode) {
        this(testName, testMode, false);
    }

    public InterceptorManager(TestContextManager testContextManager) {
        this(testContextManager.getTestName(), testContextManager.getTestMode(), testContextManager.doNotRecordTest());
    }

    private InterceptorManager(String testName, TestMode testMode, boolean doNotRecord) {
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        this.testName = testName;
        this.testMode = testMode;
        this.textReplacementRules = new HashMap<String, String>();
        this.allowedToReadRecordedValues = testMode == TestMode.PLAYBACK && !doNotRecord;
        boolean bl = this.allowedToRecordValues = testMode == TestMode.RECORD && !doNotRecord;
        this.recordedData = this.allowedToReadRecordedValues ? this.readDataFromFile() : (this.allowedToRecordValues ? new RecordedData() : null);
    }

    @Deprecated
    public InterceptorManager(String testName, Map<String, String> textReplacementRules) {
        this(testName, textReplacementRules, false);
    }

    public InterceptorManager(String testName, Map<String, String> textReplacementRules, boolean doNotRecord) {
        Objects.requireNonNull(testName, "'testName' cannot be null.");
        Objects.requireNonNull(textReplacementRules, "'textReplacementRules' cannot be null.");
        this.testName = testName;
        this.testMode = TestMode.PLAYBACK;
        this.allowedToReadRecordedValues = !doNotRecord;
        this.allowedToRecordValues = false;
        this.recordedData = this.allowedToReadRecordedValues ? this.readDataFromFile() : null;
        this.textReplacementRules = textReplacementRules;
    }

    public boolean isPlaybackMode() {
        return this.testMode == TestMode.PLAYBACK;
    }

    public boolean isLiveMode() {
        return this.testMode == TestMode.LIVE;
    }

    public RecordedData getRecordedData() {
        return this.recordedData;
    }

    public HttpPipelinePolicy getRecordPolicy() {
        return new RecordNetworkCallPolicy(this.recordedData);
    }

    public HttpClient getPlaybackClient() {
        return new PlaybackClient(this.recordedData, this.textReplacementRules);
    }

    @Override
    public void close() {
        if (this.allowedToRecordValues) {
            try {
                this.writeDataToFile();
            }
            catch (IOException e) {
                this.logger.error("Unable to write data to playback file.", new Object[]{e});
            }
        }
    }

    private RecordedData readDataFromFile() {
        File recordFile = this.getRecordFile(this.testName);
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        try {
            return (RecordedData)mapper.readValue(recordFile, RecordedData.class);
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new UncheckedIOException(ex));
        }
    }

    private File getRecordFolder() {
        URL folderUrl = InterceptorManager.class.getClassLoader().getResource(".");
        return new File(folderUrl.getPath(), RECORD_FOLDER);
    }

    private File getRecordFile(String testName) {
        File playbackFile = new File(this.getRecordFolder(), testName + ".json");
        if (!playbackFile.exists()) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Missing playback file. File path: %s. ", playbackFile.getPath())));
        }
        this.logger.info("==> Playback file path: " + playbackFile.getPath());
        return playbackFile;
    }

    private void writeDataToFile() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File recordFile = this.createRecordFile(this.testName);
        mapper.writeValue(recordFile, (Object)this.recordedData);
    }

    private File createRecordFile(String testName) throws IOException {
        File recordFile;
        File recordFolder = this.getRecordFolder();
        if (!recordFolder.exists() && recordFolder.mkdir()) {
            this.logger.verbose("Created directory: {}", new Object[]{recordFolder.getPath()});
        }
        if ((recordFile = new File(recordFolder, testName + ".json")).createNewFile()) {
            this.logger.verbose("Created record file: {}", new Object[]{recordFile.getPath()});
        }
        this.logger.info("==> Playback file path: " + recordFile);
        return recordFile;
    }

    public void addTextReplacementRule(String regex, String replacement) {
        this.textReplacementRules.put(regex, replacement);
    }
}

