/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.models.NetworkCallError;
import com.azure.core.test.models.NetworkCallRecord;
import com.azure.core.test.models.RecordedData;
import com.azure.core.test.models.RecordingRedactor;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class RecordNetworkCallPolicy
implements HttpPipelinePolicy {
    private static final int DEFAULT_BUFFER_LENGTH = 1024;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String X_MS_CLIENT_REQUEST_ID = "x-ms-client-request-id";
    private static final String X_MS_ENCRYPTION_KEY_SHA256 = "x-ms-encryption-key-sha256";
    private static final String X_MS_VERSION = "x-ms-version";
    private static final String USER_AGENT = "User-Agent";
    private static final String STATUS_CODE = "StatusCode";
    private static final String BODY = "Body";
    private static final String SIG = "sig";
    private final ClientLogger logger = new ClientLogger(RecordNetworkCallPolicy.class);
    private final RecordedData recordedData;

    public RecordNetworkCallPolicy(RecordedData recordedData) {
        Objects.requireNonNull(recordedData, "'recordedData' cannot be null.");
        this.recordedData = recordedData;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        NetworkCallRecord networkCallRecord = new NetworkCallRecord();
        HashMap<String, String> headers = new HashMap<String, String>();
        this.captureRequestHeaders(context.getHttpRequest().getHeaders(), headers, X_MS_CLIENT_REQUEST_ID, CONTENT_TYPE, X_MS_VERSION, USER_AGENT);
        networkCallRecord.setHeaders(headers);
        networkCallRecord.setMethod(context.getHttpRequest().getHttpMethod().toString());
        UrlBuilder urlBuilder = UrlBuilder.parse((URL)context.getHttpRequest().getUrl());
        this.redactedAccountName(urlBuilder);
        if (urlBuilder.getQuery().containsKey(SIG)) {
            urlBuilder.setQueryParameter(SIG, "REDACTED");
        }
        networkCallRecord.setUri(urlBuilder.toString().replaceAll("\\?$", ""));
        return next.process().doOnError(throwable -> {
            networkCallRecord.setException(new NetworkCallError((Throwable)throwable));
            this.recordedData.addNetworkCall(networkCallRecord);
            throw this.logger.logExceptionAsWarning(Exceptions.propagate((Throwable)throwable));
        }).flatMap(httpResponse -> {
            HttpResponse bufferedResponse = httpResponse.buffer();
            return this.extractResponseData(bufferedResponse).map(responseData -> {
                networkCallRecord.setResponse((Map<String, String>)responseData);
                String body = (String)responseData.get(BODY);
                if (body != null && body.contains("<Status>InProgress</Status>") || Integer.parseInt((String)responseData.get(STATUS_CODE)) == 302) {
                    this.logger.info("Waiting for a response or redirection.");
                } else {
                    this.recordedData.addNetworkCall(networkCallRecord);
                }
                return bufferedResponse;
            });
        });
    }

    private void redactedAccountName(UrlBuilder urlBuilder) {
        CharSequence[] hostParts = urlBuilder.getHost().split("\\.");
        hostParts[0] = "REDACTED";
        urlBuilder.setHost(String.join((CharSequence)".", hostParts));
    }

    private void captureRequestHeaders(HttpHeaders requestHeaders, Map<String, String> captureHeaders, String ... headerNames) {
        for (String headerName : headerNames) {
            if (requestHeaders.getValue(headerName) == null) continue;
            captureHeaders.put(headerName, requestHeaders.getValue(headerName));
        }
    }

    private Mono<Map<String, String>> extractResponseData(HttpResponse response) {
        String contentType;
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put(STATUS_CODE, Integer.toString(response.getStatusCode()));
        boolean addedRetryAfter = false;
        for (HttpHeader header : response.getHeaders()) {
            String headerValueToStore = header.getValue();
            if (header.getName().equalsIgnoreCase("retry-after")) {
                headerValueToStore = "0";
                addedRetryAfter = true;
            } else if (header.getName().equalsIgnoreCase(X_MS_ENCRYPTION_KEY_SHA256)) {
                headerValueToStore = "REDACTED";
            }
            responseData.put(header.getName(), headerValueToStore);
        }
        if (!addedRetryAfter) {
            responseData.put("retry-after", "0");
        }
        if ((contentType = response.getHeaderValue(CONTENT_TYPE)) == null) {
            return response.getBodyAsByteArray().switchIfEmpty(Mono.just((Object)new byte[0])).map(bytes -> {
                if (((byte[])bytes).length == 0) {
                    return responseData;
                }
                String content = new String((byte[])bytes, StandardCharsets.UTF_8);
                responseData.put(CONTENT_LENGTH, Integer.toString(content.length()));
                responseData.put(BODY, content);
                return responseData;
            });
        }
        if (contentType.equalsIgnoreCase("application/octet-stream") || contentType.equalsIgnoreCase("avro/binary")) {
            return response.getBodyAsByteArray().switchIfEmpty(Mono.just((Object)new byte[0])).map(bytes -> {
                if (((byte[])bytes).length == 0) {
                    return responseData;
                }
                responseData.put(BODY, Arrays.toString(bytes));
                return responseData;
            });
        }
        if (contentType.contains("json") || response.getHeaderValue(CONTENT_ENCODING) == null) {
            return response.getBodyAsString(StandardCharsets.UTF_8).switchIfEmpty(Mono.just((Object)"")).map(content -> {
                responseData.put(BODY, new RecordingRedactor().redact((String)content));
                return responseData;
            });
        }
        return response.getBodyAsByteArray().switchIfEmpty(Mono.just((Object)new byte[0])).map(bytes -> {
            String content;
            block15: {
                if (((byte[])bytes).length == 0) {
                    return responseData;
                }
                if ("gzip".equalsIgnoreCase(response.getHeaderValue(CONTENT_ENCODING))) {
                    try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream((byte[])bytes));
                         ByteArrayOutputStream output = new ByteArrayOutputStream();){
                        byte[] buffer = new byte[1024];
                        int position = 0;
                        int bytesRead = gis.read(buffer, position, buffer.length);
                        while (bytesRead != -1) {
                            output.write(buffer, 0, bytesRead);
                            bytesRead = gis.read(buffer, position += bytesRead, buffer.length);
                        }
                        content = new String(output.toByteArray(), StandardCharsets.UTF_8);
                        break block15;
                    }
                    catch (IOException e) {
                        throw this.logger.logExceptionAsWarning(Exceptions.propagate((Throwable)e));
                    }
                }
                content = new String((byte[])bytes, StandardCharsets.UTF_8);
            }
            responseData.remove(CONTENT_ENCODING);
            responseData.put(CONTENT_LENGTH, Integer.toString(content.length()));
            responseData.put(BODY, content);
            return responseData;
        });
    }
}

