/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test.http;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public abstract class HttpClientTests {
    private static final String REQUEST_HOST = "http://localhost";
    private static final String PLAIN_RESPONSE = "plainBytesNoHeader";
    private static final String HEADER_RESPONSE = "plainBytesWithHeader";
    private static final String INVALID_HEADER_RESPONSE = "plainBytesInvalidHeader";
    private static final String UTF_8_BOM_RESPONSE = "utf8BomBytes";
    private static final String UTF_16BE_BOM_RESPONSE = "utf16BeBomBytes";
    private static final String UTF_16LE_BOM_RESPONSE = "utf16LeBomBytes";
    private static final String UTF_32BE_BOM_RESPONSE = "utf32BeBomBytes";
    private static final String UTF_32LE_BOM_RESPONSE = "utf32LeBomBytes";
    private static final String BOM_WITH_SAME_HEADER = "bomBytesWithSameHeader";
    private static final String BOM_WITH_DIFFERENT_HEADER = "bomBytesWithDifferentHeader";
    private static final byte[] EXPECTED_RETURN_BYTES = "Hello World!".getBytes(StandardCharsets.UTF_8);

    protected abstract HttpClient createHttpClient();

    protected abstract int getWireMockPort();

    @Test
    public void plainResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        StepVerifier.create(this.sendRequest(PLAIN_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void headerResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16BE);
        StepVerifier.create(this.sendRequest(HEADER_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void invalidHeaderResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        StepVerifier.create(this.sendRequest(INVALID_HEADER_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void utf8BomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        StepVerifier.create(this.sendRequest(UTF_8_BOM_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void utf16BeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16BE);
        StepVerifier.create(this.sendRequest(UTF_16BE_BOM_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void utf16LeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_16LE);
        StepVerifier.create(this.sendRequest(UTF_16LE_BOM_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void utf32BeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, Charset.forName("UTF-32BE"));
        StepVerifier.create(this.sendRequest(UTF_32BE_BOM_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void utf32LeBomResponse() {
        String expected = new String(EXPECTED_RETURN_BYTES, Charset.forName("UTF-32LE"));
        StepVerifier.create(this.sendRequest(UTF_32LE_BOM_RESPONSE)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void bomWithSameHeader() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        StepVerifier.create(this.sendRequest(BOM_WITH_SAME_HEADER)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void bomWithDifferentHeader() {
        String expected = new String(EXPECTED_RETURN_BYTES, StandardCharsets.UTF_8);
        StepVerifier.create(this.sendRequest(BOM_WITH_DIFFERENT_HEADER)).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    private Mono<String> sendRequest(String requestPath) {
        return this.createHttpClient().send(new HttpRequest(HttpMethod.GET, "http://localhost:" + this.getWireMockPort() + "/" + requestPath)).flatMap(HttpResponse::getBodyAsString);
    }
}

