/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.test;

import java.lang.reflect.Method;
import java.util.Objects;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AzureTestWatcher
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public void beforeTestExecution(ExtensionContext extensionContext) {
        String displayName = extensionContext.getDisplayName();
        String testName = "";
        String fullyQualifiedTestName = "";
        if (extensionContext.getTestMethod().isPresent()) {
            Method method = (Method)extensionContext.getTestMethod().get();
            testName = method.getName();
            fullyQualifiedTestName = method.getDeclaringClass().getName() + "." + testName;
        }
        StringBuilder logPrefixBuilder = new StringBuilder("Starting test ").append(fullyQualifiedTestName);
        if (!Objects.equals(displayName, testName)) {
            logPrefixBuilder.append("(").append(displayName).append(")");
        }
        logPrefixBuilder.append(",");
        AzureTestWatcher.getStore(extensionContext).put((Object)extensionContext.getRequiredTestMethod(), (Object)new TestInformation(logPrefixBuilder.toString(), System.currentTimeMillis()));
    }

    public void afterTestExecution(ExtensionContext context) {
        TestInformation testInformation = (TestInformation)AzureTestWatcher.getStore(context).remove((Object)context.getRequiredTestMethod(), TestInformation.class);
        long duration = System.currentTimeMillis() - testInformation.startMillis;
        System.out.printf("%s completed in %d ms.%n", testInformation.logPrefix, duration);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{AzureTestWatcher.class, context}));
    }

    private static final class TestInformation {
        private final String logPrefix;
        private final long startMillis;

        private TestInformation(String logPrefix, long startMillis) {
            this.logPrefix = logPrefix;
            this.startMillis = startMillis;
        }
    }
}

